/*
 * Decompiled with CFR 0.152.
 */
package sif.servlet;

import fabric.lang.security.Label;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import sif.html.HyperlinkRequest;
import sif.html.Input;
import sif.html.Node;
import sif.servlet.Action;
import sif.servlet.ActionNodePair;
import sif.servlet.HTMLWriter;
import sif.servlet.Request;
import sif.servlet.Servlet;

public class StandardHTMLWriter
extends HTMLWriter {
    private final Request request;
    private final Map<ActionNodePair, String> actionNames = new HashMap<ActionNodePair, String>();
    private Set<String> inputNames = new HashSet<String>();

    public StandardHTMLWriter(Request req, PrintWriter p, int lineWidth, String colorCoding) {
        super(p, lineWidth, colorCoding);
        this.request = req;
    }

    public StandardHTMLWriter(Request req, PrintWriter rw, String colorCoding) {
        super(rw, colorCoding);
        this.request = req;
    }

    public Request getRequest() {
        return this.request;
    }

    @Override
    protected void addInput(Input in) {
        String n = in.getName();
        if (this.inputNames.contains(n)) {
            throw new IllegalArgumentException("Duplicate input name: " + n);
        }
        this.inputNames.add(n);
    }

    @Override
    public void addAction(Action action, Node n) {
        Label level = n.getE();
        if (Servlet.debug(1)) {
            Servlet.DEBUG.println("*** HTMLWriter: adding action " + action.getExtName() + " at level " + level);
        }
        String name = this.request.servlet.addAction(action, level, this.request);
        this.actionNames.put(new ActionNodePair(action, n), name);
    }

    @Override
    public void printServletURL() {
        this.print(StandardHTMLWriter.escape_URI(this.getRequest().servletURL()));
    }

    @Override
    public void printActionName(Action action, Node n) {
        String name = this.lookupActionName(action, n);
        this.print(name);
    }

    @Override
    public void printActionURL(Action action, Node n) {
        String name = this.lookupActionName(action, n);
        this.print(StandardHTMLWriter.escape_URI(this.getRequest().servletURL() + "?action=" + name));
    }

    @Override
    public void printHyperlinkRequestURL(Action action, HyperlinkRequest n) {
        String name = this.lookupActionName(action, n);
        this.print(StandardHTMLWriter.escape_URI(this.getRequest().servlet.createRequestURL(name, n.getInputs(), this.getRequest())));
    }

    private String lookupActionName(Action action, Node n) {
        return this.actionNames.get(new ActionNodePair(action, n));
    }
}

