/*
 * Decompiled with CFR 0.152.
 */
package sif.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import sif.servlet.CodeWriter;

public class SimplestCodeWriter
extends CodeWriter {
    PrintWriter output;
    final int width;
    final int rmargin;
    int pos;

    public SimplestCodeWriter(OutputStream o, int width_) {
        this(new PrintWriter(new OutputStreamWriter(o)), width_);
    }

    public SimplestCodeWriter(PrintWriter o, int width_) {
        this.output = o;
        int rm = this.width = width_;
        if ((rm -= 8) < this.width / 2) {
            rm = this.width / 2;
        }
        this.rmargin = rm;
        this.pos = 0;
    }

    public SimplestCodeWriter(Writer o, int width_) {
        this(new PrintWriter(o), width_);
    }

    @Override
    public void write(String s) {
        int len = s.length();
        if (len > 0) {
            this.write(s, len);
        }
    }

    @Override
    public void write(String s, int length) {
        this.output.print(s);
        this.pos += length;
    }

    @Override
    public void begin(int n) {
    }

    @Override
    public void end() {
    }

    @Override
    public void allowBreak(int n, int level, String alt, int altlen) {
        if (this.pos > this.rmargin) {
            this.newline(n);
        } else {
            this.output.print(alt);
            this.pos += altlen;
        }
    }

    @Override
    public void unifiedBreak(int n, int level, String alt, int altlen) {
        this.allowBreak(n, level, alt, altlen);
    }

    @Override
    public void newline() {
        if (this.pos > 0) {
            this.output.println();
            this.pos = 0;
        }
    }

    @Override
    public void newline(int n) {
        this.newline();
    }

    @Override
    public boolean flush() throws IOException {
        this.output.flush();
        this.pos = 0;
        return true;
    }

    @Override
    public boolean flush(boolean format) throws IOException {
        return this.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.output.close();
    }

    @Override
    public String toString() {
        return "SimplestCodeWriter";
    }
}

