/*
 * Decompiled with CFR 0.152.
 */
package sif.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Stack;
import sif.servlet.CodeWriter;

public class SimpleCodeWriter
extends CodeWriter {
    PrintWriter output;
    int width;
    int rmargin;
    int lmargin;
    boolean breakAll;
    Stack<State> lmargins;
    int pos;

    public SimpleCodeWriter(OutputStream o, int width_) {
        this(new PrintWriter(new OutputStreamWriter(o)), width_);
    }

    public SimpleCodeWriter(PrintWriter o, int width_) {
        this.output = o;
        this.rmargin = this.width = width_;
        this.adjustRmargin();
        this.breakAll = false;
        this.pos = 0;
        this.lmargins = new Stack();
    }

    public SimpleCodeWriter(Writer o, int width_) {
        this(new PrintWriter(o), width_);
    }

    private void adjustRmargin() {
        this.rmargin -= 8;
        if (this.rmargin < this.width / 2) {
            this.rmargin = this.width / 2;
        }
    }

    @Override
    public void write(String s) {
        if (s.length() > 0) {
            this.write(s, s.length());
        }
    }

    @Override
    public void write(String s, int length) {
        this.output.print(s);
        this.pos += length;
    }

    @Override
    public void begin(int n) {
        this.lmargins.push(new State(this.lmargin, this.breakAll));
        this.lmargin = this.pos + n;
    }

    @Override
    public void end() {
        State s = this.lmargins.pop();
        this.lmargin = s.lmargin;
        this.breakAll = s.breakAll;
    }

    @Override
    public void allowBreak(int n, int level, String alt, int altlen) {
        if (this.pos > this.width) {
            this.adjustRmargin();
        }
        if (this.breakAll || this.pos > this.rmargin) {
            this.newline(n);
            this.breakAll = true;
        } else {
            this.output.print(alt);
            this.pos += altlen;
        }
    }

    @Override
    public void unifiedBreak(int n, int level, String alt, int altlen) {
        this.allowBreak(n, level, alt, altlen);
    }

    private void spaces(int n) {
        for (int i = 0; i < n; ++i) {
            this.output.print(' ');
        }
    }

    @Override
    public void newline() {
        if (this.pos != this.lmargin) {
            this.output.println();
            this.pos = this.lmargin;
            this.spaces(this.lmargin);
        }
    }

    @Override
    public void newline(int n) {
        this.newline();
        this.spaces(n);
        this.pos += n;
    }

    @Override
    public boolean flush() throws IOException {
        this.output.flush();
        this.pos = 0;
        return true;
    }

    @Override
    public boolean flush(boolean format) throws IOException {
        return this.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.output.close();
    }

    @Override
    public String toString() {
        return "<SimpleCodeWriter>";
    }

    class State {
        int lmargin;
        boolean breakAll;

        State(int m, boolean b) {
            this.lmargin = m;
            b = this.breakAll;
        }
    }
}

