/*
 * Decompiled with CFR 0.152.
 */
package sif.servlet;

import fabric.lang.security.ConfPolicy;
import fabric.lang.security.Label;
import fabric.lang.security.LabelUtil;
import fabric.lang.security.Principal;
import fabric.lang.security.PrincipalUtil;
import fabric.worker.LocalStore;
import fabric.worker.Store;
import fabric.worker.Worker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jif.lang.JifObject;
import jif.lang.JifString;
import jif.util.Map;
import sif.html.Body;
import sif.html.Form;
import sif.html.Head;
import sif.html.Header;
import sif.html.Hyperlink;
import sif.html.HyperlinkRequest;
import sif.html.Input;
import sif.html.Node;
import sif.html.NodeList;
import sif.html.Page;
import sif.html.Paragraph;
import sif.html.Pre;
import sif.html.PrecomputedPage;
import sif.html.Text;
import sif.servlet.Action;
import sif.servlet.HTMLWriter;
import sif.servlet.Name;
import sif.servlet.Nonce;
import sif.servlet.Request;
import sif.servlet.SessionPrincipal;
import sif.servlet.SessionState;

public abstract class Servlet
extends HttpServlet {
    private ThreadLocal nonce;
    private java.util.Map<String, Action> startActions;
    private final Principal servletP;
    static final int DEBUG_LEVEL = -1;
    public static final PrintStream DEBUG = System.err;
    private Set<String> inputNames = new HashSet<String>();

    protected Servlet(Principal servletP) {
        this.servletP = servletP;
    }

    public final void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.nonce = new ThreadLocal(){

            protected Object initialValue() {
                try {
                    return new Nonce(Servlet.this);
                }
                catch (ServletException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.startActions = new HashMap<String, Action>();
        this.jif$invokeDefConstructor();
        this.initialize();
    }

    protected void jif$invokeDefConstructor() throws ServletException {
        throw new ServletException("Jif subclasses of Servlet must have a default constructor, i.e., a constructor with no formal arguments.");
    }

    public abstract void initialize() throws ServletException;

    public final void createPage(Request req, String title, Label cL, Label cE, Node body) {
        String style_sheet = this.getInitParameter("style_sheet_url");
        style_sheet = Servlet.relURLToAbsURL(style_sheet, req);
        String scriptFile = this.getInitParameter("javascript_url");
        scriptFile = Servlet.relURLToAbsURL(scriptFile, req);
        String colorCoding = this.getInitParameter("color_coding");
        String colorCodingFile = colorCoding != null && colorCoding.equals("true") ? Servlet.relURLToAbsURL("../preamble.js", req) : null;
        Page p = new Page(cL, cE, cL, cE, new Head(cL, cE, title, style_sheet, scriptFile, colorCodingFile), new Body(cL, cE, cL, cE, body));
        req.setReturnPage(p);
    }

    public final void createPage(Request req, String title, Label preL, Label preE, PrecomputedPage pp, Label dynL, Label dynE, NodeList args) {
        String style_sheet = this.getInitParameter("style_sheet_url");
        style_sheet = Servlet.relURLToAbsURL(style_sheet, req);
        String scriptFile = this.getInitParameter("javascript_url");
        scriptFile = Servlet.relURLToAbsURL(scriptFile, req);
        String colorCoding = this.getInitParameter("color_coding");
        String colorCodingFile = colorCoding != null && colorCoding.equals("true") ? Servlet.relURLToAbsURL("../preamble.js", req) : null;
        req.setReturnPage(pp, args, new Head(dynL, dynE, title, style_sheet, scriptFile, colorCodingFile));
    }

    private static String relURLToAbsURL(String url, Request req) {
        if (url != null && url.indexOf("://") < 0) {
            String contextURL = req.contextURL();
            if (!contextURL.endsWith("/")) {
                contextURL = contextURL + "/";
            }
            url = contextURL + url;
        }
        return url;
    }

    public final Node createForm(Label L, Label E, Action action, Label cL, Label cE, Node body) {
        return new Form(this.servletP, L, E, action, cL, cE, body);
    }

    protected Node checkLoad(Request req) throws ServletException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        long time_start = System.currentTimeMillis();
        long time_page = 0L;
        PrintWriter rw = response.getWriter();
        try {
            response.setContentType("text/html");
            if (request.getCharacterEncoding() == null) {
                request.setCharacterEncoding("ISO-8859-1");
            }
            Request req = new Request(this, request);
            this.producePage(req);
            if (Servlet.debug(1)) {
                DEBUG.println("*** writing return page");
            }
            time_page = System.currentTimeMillis();
            String colorCoding = this.getInitParameter("color_coding");
            req.writeReturnPage(rw, colorCoding);
            if (Servlet.debug(1)) {
                DEBUG.println("*** available actions are: " + this.getSessionActions(req.request));
            }
        }
        finally {
            if (rw != null) {
                rw.close();
            }
            if (Servlet.debug(1)) {
                DEBUG.println("*** finished doGet");
                long time_end = System.currentTimeMillis();
                DEBUG.println(" Total " + (time_end - time_start) + "  JSF_and_Action  " + (time_page - time_start) + " HTML_Rendering " + (time_end - time_page));
            }
        }
    }

    private final void producePage(Request req) throws IOException, ServletException {
        LabeledAction laction = null;
        String action_name = req.action_name();
        if (action_name != null) {
            laction = this.findAction(req, action_name);
        } else {
            Action a = this.findDefaultAction(req);
            if (a != null) {
                laction = req.isParamEmpty() ? new LabeledAction(a, this.trustedBySessionLabel(req)) : new LabeledAction(a, LabelUtil._Impl.noComponents());
            }
        }
        if (laction == null) {
            this.invalidActionRequested(req, action_name);
            return;
        }
        this.getSessionActions(req.request).clear();
        try {
            if (Servlet.debug(1)) {
                DEBUG.println("*** invoking action " + laction.a.getName() + " with label " + laction.L);
            }
            if (Servlet.debug(2)) {
                DEBUG.print(laction.a.getName() + " " + laction.a.getClass() + " ");
                laction.a.invoke(laction.L, req);
            } else {
                laction.a.invoke(laction.L, req);
            }
        }
        catch (ServletException se) {
            this.reportError(req.bnd, req, "Servlet exception", "Failure: Servlet Exception", "An unexpected error occurred during servlet processing: " + se.getRootCause() == null ? "" : se.toString(), se.getRootCause() == null ? se : se.getRootCause());
        }
        catch (Throwable t) {
            this.reportError(req.bnd, req, "Servlet exception", "Failure: Servlet Exception", "An unexpected exception occurred during servlet processing: ", t);
        }
        if (!req.returnPageSet()) {
            this.reportError(this.sessionPrincipalLabel(req.session), req, "Error handling request", "Error Handling Request", "The servlet did not generate any output for your request. This probably means that your request was ill-formed.");
        }
    }

    Label trustedBySessionLabel(final Request req) {
        return (Label)Worker.runInSubTransaction((Worker.Code)new Worker.Code<Label>(){

            public Label run() {
                LocalStore local = Worker.getWorker().getLocalStore();
                return LabelUtil._Impl.writerPolicyLabel((Store)local, (Principal)req.session, (Principal)req.session);
            }
        });
    }

    Label trustedBySessionLabel(final SessionPrincipal session) {
        return (Label)Worker.runInSubTransaction((Worker.Code)new Worker.Code<Label>(){

            public Label run() {
                LocalStore local = Worker.getWorker().getLocalStore();
                return LabelUtil._Impl.writerPolicyLabel((Store)local, (Principal)session, (Principal)session);
            }
        });
    }

    protected void invalidActionRequested(Request req, String action_name) throws ServletException {
        if (action_name == null) {
            this.reportError(this.sessionPrincipalLabel(req.session), req, "Access violation", "Improper request", "The request includes no action identifier.");
        }
        this.reportError(this.sessionPrincipalLabel(req.session), req, "Access violation", "Invalid Action", "The action identifier in the request is invalid: <" + action_name + ">");
    }

    private LabeledAction findAction(Request req, String action_name) {
        java.util.Map<String, LabeledAction> sessionActions = this.getSessionActions(req.request);
        if (sessionActions.containsKey(action_name)) {
            return sessionActions.get(action_name);
        }
        if (this.startActions.containsKey(action_name)) {
            Action a = this.startActions.get(action_name);
            return new LabeledAction(a, this.trustedBySessionLabel(req));
        }
        return null;
    }

    private java.util.Map<String, LabeledAction> getSessionActions(HttpServletRequest request) {
        HashMap sessionActions = (HashMap)request.getSession(true).getAttribute("session_actions");
        if (sessionActions == null) {
            sessionActions = new HashMap();
            request.getSession(true).setAttribute("session_actions", sessionActions);
        }
        return sessionActions;
    }

    protected Action defaultAction(Request req) {
        return null;
    }

    protected String defaultActionName(Request req) {
        return null;
    }

    protected void reportError(Label lbl, Request req, String title, String header, String explanation) throws ServletException {
        this.reportError(lbl, req, title, header, explanation, null);
    }

    protected void reportError(Label lbl, Request req, String title, String header, String explanation, Throwable t) throws ServletException {
        Node stackTrace;
        if (t != null) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(bs);
            t.printStackTrace(pw);
            pw.flush();
            stackTrace = new Pre(lbl, lbl, lbl, lbl, new Text(lbl, lbl, new String(bs.toByteArray()).replaceAll("\r\n", "\n")));
        } else {
            stackTrace = new Text(lbl, lbl, "");
        }
        NodeList content = new NodeList(lbl, lbl, lbl, lbl, (Node)new Paragraph(lbl, lbl, lbl, lbl, new Text(lbl, lbl, explanation)), stackTrace);
        Label none = LabelUtil._Impl.noComponents();
        Action a = this.findDefaultAction(req);
        if (a != null) {
            String url = req.contextURL();
            content = new NodeList(none, none, none, none, (Node)content, (Node)new Paragraph(none, none, none, none, new Hyperlink(this.servletP, none, none, url, "Return")));
        }
        this.createPage(req, title, none, none, new NodeList(none, none, none, none, (Node)new Header(lbl, lbl, 1, header), (Node)content));
    }

    public final Action findStartAction(String action_name) {
        if (this.startActions.containsKey(action_name)) {
            return this.startActions.get(action_name);
        }
        return null;
    }

    public final Action findStartAction(Request req, String action_name) {
        return this.findStartAction(action_name);
    }

    public final Action findDefaultAction(Request req) {
        String def_action_name = this.defaultActionName(req);
        if (def_action_name == null) {
            return this.defaultAction(req);
        }
        LabeledAction la = this.findAction(req, def_action_name);
        if (la != null) {
            return la.a;
        }
        return null;
    }

    public final String getInitParameter(String name) {
        return super.getInitParameter(name);
    }

    public final void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doGet(req, res);
    }

    public abstract String getPrivateHostID() throws ServletException;

    public final String addAction(Action a, Label L, Request req) {
        LabeledAction la = new LabeledAction(a, L);
        String name = this.generateNonce();
        this.getSessionActions(req.request).put(name, la);
        return name;
    }

    public final void addStartAction(Action a) {
        this.startActions.put(a.getExtName(), a);
    }

    public final Name generateName() {
        return ((Nonce)this.nonce.get()).generate();
    }

    public final String generateNonce() {
        return ((Nonce)this.nonce.get()).generate().toHex();
    }

    public final Node createRequest(Label L, Label E, Action a, Map inputs, Label cL, Label cE, Node body) {
        return new HyperlinkRequest(this.servletP, L, E, a, inputs, cL, cE, body);
    }

    public String createRequestURL(String actionName, Map inputs, Request req) {
        StringWriter w = new StringWriter();
        w.write(req.servletURL());
        w.write("?action=");
        w.write(HTMLWriter.escape_URI(actionName));
        if (inputs != null) {
            for (JifObject key : inputs.keySet()) {
                if (!(key instanceof JifString)) continue;
                JifString jkey = (JifString)key;
                String inputName = jkey.toString();
                JifString jval = (JifString)inputs.get((JifObject)jkey);
                String val = jval.toString();
                w.write("&");
                w.write(inputName);
                w.write("=");
                w.write(HTMLWriter.escape_URI(val));
            }
        }
        return w.toString();
    }

    public void addNamedInput(Input input) {
        String name = input.getName();
        if (this.inputNames.contains(name)) {
            throw new Error("Duplicate input name: " + name);
        }
        this.inputNames.add(name);
    }

    private Label sessionPrincipalLabel(final SessionPrincipal pp) {
        return (Label)Worker.runInSubTransaction((Worker.Code)new Worker.Code<Label>(){

            public Label run() {
                LocalStore local = Worker.getWorker().getLocalStore();
                return LabelUtil._Impl.readerPolicyLabel((Store)local, (Principal)pp, (Principal)pp);
            }
        });
    }

    protected SessionState createSessionState(Label lbl, String id, SessionPrincipal prin) {
        throw new Error("Only applications can create a session state");
    }

    protected SessionPrincipal createSessionPrincipal(String id) {
        throw new Error("Only applications can create a session principal");
    }

    public static Label getOutputChannelBound(Request request) {
        return Servlet.getOutputChannelBound((Principal)request.session);
    }

    public static Label getOutputChannelBound(final Principal session) {
        return (Label)Worker.runInSubTransaction((Worker.Code)new Worker.Code<Label>(){

            public Label run() {
                LocalStore local = Worker.getWorker().getLocalStore();
                return LabelUtil._Impl.toLabel((Store)local, (ConfPolicy)PrincipalUtil._Impl.readableByPrinPolicy((Store)local, (Principal)session));
            }
        });
    }

    public static final boolean debug(int i) {
        return i <= -1;
    }

    static class LabeledAction {
        public final Action a;
        public final Label L;

        LabeledAction(Action a, Label L) {
            this.a = a;
            this.L = L;
        }

        public String toString() {
            return "(" + this.a + "; " + this.L + ")";
        }

        public boolean equals(Object o) {
            if (o instanceof LabeledAction) {
                LabeledAction that = (LabeledAction)o;
                return that.a == this.a && that.L == this.L;
            }
            return false;
        }

        public int hashCode() {
            return (this.a == null ? 0 : this.a.hashCode()) ^ (this.L == null ? 0 : this.L.hashCode());
        }
    }
}

