/*
 * Decompiled with CFR 0.152.
 */
package sif.servlet;

import fabric.lang.security.Label;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import sif.html.Head;
import sif.html.Input;
import sif.html.InputNode;
import sif.html.NodeList;
import sif.html.Page;
import sif.html.PrecomputedPage;
import sif.servlet.Servlet;
import sif.servlet.SessionPrincipal;
import sif.servlet.SessionState;
import sif.servlet.StandardHTMLWriter;

public final class Request {
    public final Servlet servlet;
    public final SessionPrincipal session;
    public final Label bnd;
    final HttpServletRequest request;
    private boolean returnPageSet = false;
    private Page returnPage;
    private PrecomputedPage precomputedPage;
    private NodeList precomputedPageArgs;
    private Head precomputedPageHead;
    private boolean isMultipart;
    private Map<String, String> parameterMap;
    private Map<String, FileItem> fileMap = Collections.EMPTY_MAP;

    Request(Servlet srv, HttpServletRequest req) {
        this.servlet = srv;
        this.request = req;
        this.session = this.getSessionState(null).sessionPrincipal();
        this.bnd = Servlet.getOutputChannelBound(this);
        this.isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)req);
        if (!this.isMultipart) {
            this.parameterMap = req.getParameterMap();
        } else {
            this.parameterMap = new HashMap<String, String>();
            this.fileMap = new HashMap<String, FileItem>();
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setSizeMax(102400L);
            try {
                List items = upload.parseRequest(this.request);
                for (FileItem item : items) {
                    if (item.isFormField()) {
                        this.parameterMap.put(item.getFieldName(), item.getString());
                        continue;
                    }
                    this.fileMap.put(item.getFieldName(), item);
                }
            }
            catch (FileUploadException e) {
                e.printStackTrace();
            }
        }
    }

    boolean isParamEmpty() {
        return this.parameterMap.isEmpty() && this.fileMap.isEmpty();
    }

    private String getParam(String name) {
        String[] sa;
        String p = this.parameterMap.get(name);
        if (p == null) {
            return null;
        }
        if (p instanceof String) {
            return p;
        }
        if (p instanceof String[] && (sa = (String[])p).length > 0) {
            return sa[0];
        }
        return null;
    }

    public String getParam(Input inp) {
        if (inp == null) {
            return null;
        }
        return this.getParam(inp.getName());
    }

    public String getParam(Label lbl, InputNode n) {
        return this.getParam(n.input);
    }

    public InputStream getFile(Input inp) {
        String name = inp.getName();
        FileItem fi = this.fileMap.get(name);
        if (fi != null) {
            try {
                return fi.getInputStream();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public InputStream getFile(Label lbl, InputNode n) {
        return this.getFile(n.input);
    }

    public String action_name() {
        return this.getParam("action");
    }

    public String remoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String contextURL() {
        return this.request.getScheme() + "://" + this.request.getServerName() + ":" + this.request.getServerPort() + this.request.getContextPath();
    }

    public String servletURL() {
        return this.request.getRequestURL().toString();
    }

    public SessionState getSessionState(Label lbl) {
        SessionState result = (SessionState)this.request.getSession(true).getAttribute("session_state");
        if (result == null) {
            String id = this.request.getSession().getId();
            SessionPrincipal sessionPrin = this.servlet.createSessionPrincipal(id);
            Label initLbl = this.servlet.trustedBySessionLabel(sessionPrin);
            result = this.servlet.createSessionState(initLbl, id, sessionPrin);
            this.request.getSession(true).setAttribute("session_state", (Object)result);
        }
        return result;
    }

    public void invalidateSession() {
        this.request.getSession().invalidate();
    }

    public void setReturnPage(Page p) {
        this.returnPageSet = true;
        this.returnPage = p;
        this.precomputedPage = null;
        this.precomputedPageArgs = null;
        this.precomputedPageHead = null;
    }

    public void setReturnPage(PrecomputedPage pp, NodeList args, Head head) {
        this.returnPageSet = true;
        this.returnPage = null;
        this.precomputedPage = pp;
        this.precomputedPageArgs = args;
        this.precomputedPageHead = head;
    }

    public void writeReturnPage(PrintWriter w, String colorCoding) {
        if (this.returnPage != null) {
            this.returnPage.write(new StandardHTMLWriter(this, w, colorCoding), null);
        } else if (this.precomputedPage != null) {
            this.precomputedPage.write(this, w, this.precomputedPageArgs, this.precomputedPageHead);
        }
    }

    public boolean returnPageSet() {
        return this.returnPageSet;
    }
}

