/*
 * Decompiled with CFR 0.152.
 */
package sif.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import sif.servlet.AllowBreak;
import sif.servlet.BlockItem;
import sif.servlet.CodeWriter;
import sif.servlet.Item;
import sif.servlet.MaxLevels;
import sif.servlet.Newline;
import sif.servlet.Overrun;
import sif.servlet.TextItem;

public class OptimalCodeWriter
extends CodeWriter {
    BlockItem input;
    BlockItem current;
    static Item top;
    PrintWriter output;
    int width;
    static int format_calls;
    public static final boolean debug = false;
    public static final boolean trace = false;
    public static final boolean visualize = false;
    public static final boolean precompute = true;
    int trace_indent = 0;

    public OptimalCodeWriter(OutputStream o, int width_) {
        this(new PrintWriter(new OutputStreamWriter(o)), width_);
    }

    public OptimalCodeWriter(PrintWriter o, int width_) {
        this.output = o;
        this.width = width_;
        this.current = this.input = new BlockItem(null, 0);
    }

    public OptimalCodeWriter(Writer o, int width_) {
        this(new PrintWriter(o), width_);
    }

    @Override
    public void write(String s) {
        if (s.length() > 0) {
            this.write(s, s.length());
        }
    }

    @Override
    public void write(String s, int length) {
        this.current.add(new TextItem(s, length));
    }

    @Override
    public void begin(int n) {
        BlockItem b = new BlockItem(this.current, n);
        this.current.add(b);
        this.current = b;
    }

    @Override
    public void end() {
        this.current = this.current.parent;
    }

    @Override
    public void allowBreak(int n, int level, String alt, int altlen) {
        this.current.add(new AllowBreak(n, level, alt, altlen, false));
    }

    @Override
    public void unifiedBreak(int n, int level, String alt, int altlen) {
        this.current.add(new AllowBreak(n, level, alt, altlen, true));
    }

    @Override
    public void newline() {
        this.newline(0);
    }

    @Override
    public void newline(int n) {
        this.current.add(new Newline(n));
    }

    @Override
    public boolean flush() throws IOException {
        return this.flush(true);
    }

    @Override
    public boolean flush(boolean format) throws IOException {
        boolean success = true;
        format_calls = 0;
        if (format) {
            try {
                top = this.input;
                Item.format(this.input, 0, 0, this.width, this.width, new MaxLevels(Integer.MAX_VALUE, Integer.MAX_VALUE), 0, 0);
            }
            catch (Overrun o) {
                success = false;
            }
        } else {
            success = false;
        }
        this.input.sendOutput(this.output, 0, 0, success, null);
        this.output.flush();
        this.current = this.input = new BlockItem(null, 0);
        return success;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.output.close();
    }

    @Override
    public String toString() {
        return this.input.toString();
    }

    void incIndent() {
        ++this.trace_indent;
    }

    void decIndent() {
        --this.trace_indent;
        if (this.trace_indent < 0) {
            throw new RuntimeException("unmatched end");
        }
    }

    void trace(String s) {
        for (int i = 0; i < this.trace_indent; ++i) {
            System.out.print(" ");
        }
        System.out.println(s);
    }

    static {
        format_calls = 0;
    }
}

