/*
 * Decompiled with CFR 0.152.
 */
package sif.servlet;

import java.io.ByteArrayOutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import javax.servlet.ServletException;
import sif.servlet.Name;
import sif.servlet.Servlet;

public class Nonce {
    private static final int NONCE_LENGTH = 8;
    private final Servlet servlet;
    private final Random rand;

    public Nonce(Servlet srv) throws ServletException {
        this.servlet = srv;
        this.rand = this.newSecureRandom();
    }

    public Name generate() {
        byte[] bytes = new byte[8];
        this.rand.nextBytes(bytes);
        return new Name(bytes);
    }

    private SecureRandom newSecureRandom() throws ServletException {
        SecureRandom toReturn = null;
        try {
            toReturn = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServletException("Cannot construct MD5 digests.");
        }
        ByteArrayOutputStream seed = new ByteArrayOutputStream();
        String hostid = this.servlet.getPrivateHostID();
        if (hostid == null) {
            System.out.println("Error: cannot find private host ID in configuration.");
        }
        byte[] hostidbytes = hostid.getBytes();
        seed.write(hostidbytes, 0, hostidbytes.length);
        long millis = System.currentTimeMillis();
        byte[] b = new byte[]{(byte)(millis & 0xFFFFFFFFFFFFFFFFL), (byte)(millis & 0xFFL), (byte)(millis & 0xFFL), (byte)(millis & 0xFFL)};
        seed.write(b, 0, b.length);
        toReturn.setSeed(seed.toByteArray());
        return toReturn;
    }
}

