/*
 * Decompiled with CFR 0.152.
 */
package sif.servlet;

import java.io.Serializable;

public class Name
implements Serializable {
    byte[] bytes;
    int hash_code;

    Name(byte[] c) {
        this.bytes = c;
        this.hash_code = new String(this.bytes).hashCode();
    }

    private static int dehex(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Invalid hexadecimal character: " + c);
    }

    public Name(String s) {
        if (s == null || s.length() % 2 != 0) {
            throw new IllegalArgumentException("Invalid name encoding: " + s);
        }
        this.bytes = new byte[s.length() / 2];
        for (int i = 0; i < s.length() - 1; i += 2) {
            char hc = s.charAt(i);
            char lc = s.charAt(i + 1);
            this.bytes[i / 2] = (byte)(Name.dehex(hc) * 16 + Name.dehex(lc));
        }
        this.hash_code = new String(this.bytes).hashCode();
    }

    public int hashCode() {
        return this.hash_code;
    }

    public boolean equals(Object o) {
        if (o instanceof Name) {
            Name n = (Name)o;
            if (this.bytes.length != n.bytes.length) {
                return false;
            }
            for (int i = 0; i < this.bytes.length; ++i) {
                if (this.bytes[i] == n.bytes[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toHex() {
        String r = "";
        for (int i = 0; i < this.bytes.length; ++i) {
            byte b = this.bytes[i];
            int h = (b & 0xF0) >> 4;
            int l = b & 0xF;
            char hc = h < 10 ? (char)(h + 48) : (char)(h - 10 + 97);
            char lc = l < 10 ? (char)(l + 48) : (char)(l - 10 + 97);
            r = r + hc + lc;
        }
        return r;
    }
}

