/*
 * Decompiled with CFR 0.152.
 */
package sif.servlet;

import fabric.lang.security.ConfPolicy;
import fabric.lang.security.IntegPolicy;
import fabric.lang.security.Label;
import fabric.lang.security.LabelUtil;
import fabric.lang.security.Policy;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import sif.html.Body;
import sif.html.Div;
import sif.html.Form;
import sif.html.Head;
import sif.html.HyperlinkRequest;
import sif.html.Input;
import sif.html.InputNode;
import sif.html.Node;
import sif.html.NodeList;
import sif.html.Page;
import sif.html.Span;
import sif.html.TCell;
import sif.html.TRow;
import sif.html.Table;
import sif.servlet.Action;
import sif.servlet.CodeWriter;
import sif.servlet.Servlet;
import sif.servlet.SimplestCodeWriter;

public abstract class HTMLWriter {
    public final boolean labelColorCodings;
    public final boolean labelTitleCodings;
    protected final CodeWriter cw;
    private boolean verbatim = false;
    private String currentClass = null;
    private int labelNameCounter = 0;
    private final Map<String, Policy> confLatticeMap;
    private final Map<String, Policy> integLatticeMap;
    protected LevelStack levelStack = new LevelStack();
    public static final int DEFAULT_WIDTH = 80;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public HTMLWriter(PrintWriter p, String colorCoding) {
        this(p, 80, colorCoding);
    }

    public HTMLWriter(PrintWriter p, int lineWidth, String colorCoding) {
        boolean color;
        this.labelColorCodings = color = colorCoding != null && colorCoding.equals("true");
        this.labelTitleCodings = color;
        this.cw = new SimplestCodeWriter(p, lineWidth);
        if (this.labelColorCodings) {
            this.confLatticeMap = new HashMap<String, Policy>();
            this.integLatticeMap = new HashMap<String, Policy>();
        } else {
            this.confLatticeMap = null;
            this.integLatticeMap = null;
        }
    }

    private String nextUniqueLabelName() {
        return "label" + this.labelNameCounter++;
    }

    public void setLevelStack(LevelStack stack) {
        this.levelStack = stack;
    }

    protected boolean ignoreNode(Node n) {
        return n instanceof Page || n instanceof Head || n instanceof Body || n instanceof TRow || n instanceof TCell || n instanceof NodeList || n instanceof Table || n instanceof Form || n instanceof Div || n instanceof Span;
    }

    public void enterNode(Node parent, Node child) {
        if (Servlet.debug(3)) {
            Servlet.DEBUG.println("*** HTMLWriter: entering node " + child.getClass().getName());
        }
        if (child instanceof InputNode) {
            this.enterInputNode(parent, (InputNode)child);
        } else {
            boolean output = (this.labelTitleCodings || this.labelColorCodings) && !this.ignoreNode(child) && this.levelStack.needOutput(child.getL(), null);
            this.levelStack.push(child, child.getL(), null, output);
            if (output) {
                Label outLevel = this.levelStack.outputLevel();
                this.openSpan("Output is " + this.labelToString(outLevel), outLevel);
            }
        }
    }

    public void leaveNode(Node parent, Node child) {
        if (child instanceof InputNode) {
            this.leaveInputNode(parent, (InputNode)child);
        } else {
            LevelInfo li = this.levelStack.pop();
            if (li.openedTag) {
                this.closeSpan();
            }
        }
    }

    protected void enterInputNode(Node parent, InputNode n) {
        Label l = n.input.inputLbl;
        this.addInput(n.input);
        boolean output = (this.labelTitleCodings || this.labelColorCodings) && !this.ignoreNode(n) && this.levelStack.needOutput(n.getL(), l);
        this.levelStack.push(n, n.getL(), l, output);
        if (output) {
            Label outLevel = this.levelStack.outputLevel();
            this.openSpan("Input will be " + this.labelToString(l) + " :: Output is " + this.labelToString(outLevel), outLevel);
        }
    }

    protected void leaveInputNode(Node parent, InputNode n) {
        LevelInfo li = this.levelStack.pop();
        if (li.openedTag) {
            this.closeSpan();
        }
    }

    protected void openSpan(String title, Label outLevel) {
        if (!this.labelTitleCodings && !this.labelColorCodings) {
            return;
        }
        this.begin(2);
        this.cw.write("<span");
        if (this.labelTitleCodings) {
            this.cw.write(" title=");
            this.printq(title);
        }
        if (this.labelColorCodings) {
            String name = this.nextUniqueLabelName();
            this.cw.write(" conf=" + name);
            this.confLatticeMap.put(name, (Policy)outLevel.confPolicy());
            name = this.nextUniqueLabelName();
            this.cw.write(" integ=" + name);
            this.integLatticeMap.put(name, (Policy)outLevel.integPolicy());
        }
        this.cw.write(">");
        this.unifiedBreak(1);
    }

    protected void closeSpan() {
        if (!this.labelTitleCodings && !this.labelColorCodings) {
            return;
        }
        this.end();
        this.unifiedBreak(1);
        this.cw.write("</span>");
    }

    public void finishBody() {
        if (this.labelColorCodings) {
            this.colorCoding(this.confLatticeMap, "conf");
            this.colorCoding(this.integLatticeMap, "integ");
        }
    }

    private void colorCoding(Map<String, Policy> labelLattice, String uniqPrefix) {
        int j;
        int i;
        int j2;
        ConfPolicy[] confList;
        Policy[] labels;
        HashMap<Policy, Policy> labelToActual = new HashMap<Policy, Policy>();
        Vector<Integer> bottoms = new Vector<Integer>();
        if (uniqPrefix.equals("conf")) {
            labels = (Policy[])labelLattice.values().toArray(new ConfPolicy[0]);
            confList = new ConfPolicy[labels.length];
        } else {
            labels = (Policy[])labelLattice.values().toArray(new IntegPolicy[0]);
            confList = new IntegPolicy[labels.length];
        }
        int numConf = 0;
        for (int i2 = 0; i2 < labels.length; ++i2) {
            boolean isNew = true;
            for (j2 = 0; j2 < i2; ++j2) {
                if (!LabelUtil._Impl.relabelsTo((Policy)labels[i2], (Policy)labels[j2]) || !LabelUtil._Impl.relabelsTo((Policy)labels[j2], (Policy)labels[i2])) continue;
                isNew = false;
                labelToActual.put(labels[i2], labels[j2]);
                break;
            }
            if (!isNew) continue;
            confList[numConf++] = labels[i2];
            labelToActual.put(labels[i2], labels[i2]);
        }
        int[][] confTable = new int[numConf][numConf];
        for (i = 0; i < numConf; ++i) {
            for (j2 = 0; j2 < numConf; ++j2) {
                if (i == j2 || confTable[i][j2] != 0 || !LabelUtil._Impl.relabelsTo((Policy)confList[i], (Policy)confList[j2])) continue;
                confTable[i][j2] = 1;
                confTable[j2][i] = -1;
                for (int k = 0; k < numConf; ++k) {
                    if (confTable[j2][k] <= 0) continue;
                    confTable[i][k] = 2;
                    confTable[k][i] = -2;
                }
            }
        }
        for (i = 0; i < numConf; ++i) {
            boolean isBottom = true;
            for (int j3 = 0; j3 < numConf; ++j3) {
                if (i == j3) continue;
                if (confTable[i][j3] < 0) {
                    isBottom = false;
                }
                if (confTable[i][j3] <= 0) continue;
                for (int k = 0; k < numConf; ++k) {
                    if (confTable[j3][k] <= 0) continue;
                    confTable[i][k] = 2;
                    confTable[k][i] = -2;
                }
            }
            if (!isBottom) continue;
            bottoms.add(new Integer(i));
        }
        HashMap namesMap = new HashMap();
        HashMap<ConfPolicy, String> arrayObjectMap = new HashMap<ConfPolicy, String>();
        int uniqCounter = 0;
        for (int i3 = 0; i3 < bottoms.size(); ++i3) {
            int bot = (Integer)bottoms.get(i3);
            HashSet<Integer> set = new HashSet<Integer>();
            if (bottoms.size() > 1) {
                set.add(new Integer(uniqCounter++));
            }
            namesMap.put(confList[bot], set);
        }
        int[] incoming = new int[numConf];
        int[] outgoing = new int[numConf];
        for (int i4 = 0; i4 < numConf; ++i4) {
            for (j = 0; j < numConf; ++j) {
                if (confTable[i4][j] != 1) continue;
                int n = j;
                incoming[n] = incoming[n] + 1;
                int n2 = i4;
                outgoing[n2] = outgoing[n2] + 1;
            }
        }
        while (!bottoms.isEmpty()) {
            int bot = (Integer)bottoms.remove(0);
            for (j = 0; j < numConf; ++j) {
                if (confTable[bot][j] != 1) continue;
                HashSet<Integer> setPrime = (HashSet<Integer>)namesMap.get(confList[j]);
                if (setPrime == null) {
                    setPrime = new HashSet<Integer>();
                    namesMap.put(confList[j], setPrime);
                }
                setPrime.addAll((HashSet)namesMap.get(confList[bot]));
                if (outgoing[bot] > 1 || incoming[j] == 1) {
                    setPrime.add(new Integer(uniqCounter++));
                }
                bottoms.add(new Integer(j));
            }
        }
        this.cw.write("<SCRIPT>\n");
        String legMapVar = uniqPrefix + "legMap";
        String arrayVar = uniqPrefix + "Array";
        this.cw.write("var " + legMapVar + " = new Object;\n");
        this.cw.write("var " + arrayVar + " = new Array(" + numConf + ");\n");
        int maxLength = 0;
        int lblCounter = 0;
        for (int i5 = 0; i5 < numConf; ++i5) {
            Set colSet = (Set)namesMap.get(confList[i5]);
            if (colSet.size() > maxLength) {
                maxLength = colSet.size();
            }
            String newManVar = uniqPrefix + "blah" + lblCounter++;
            this.cw.write("var " + newManVar + " = new Array(" + colSet.size() + ");\n");
            arrayObjectMap.put(confList[i5], newManVar);
            this.cw.write(legMapVar + "[" + i5 + "] = \"" + confList[i5].toString() + "\";\n");
            this.cw.write(arrayVar + "[" + i5 + "] = " + newManVar + ";\n");
            Iterator it = colSet.iterator();
            int index = 0;
            while (it.hasNext()) {
                int num = (Integer)it.next();
                this.cw.write(newManVar + "[" + index++ + "] = " + num + ";\n");
            }
        }
        String mapVar = uniqPrefix + "map";
        this.cw.write("var " + mapVar + " = new Object;\n");
        for (String key : labelLattice.keySet()) {
            Policy label = labelLattice.get(key);
            Object actualLabel = labelToActual.get(label);
            this.cw.write(mapVar + "[\"" + key.toString() + "\"] = " + (String)arrayObjectMap.get(actualLabel) + ";\n");
        }
        String lengthVar = uniqPrefix + "maxLength";
        String numLabelsVar = uniqPrefix + "numLabels";
        this.cw.write("var " + lengthVar + " = " + maxLength + ";\n");
        this.cw.write("var " + numLabelsVar + " = " + numConf + ";\n");
        this.cw.write("</SCRIPT>");
    }

    public void print(String s) {
        this.cw.write(s);
    }

    public void allowBreak(int n, int level, String alt) {
        this.cw.allowBreak(n, level, alt, alt.length());
    }

    public void unifiedBreak(int level) {
        this.cw.unifiedBreak(0, level, "", 0);
    }

    public void print(int i) {
        this.print(Integer.toString(i));
    }

    public void printq(String s) {
        boolean tmp = this.verbatim;
        this.verbatim = true;
        this.print("\"");
        this.escape(s, false);
        this.print("\"");
        this.verbatim = tmp;
    }

    public void printq(int i) {
        this.printq(Integer.toString(i));
    }

    public void breakLine() {
        this.cw.allowBreak(0, 0, "", 0);
    }

    public void breakLine(int n) {
        this.cw.allowBreak(n, 0, "", 0);
    }

    public void begin() {
        this.cw.begin(0);
    }

    public void begin(int n) {
        this.cw.begin(n);
    }

    public void end() {
        this.cw.end();
    }

    public void noindent(boolean b) {
        this.verbatim = b;
    }

    public void flush() throws IOException {
        try {
            this.cw.flush();
        }
        catch (IOException e) {
            e.printStackTrace(Servlet.DEBUG);
            throw e;
        }
    }

    public void close() throws IOException {
        this.flush();
    }

    public void escape(String s) {
        this.escape(s, true);
    }

    public void escape(String s, boolean insertBreaks) {
        if (s == null) {
            return;
        }
        int breakCount = 0;
        int lastOut = -1;
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '&': {
                    this.escapeDump(lastOut, i, s);
                    this.print("&amp;");
                    breakCount += 5;
                    lastOut = i;
                    continue block6;
                }
                case '<': {
                    this.escapeDump(lastOut, i, s);
                    this.print("&lt;");
                    breakCount += 4;
                    lastOut = i;
                    continue block6;
                }
                case '>': {
                    this.escapeDump(lastOut, i, s);
                    this.print("&gt;");
                    breakCount += 4;
                    lastOut = i;
                    continue block6;
                }
                case ' ': {
                    if (this.verbatim || !insertBreaks || breakCount <= 30) {
                        ++breakCount;
                        continue block6;
                    }
                    this.escapeDump(lastOut, i, s);
                    this.cw.allowBreak(2, 1, " ", 1);
                    lastOut = i;
                    breakCount = 0;
                    continue block6;
                }
                default: {
                    char code = c;
                    if (code >= '!' && code <= '~') {
                        ++breakCount;
                        continue block6;
                    }
                    this.escapeDump(lastOut, i, s);
                    this.cw.write("&#" + code + ";");
                    lastOut = i;
                    breakCount += 7;
                }
            }
        }
        this.escapeDump(lastOut, s.length(), s);
    }

    private void escapeDump(int lastOut, int i, String s) {
        if (lastOut == i - 1) {
            return;
        }
        this.cw.write(s.substring(lastOut + 1, i));
    }

    public static String escape_URI(String s) {
        StringBuffer buf = new StringBuffer();
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append("%22");
                    continue block5;
                }
                case ' ': {
                    buf.append("%20");
                    continue block5;
                }
                case '%': {
                    buf.append("%25");
                    continue block5;
                }
                default: {
                    char code = c;
                    if (code >= '!' && code <= '~') {
                        buf.append(c);
                        continue block5;
                    }
                    buf.append("%");
                    buf.append(hex[c / 16]);
                    buf.append(hex[c % 16]);
                }
            }
        }
        return buf.toString();
    }

    public boolean produceLabelColorCodings() {
        return this.labelColorCodings;
    }

    public String currentClass() {
        return this.currentClass;
    }

    public void setClass(String class_) {
        this.currentClass = class_;
    }

    protected String labelToString(Label inputLbl) {
        if (inputLbl == null) {
            return "<null label>";
        }
        return inputLbl.toString();
    }

    public abstract void addAction(Action var1, Node var2);

    protected abstract void addInput(Input var1);

    public abstract void printServletURL();

    public abstract void printActionName(Action var1, Node var2);

    public abstract void printActionURL(Action var1, Node var2);

    public abstract void printHyperlinkRequestURL(Action var1, HyperlinkRequest var2);

    public LevelStack currentLevelStack() {
        return this.levelStack.deepClone();
    }

    public class LevelStack {
        private final List<LevelInfo> stack = new ArrayList<LevelInfo>(30);

        public LevelStack() {
        }

        private LevelStack(LevelStack ls) {
            this.stack.addAll(ls.stack);
        }

        private void push(Node n, Label outputNodeLevel, Label inputLevel, boolean openedTag) {
            LevelInfo li;
            Label currOutputLevel = null;
            Label currInputLevel = null;
            if (!this.stack.isEmpty()) {
                li = this.stack.get(this.stack.size() - 1);
                currOutputLevel = li.currOutputLvl;
                currInputLevel = li.currInputLvl;
            }
            if (openedTag) {
                currOutputLevel = outputNodeLevel;
                currInputLevel = inputLevel;
            }
            li = new LevelInfo(n, currOutputLevel, currInputLevel, openedTag);
            if (Servlet.debug(2)) {
                Servlet.DEBUG.println("*** HTMLWriter: pushing " + li);
            }
            this.stack.add(this.stack.size(), li);
        }

        private LevelInfo pop() {
            LevelInfo li = this.stack.remove(this.stack.size() - 1);
            if (Servlet.debug(2)) {
                Servlet.DEBUG.println("*** HTMLWriter: popping " + li);
            }
            return li;
        }

        private boolean needOutput(Label outputNodeLevel, Label inputLevel) {
            if (this.stack.isEmpty()) {
                return true;
            }
            LevelInfo li = this.stack.get(this.stack.size() - 1);
            return !LabelUtil._Impl.equivalentTo((Label)inputLevel, (Label)li.currInputLvl) || !LabelUtil._Impl.equivalentTo((Label)outputNodeLevel, (Label)li.currOutputLvl);
        }

        private Label outputLevel() {
            LevelInfo li = this.stack.get(this.stack.size() - 1);
            return li.currOutputLvl;
        }

        public LevelStack deepClone() {
            return new LevelStack(this);
        }
    }

    private static class LevelInfo {
        final Node n;
        final Label currOutputLvl;
        final Label currInputLvl;
        final boolean openedTag;

        LevelInfo(Node n, Label currOutputLvl, Label currInputLvl, boolean openedTag) {
            this.n = n;
            this.currOutputLvl = currOutputLvl;
            this.currInputLvl = currInputLvl;
            this.openedTag = openedTag;
        }

        public String toString() {
            return "[currOut=" + LabelUtil._Impl.toString((Label)this.currOutputLvl) + "; currInp=" + LabelUtil._Impl.toString((Label)this.currInputLvl) + "; opened=" + this.openedTag + "; " + this.n + "]";
        }
    }
}

