/*
 * Decompiled with CFR 0.152.
 */
package sif.html;

import fabric.lang.security.Label;
import fabric.lang.security.Principal;
import sif.html.Input;
import sif.html.InputNode;
import sif.servlet.HTMLWriter;
import sif.servlet.Servlet;

public class TextInput
extends InputNode {
    private final int size;
    private final String initialText;

    public TextInput(Principal servletP, Label L, Label E, Input input, int size, String initial) {
        super(servletP, L, E, input);
        this.size = size;
        this.initialText = initial;
    }

    public TextInput(Principal servletP, Label L, Label E, Servlet s, Label inputLabel, int size, String initial) {
        super(servletP, L, E, new Input(servletP, s, inputLabel));
        this.size = size;
        this.initialText = initial;
    }

    public final int getSize() {
        return this.size;
    }

    public final String getInitialText() {
        return this.initialText;
    }

    String typeName() {
        return "text";
    }

    @Override
    final void writeImpl(HTMLWriter p) {
        p.print("<input");
        p.print(" type=\"" + this.typeName() + "\"");
        p.print(" name=");
        p.printq(this.input.getName());
        p.print(" size=");
        p.printq(this.size);
        p.print(" value=");
        p.printq(this.initialText);
        p.print("/>");
    }

    public static boolean jif$Instanceof(Principal P, Label l, Label e, Object o) {
        return o instanceof TextInput && InputNode.jif$Instanceof(P, l, e, o);
    }

    public static TextInput jif$cast$sif_html_TextInput(Principal P, Label l, Label e, Object o) {
        if (o == null) {
            return null;
        }
        if (TextInput.jif$Instanceof(P, l, e, o)) {
            return (TextInput)o;
        }
        throw new ClassCastException();
    }
}

