/*
 * Decompiled with CFR 0.152.
 */
package sif.html;

import fabric.lang.security.Label;
import sif.html.Node;
import sif.html.Tag;
import sif.servlet.HTMLWriter;

public final class Table
extends Tag {
    private final Node head;
    private final Node body;
    private final int cell_spacing;
    private final boolean have_cell_spacing;

    public Table(Label L, Label E, Label hL, Label hE, Label bL, Label bE, Node h, Node b) {
        this(L, E, null, hL, hE, bL, bE, h, b);
    }

    public Table(Label L, Label E, Label hL, Label hE, Node h, Label bL, Label bE, Node b) {
        this(L, E, null, hL, hE, bL, bE, h, b);
    }

    public Table(Label L, Label E, String class_, Label hL, Label hE, Label bL, Label bE, Node h, Node b) {
        super(L, E, "table", class_);
        this.head = h;
        this.body = b;
        this.cell_spacing = 0;
        this.have_cell_spacing = false;
    }

    public Table(Label L, Label E, String class_, Label hL, Label hE, Node h, Label bL, Label bE, Node b) {
        super(L, E, "table", class_);
        this.head = h;
        this.body = b;
        this.cell_spacing = 0;
        this.have_cell_spacing = false;
    }

    public Table(Label L, Label E, Label bL, Label bE, Node b) {
        this(L, E, null, bL, bE, bL, bE, null, b);
    }

    public Table(Label L, Label E, String class_, Node h, Node b, int cellSpacing) {
        super(L, E, "table", class_);
        this.head = h;
        this.body = b;
        this.cell_spacing = cellSpacing;
        this.have_cell_spacing = true;
    }

    public Table(Label L, Label E, Node h, Node b) {
        this(L, E, null, L, E, L, E, h, b);
    }

    public Table(Label L, Label E, String class_, Node h, Node b) {
        super(L, E, "table", class_);
        this.head = h;
        this.body = b;
        this.cell_spacing = 0;
        this.have_cell_spacing = false;
    }

    public Table(Label L, Label E, Node b) {
        this(L, E, null, L, E, L, E, null, b);
    }

    @Override
    void writeOptions(HTMLWriter p) {
        if (this.have_cell_spacing) {
            p.print(" cellspacing=");
            p.printq(this.cell_spacing);
        }
    }

    @Override
    void writeRest(HTMLWriter p) {
        if (this.head != null) {
            p.begin(2);
            p.print("<thead>");
            p.unifiedBreak(1);
            this.head.write(p, this);
            p.end();
            p.unifiedBreak(1);
            p.print("</thead>");
            p.unifiedBreak(1);
        }
        p.begin(2);
        p.print("<tbody>");
        p.unifiedBreak(1);
        if (this.body != null) {
            this.body.write(p, this);
        }
        p.end();
        if (this.body != null) {
            p.unifiedBreak(1);
        }
        p.print("</tbody>");
    }

    public static boolean jif$Instanceof(Label l, Label e, Object o) {
        return o instanceof Table && Node.jif$Instanceof(l, e, o);
    }

    public static Table jif$cast$sif_html_Table(Label l, Label e, Object o) {
        if (o == null) {
            return null;
        }
        if (Table.jif$Instanceof(l, e, o)) {
            return (Table)o;
        }
        throw new ClassCastException();
    }
}

