/*
 * Decompiled with CFR 0.152.
 */
package sif.html;

import fabric.lang.security.Label;
import fabric.lang.security.LabelUtil;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sif.html.HTMLPrecomputerWriter;
import sif.html.Head;
import sif.html.Holder;
import sif.html.HyperlinkRequest;
import sif.html.Node;
import sif.html.NodeList;
import sif.servlet.ActionNodePair;
import sif.servlet.HTMLWriter;
import sif.servlet.Request;
import sif.servlet.Servlet;
import sif.servlet.StandardHTMLWriter;

public class PrecomputedPage {
    final Label L;
    private List<char[]> precomputedOutput;
    private List<Object> args;
    private Set<ActionNodePair> addedActions;
    private Map<ActionNodePair, Label> actionLevels;
    private CharArrayWriter caw;
    static final int HOLDER_SERVLET_URL = 0;
    static final int HOLDER_ACTION_NAME = 1;
    static final int HOLDER_ACTION_URL = 2;
    static final int HOLDER_HYPERLINK_REQ = 3;

    public PrecomputedPage(Label L, Label E, Node body) {
        this.L = L;
        this.precomputedOutput = new ArrayList<char[]>();
        this.args = new ArrayList<Object>();
        this.caw = new CharArrayWriter(1024);
        HTMLPrecomputerWriter w = new HTMLPrecomputerWriter(this, this.caw);
        body.write(w, null);
        try {
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace(Servlet.DEBUG);
        }
        this.addOutput();
        this.addedActions = w.addedActions;
        this.actionLevels = w.actionLevels;
    }

    private void addOutput() {
        this.caw.flush();
        char[] output = this.caw.toCharArray();
        this.caw.reset();
        this.precomputedOutput.add(output);
    }

    public void addHolder(Holder holder) {
        this.addOutput();
        this.args.add(holder);
    }

    public void addPlaceholder(HTMLWriter p) {
        this.addOutput();
        this.args.add(new HolderNode(p.currentLevelStack()));
    }

    public static boolean jif$Instanceof(Label l, Label e, Object o) {
        if (o instanceof PrecomputedPage) {
            PrecomputedPage that = (PrecomputedPage)o;
            return LabelUtil._Impl.equivalentTo((Label)that.L, (Label)l);
        }
        return false;
    }

    public static PrecomputedPage jif$cast$sif_html_Placeholder(Label l, Label e, Object o) {
        if (o == null) {
            return null;
        }
        if (PrecomputedPage.jif$Instanceof(l, e, o)) {
            return (PrecomputedPage)o;
        }
        throw new ClassCastException();
    }

    public void write(Request req, PrintWriter w, NodeList precomputedPageArgs, Head precomputedPageHead) {
        HashMap<ActionNodePair, String> actionNames = new HashMap<ActionNodePair, String>();
        for (ActionNodePair anp : this.addedActions) {
            String name = req.servlet.addAction(anp.a, this.actionLevels.get(anp), req);
            actionNames.put(anp, name);
        }
        w.println("<html>");
        if (precomputedPageHead != null) {
            StandardHTMLWriter hw = new StandardHTMLWriter(req, w, null);
            precomputedPageHead.write(hw, null);
            try {
                hw.flush();
            }
            catch (IOException e) {
                e.printStackTrace(Servlet.DEBUG);
            }
        }
        w.println("<body>");
        Iterator<char[]> text = this.precomputedOutput.iterator();
        Iterator<Object> holders = this.args.iterator();
        int index = 0;
        while (text.hasNext() && holders.hasNext()) {
            w.print(text.next());
            Object o = holders.next();
            if (o instanceof HolderNode) {
                HolderNode hn = (HolderNode)o;
                StandardHTMLWriter hw = new StandardHTMLWriter(req, w, null);
                hw.setLevelStack(hn.stack);
                Node n = null;
                try {
                    n = precomputedPageArgs.children[index++];
                    if (n != null) {
                        n.write(hw, null);
                    }
                    hw.flush();
                }
                catch (ArrayIndexOutOfBoundsException ignore) {
                }
                catch (NullPointerException ignore) {
                }
                catch (IOException e) {
                    e.printStackTrace(Servlet.DEBUG);
                }
                continue;
            }
            Holder h = (Holder)o;
            switch (h.kind) {
                case 1: {
                    w.print((String)actionNames.get(h.p));
                    break;
                }
                case 2: {
                    w.print(HTMLWriter.escape_URI(req.servletURL() + "?action=" + (String)actionNames.get(h.p)));
                    break;
                }
                case 0: {
                    w.print(HTMLWriter.escape_URI(req.servletURL()));
                    break;
                }
                case 3: {
                    w.print(HTMLWriter.escape_URI(req.servlet.createRequestURL((String)actionNames.get(h.p), ((HyperlinkRequest)h.p.n).getInputs(), req)));
                }
            }
        }
        w.print(text.next());
        w.println("</body>");
        w.println("</html>");
    }

    private static class HolderNode {
        public final HTMLWriter.LevelStack stack;

        public HolderNode(HTMLWriter.LevelStack stack) {
            this.stack = stack;
        }
    }
}

