/*
 * Decompiled with CFR 0.152.
 */
package sif.html;

import fabric.lang.security.Label;
import fabric.lang.security.Principal;
import fabric.lang.security.PrincipalUtil;
import sif.html.Container;
import sif.html.Node;
import sif.html.Text;
import sif.servlet.Action;
import sif.servlet.HTMLWriter;
import sif.servlet.Servlet;

public class Hyperlink
extends Container {
    private final String url;
    final Principal servletP;
    final Action action;

    public Hyperlink(Principal servletP, Label L, Label E, String url_, String s) {
        this(servletP, L, E, url_, L, E, (Node)new Text(L, E, s));
    }

    public Hyperlink(Principal servletP, Label L, Label E, String url_, Label cL, Label cE, Node n) {
        super(L, E, "a", cL, cE, n);
        this.servletP = servletP;
        this.url = url_;
        this.action = null;
    }

    public Hyperlink(Principal servletP, Label L, Label E, String url_, Node n) {
        super(L, E, "a", L, E, n);
        this.servletP = servletP;
        this.url = url_;
        this.action = null;
    }

    public Hyperlink(Principal servletP, Label L, Label E, Action a, String s) {
        this(servletP, L, E, a, L, E, (Node)new Text(L, E, s));
    }

    public Hyperlink(Principal servletP, Label L, Label E, Action a, Label cL, Label cE, Node n) {
        super(L, E, "a", cL, cE, n);
        this.servletP = servletP;
        this.action = a;
        this.url = null;
    }

    public Hyperlink(Principal servletP, Label L, Label E, Action a, Node n) {
        super(L, E, "a", L, E, n);
        this.servletP = servletP;
        this.action = a;
        this.url = null;
    }

    @Override
    void writeOptions(HTMLWriter p) {
        p.print(" href=");
        p.print("\"");
        this.makeURLString(p);
        p.print("\"");
    }

    void makeURLString(HTMLWriter p) {
        if (this.url != null) {
            if (Servlet.debug(3)) {
                Servlet.DEBUG.println("Making hyperlink for url " + this.url);
            }
            p.print(HTMLWriter.escape_URI(this.url));
        } else if (this.action != null) {
            if (Servlet.debug(3)) {
                Servlet.DEBUG.println("Making hyperlink for action " + this.action.getName() + " " + this.action.getClass());
            }
            p.addAction(this.action, this);
            p.printActionURL(this.action, this);
        } else if (Servlet.debug(3)) {
            Servlet.DEBUG.println("Making hyperlink for but did nothing");
        }
    }

    public static boolean jif$Instanceof(Principal P, Label l, Label e, Object o) {
        if (o instanceof Hyperlink && Node.jif$Instanceof(l, e, o)) {
            Hyperlink that = (Hyperlink)o;
            return PrincipalUtil._Impl.equivalentTo((Principal)that.servletP, (Principal)P);
        }
        return false;
    }

    public static Hyperlink jif$cast$sif_html_Hyperlink(Principal P, Label l, Label e, Object o) {
        if (o == null) {
            return null;
        }
        if (Hyperlink.jif$Instanceof(P, l, e, o)) {
            return (Hyperlink)o;
        }
        throw new ClassCastException();
    }
}

