/*
 * Decompiled with CFR 0.152.
 */
package sif.html;

import fabric.lang.security.Label;
import sif.html.Node;
import sif.servlet.HTMLWriter;

public final class Head
extends Node {
    private final String title;
    private final String styleFile;
    private final String scriptFile;
    private final String colorCodingFile;

    public Head(Label L, Label E, String title, String styleFile, String scriptFile, String colorCodingFile) {
        super(L, E);
        this.title = title;
        this.styleFile = styleFile;
        this.scriptFile = scriptFile;
        this.colorCodingFile = colorCodingFile;
    }

    @Override
    void writeImpl(HTMLWriter w) {
        w.begin(2);
        w.print("<head>");
        w.breakLine();
        w.print("<title>");
        w.escape(this.title);
        w.print("</title>");
        if (this.styleFile != null) {
            w.breakLine();
            w.print("<link ");
            w.begin();
            w.print("id=\"css\" rel=\"stylesheet\" type=\"text/css\" href=");
            w.printq(this.styleFile);
            w.print(" type=\"text/css\"/>");
            w.end();
        }
        if (this.scriptFile != null) {
            w.begin();
            w.print("<script ");
            w.begin();
            w.print("language=\"JavaScript\"");
            w.print(" type=\"text/javascript\"");
            w.print(" src=");
            w.printq(this.scriptFile);
            w.print(">");
            w.print("</script>");
            w.end();
        }
        if (this.colorCodingFile != null) {
            w.begin();
            w.print("<script ");
            w.begin();
            w.print("language=\"JavaScript\"");
            w.print(" type=\"text/javascript\"");
            w.print(" src=");
            w.printq(this.colorCodingFile);
            w.print(">");
            w.print("</script>");
            w.end();
        }
        w.end();
        w.breakLine();
        w.print("</head>");
    }

    public static boolean jif$Instanceof(Label l, Label e, Object o) {
        return o instanceof Head && Node.jif$Instanceof(l, e, o);
    }

    public static Head jif$cast$sif_html_Head(Label l, Label e, Object o) {
        if (o == null) {
            return null;
        }
        if (Head.jif$Instanceof(l, e, o)) {
            return (Head)o;
        }
        throw new ClassCastException();
    }
}

