/*
 * Decompiled with CFR 0.152.
 */
package sif.html;

import fabric.lang.security.Label;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import sif.html.Holder;
import sif.html.HyperlinkRequest;
import sif.html.Input;
import sif.html.Node;
import sif.html.PrecomputedPage;
import sif.servlet.Action;
import sif.servlet.ActionNodePair;
import sif.servlet.HTMLWriter;
import sif.servlet.Servlet;

class HTMLPrecomputerWriter
extends HTMLWriter {
    Set<ActionNodePair> addedActions = new HashSet<ActionNodePair>();
    Map<ActionNodePair, Label> actionLevels = new HashMap<ActionNodePair, Label>();
    Set<Input> addedInputs = new HashSet<Input>();
    private PrecomputedPage precomputer;

    public HTMLPrecomputerWriter(PrecomputedPage precomputer, Writer out) {
        super(new PrintWriter(out), null);
        this.precomputer = precomputer;
    }

    @Override
    public void addAction(Action action, Node n) {
        if (Servlet.debug(1)) {
            Servlet.DEBUG.println("*** HTMLWriter: adding action " + action.getName() + " at level " + n.getE());
        }
        ActionNodePair anp = new ActionNodePair(action, n);
        this.addedActions.add(anp);
        this.actionLevels.put(anp, n.getE());
    }

    @Override
    protected void addInput(Input n) {
        this.addedInputs.add(n);
    }

    @Override
    public void printServletURL() {
        try {
            this.cw.flush();
        }
        catch (IOException e) {
            e.printStackTrace(Servlet.DEBUG);
        }
        this.precomputer.addHolder(new Holder(0, null));
    }

    @Override
    public void printActionName(Action action, Node n) {
        try {
            this.cw.flush();
        }
        catch (IOException e) {
            e.printStackTrace(Servlet.DEBUG);
        }
        this.precomputer.addHolder(new Holder(1, new ActionNodePair(action, n)));
    }

    @Override
    public void printActionURL(Action action, Node n) {
        try {
            this.cw.flush();
        }
        catch (IOException e) {
            e.printStackTrace(Servlet.DEBUG);
        }
        this.precomputer.addHolder(new Holder(2, new ActionNodePair(action, n)));
    }

    @Override
    public void printHyperlinkRequestURL(Action action, HyperlinkRequest n) {
        try {
            this.cw.flush();
        }
        catch (IOException e) {
            e.printStackTrace(Servlet.DEBUG);
        }
        this.precomputer.addHolder(new Holder(3, new ActionNodePair(action, n)));
    }

    public void addPlaceholderNode(HTMLWriter p) {
        try {
            this.cw.flush();
        }
        catch (IOException e) {
            e.printStackTrace(Servlet.DEBUG);
        }
        this.precomputer.addPlaceholder(p);
    }
}

