/*
 * Decompiled with CFR 0.152.
 */
package sif.html;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;

public class ColorLattice
extends Applet
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    int numPrins = 0;
    int xref = 700;
    int yref = 100;
    TextField numPrin;
    Button submitButton;
    Vector<String> allCombs;
    static final int HSV = 0;
    static final int QUAD_CONVEX = 1;
    char[] letters = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    @Override
    public void init() {
        this.setLayout(new FlowLayout());
        this.numPrin = new TextField(30);
        this.submitButton = new Button("Submit");
        this.submitButton.addActionListener(this);
        this.submitButton.addKeyListener(this);
        this.add(this.numPrin);
        this.add(this.submitButton);
        this.setBackground(Color.WHITE);
    }

    @Override
    public void paint(Graphics g) {
        this.resize(1200, 800);
        g.setColor(Color.BLACK);
        for (int i = 0; i < this.numPrins; ++i) {
            Vector<String> prins = this.C(this.numPrins, i);
            for (int j = 0; j < prins.size(); ++j) {
                String set = prins.get(j);
                int x = this.xref + (j - prins.size() / 2) * 150;
                int y = i * 73 + this.yref;
                Color col = this.getCol(set, i, 0);
                g.setColor(col);
                g.drawString(set, x, y);
                g.drawString(col.toString().substring(14), x - 57, y + 15);
                g.fillOval(x, y + 26, 20, 20);
            }
        }
    }

    private Color getHSVCol(String set, int pos) {
        float x = 0.0f;
        for (int i = 0; i < set.length(); ++i) {
            int index = set.charAt(i) - 65;
            x = (float)((double)x + (double)((float)Math.pow(2.0, index)) / Math.pow(2.0, this.numPrins));
        }
        int scaleFactor = set.length();
        float y = 1.0f * (float)pos / (float)this.numPrins;
        float hue = (x /= (float)scaleFactor) * 360.0f;
        float saturation = 0.6f;
        float value = (float)(0.75 - (double)(y / 2.0f));
        return this.getHSVCol(hue, saturation, value);
    }

    private Color getHSVCol(float hue, float saturation, float value) {
        float blue = 0.0f;
        float green = 0.0f;
        float red = 0.0f;
        int Hi = (int)Math.floor(hue / 60.0f) % 6;
        float f = hue / 60.0f - (float)Hi;
        float p = value * (1.0f - saturation);
        float q = value * (1.0f - f * saturation);
        float t = value * (1.0f - (1.0f - f) * saturation);
        switch (Hi) {
            case 0: {
                red = value;
                green = t;
                blue = p;
                break;
            }
            case 1: {
                red = q;
                green = value;
                blue = p;
                break;
            }
            case 2: {
                red = p;
                green = value;
                blue = t;
                break;
            }
            case 3: {
                red = p;
                green = q;
                blue = value;
                break;
            }
            case 4: {
                red = t;
                green = p;
                blue = value;
                break;
            }
            case 5: {
                red = value;
                green = p;
                blue = q;
            }
        }
        return new Color(red, green, blue);
    }

    private Color getQuadConvexCol(String set, int pos) {
        float blue = 0.0f;
        float green = 0.0f;
        float red = 0.0f;
        float y = 1.0f * (float)pos / (float)this.numPrins;
        for (int i = 0; i < set.length(); ++i) {
            int index = set.charAt(i) - 65;
            float x = 1.0f * (float)index / (float)this.numPrins;
            red += x * (2.0f - x);
            green += 1.0f - x * x;
        }
        int scaleFactor = set.length();
        blue = y;
        return new Color(red /= (float)scaleFactor, green /= (float)scaleFactor, blue);
    }

    private Color getCol(String set, int pos, int option) {
        switch (option) {
            case 0: {
                return this.getHSVCol(set, pos);
            }
            case 1: {
                return this.getQuadConvexCol(set, pos);
            }
        }
        return null;
    }

    private Vector<String> genCombs(int n) {
        Vector<String> toReturn = new Vector<String>();
        this.genCombs(n, toReturn, 0, "");
        return toReturn;
    }

    private void genCombs(int n, Vector<String> combs, int level, String insert) {
        if (level == n) {
            combs.add(insert);
        } else {
            this.genCombs(n, combs, level + 1, insert + this.letters[level]);
            this.genCombs(n, combs, level + 1, insert);
        }
    }

    private Vector<String> C(int n, int r) {
        Vector<String> toReturn = new Vector<String>();
        for (int i = 0; i < this.allCombs.size(); ++i) {
            String str = this.allCombs.get(i);
            if (str.length() != r) continue;
            toReturn.add(str);
        }
        return toReturn;
    }

    @Override
    public void actionPerformed(ActionEvent act) {
        this.numPrins = Integer.parseInt(this.numPrin.getText());
        this.allCombs = this.genCombs(this.numPrins);
        this.repaint();
    }

    @Override
    public void keyTyped(KeyEvent key) {
        int code = key.getKeyCode();
        if (code == 40) {
            this.yref -= 10;
        } else if (code == 38) {
            this.yref += 10;
        } else if (code == 37) {
            this.xref += 10;
        } else if (code == 39) {
            this.xref -= 10;
        } else if (code == 36) {
            this.xref = 700;
            this.yref = 100;
        }
        this.repaint();
    }

    @Override
    public void keyPressed(KeyEvent key) {
        this.keyTyped(key);
    }

    @Override
    public void keyReleased(KeyEvent key) {
    }
}

