/*
 * Decompiled with CFR 0.152.
 */
package ppg.spec;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Vector;
import ppg.PPG;
import ppg.PPGError;
import ppg.atoms.GrammarPart;
import ppg.atoms.Nonterminal;
import ppg.atoms.Production;
import ppg.atoms.SemanticAction;
import ppg.atoms.SymbolList;
import ppg.cmds.Command;
import ppg.cmds.DropCmd;
import ppg.cmds.ExtendCmd;
import ppg.cmds.NewProdCmd;
import ppg.cmds.OverrideCmd;
import ppg.cmds.TransferCmd;
import ppg.code.ScanCode;
import ppg.lex.Lexer;
import ppg.parse.Parser;
import ppg.spec.CUPSpec;
import ppg.spec.Spec;
import ppg.util.CodeWriter;

public class PPGSpec
extends Spec {
    private String include;
    private Vector commands;
    private Vector code;
    private Spec parent;
    private Vector startSyms;

    public PPGSpec(String incFile, String pkg, Vector imp, Vector codeParts, Vector syms, Vector precedence, Vector startList, Vector cmds) {
        this.include = incFile;
        this.packageName = pkg;
        this.imports = imp;
        this.code = codeParts;
        this.symbols = syms;
        this.prec = precedence;
        this.startSyms = startList;
        this.commands = cmds;
        this.parent = null;
    }

    public boolean isMultiStartSymbol() {
        return this.startSyms.size() > 1;
    }

    public void patchMultiStartSymbols(CUPSpec cupSpec) {
        String token;
        if (!this.isMultiStartSymbol()) {
            cupSpec.setStart((String)this.startSyms.elementAt(0));
            return;
        }
        String parseCode = "";
        String currSymbolName = "ppg_curr_sym";
        parseCode = parseCode + "Symbol " + currSymbolName + ";\n\n";
        Vector<String> tokens = new Vector<String>();
        for (int i = 0; i < this.startSyms.size(); i += 2) {
            tokens.addElement("JLGEN_TOKEN_" + String.valueOf(i / 2));
        }
        for (int i = 0; i < this.startSyms.size(); i += 2) {
            String startSym = (String)this.startSyms.elementAt(i);
            String method = (String)this.startSyms.elementAt(i + 1);
            token = (String)tokens.elementAt(i / 2);
            parseCode = parseCode + "public Symbol " + method + " () throws Exception {\n" + "\t" + currSymbolName + " = " + "new Symbol(" + PPG.SYMBOL_CLASS_NAME + "." + token + ")" + ";\n" + "\t" + "return parse();\n}\n\n";
        }
        cupSpec.parserCode.append(parseCode);
        String scanCodeAdd = "\n// scan code generated by PPG\nif (" + currSymbolName + "!= null) {\n" + "\tSymbol result = " + currSymbolName + ";\n" + "\t" + currSymbolName + " = null" + ";\n" + "\treturn result;\n" + "}\n" + "// end scan code generated by PPG\n\n";
        if (cupSpec.scanCode != null) {
            cupSpec.scanCode.prepend(scanCodeAdd);
        } else {
            cupSpec.scanCode = new ScanCode(scanCodeAdd);
        }
        String newStartSym = "multi_start_symbool";
        cupSpec.setStart(newStartSym);
        Nonterminal startNT = new Nonterminal(newStartSym, null);
        Vector<String> newSymbols = new Vector<String>();
        newSymbols.addElement(newStartSym);
        SymbolList sl = new SymbolList(1, null, newSymbols);
        Vector<SymbolList> addedSymbols = new Vector<SymbolList>();
        addedSymbols.addElement(sl);
        cupSpec.addSymbols(addedSymbols);
        SymbolList tokenList = new SymbolList(0, "Symbol", tokens);
        Vector<SymbolList> addedTokens = new Vector<SymbolList>();
        addedTokens.addElement(tokenList);
        cupSpec.addSymbols(addedTokens);
        Vector rhs = new Vector();
        for (int i = 0; i < this.startSyms.size(); i += 2) {
            Vector<GrammarPart> rhsPart = new Vector<GrammarPart>();
            String startSym = (String)this.startSyms.elementAt(i);
            token = (String)tokens.elementAt(i / 2);
            rhsPart.addElement(new Nonterminal(token, null));
            rhsPart.addElement(new Nonterminal(startSym, "s"));
            rhsPart.addElement(new SemanticAction("RESULT = s;"));
            rhs.addElement(rhsPart);
        }
        Production p = new Production(startNT, rhs);
        cupSpec.addProductions(p);
    }

    public void parseChain(String basePath) {
        File file = null;
        String simpleName = this.include;
        try {
            InputStream is = ClassLoader.getSystemResourceAsStream(this.include);
            if (is != null) {
                PPG.DEBUG("found " + this.include + " as a resource");
            } else {
                String fullPath = (basePath == "" ? "" : basePath + System.getProperty("file.separator")) + this.include;
                PPG.DEBUG("looking for " + fullPath + " as a file");
                file = new File(fullPath);
                is = new FileInputStream(file);
                simpleName = file.getName();
            }
            Lexer lex = new Lexer(is, simpleName);
            Parser parser = new Parser(simpleName, lex);
            PPG.DEBUG("parsing " + simpleName);
            parser.parse();
            this.parent = (Spec)parser.getProgramNode();
            is.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("ppg: " + simpleName + " not found.");
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("ppg: Exception: " + e.getMessage());
            System.exit(1);
        }
        this.parent.setChild(this);
        String parentDir = null;
        if (file != null) {
            parentDir = file.getParent();
        }
        this.parent.parseChain(parentDir == null ? "" : parentDir);
    }

    public CUPSpec coalesce() throws PPGError {
        CUPSpec combined = this.parent.coalesce();
        CUPSpec newSpec = (CUPSpec)combined.clone();
        newSpec.setPkgName(this.packageName);
        newSpec.addImports(this.imports);
        if (this.prec == null) {
            newSpec.prec.removeAllElements();
        } else if (this.prec.size() != 0) {
            newSpec.prec.removeAllElements();
            newSpec.prec.addAll(this.prec);
        }
        newSpec.replaceCode(this.code);
        newSpec.addSymbols(this.symbols);
        if (this.child == null) {
            this.patchMultiStartSymbols(newSpec);
        }
        this.processTransferL(combined, newSpec);
        this.processDrop(combined, newSpec);
        this.processOverride(combined, newSpec);
        this.processTransferR(combined, newSpec);
        this.processExtend(combined, newSpec);
        this.processNew(combined, newSpec);
        newSpec.removeEmptyProductions();
        return newSpec;
    }

    private void processDrop(CUPSpec combined, CUPSpec newSpec) throws PPGError {
        for (int i = 0; i < this.commands.size(); ++i) {
            Command cmd = (Command)this.commands.elementAt(i);
            if (!(cmd instanceof DropCmd)) continue;
            DropCmd drop = (DropCmd)cmd;
            if (drop.isProdDrop()) {
                newSpec.dropProductions(drop.getProduction());
                continue;
            }
            Vector symbols = drop.getSymbols();
            for (int j = 0; j < symbols.size(); ++j) {
                String sym = (String)symbols.elementAt(j);
                newSpec.dropSymbol(sym);
                newSpec.dropAllProductions(sym);
            }
        }
    }

    private void processOverride(CUPSpec combined, CUPSpec newSpec) {
        for (int i = 0; i < this.commands.size(); ++i) {
            Command cmd = (Command)this.commands.elementAt(i);
            if (!(cmd instanceof OverrideCmd)) continue;
            OverrideCmd override = (OverrideCmd)cmd;
            newSpec.dropProductions(override.getLHS());
            newSpec.addProductions(override.getProduction());
        }
    }

    private void processExtend(CUPSpec combined, CUPSpec newSpec) {
        for (int i = 0; i < this.commands.size(); ++i) {
            Command cmd = (Command)this.commands.elementAt(i);
            if (!(cmd instanceof ExtendCmd)) continue;
            ExtendCmd extend = (ExtendCmd)cmd;
            newSpec.addProductions(extend.getProduction());
        }
    }

    private void processTransferL(CUPSpec combined, CUPSpec newSpec) {
        for (int i = 0; i < this.commands.size(); ++i) {
            Command cmd = (Command)this.commands.elementAt(i);
            if (!(cmd instanceof TransferCmd)) continue;
            TransferCmd transfer = (TransferCmd)cmd;
            Nonterminal source = transfer.getSource();
            Vector prodList = transfer.getTransferList();
            Production prod = (Production)prodList.elementAt(0);
            prod = (Production)prod.clone();
            for (int j = 1; j < prodList.size(); ++j) {
                Production prodNew = (Production)prodList.elementAt(j);
                prod.union((Production)prodNew.clone());
            }
            prod.setLHS(transfer.getSource());
            newSpec.dropProductions(prod);
        }
    }

    private void processTransferR(CUPSpec combined, CUPSpec newSpec) {
        for (int i = 0; i < this.commands.size(); ++i) {
            Command cmd = (Command)this.commands.elementAt(i);
            if (!(cmd instanceof TransferCmd)) continue;
            TransferCmd transfer = (TransferCmd)cmd;
            Vector prodList = transfer.getTransferList();
            for (int j = 0; j < prodList.size(); ++j) {
                Production prod = (Production)prodList.elementAt(j);
                Nonterminal target = prod.getLHS();
                prod.setLHS(transfer.getSource());
                Production prodTransfer = combined.findProduction(prod);
                prodTransfer.setLHS(target);
                newSpec.addProductions(prodTransfer);
            }
        }
    }

    private void processNew(CUPSpec combined, CUPSpec newSpec) {
        for (int i = 0; i < this.commands.size(); ++i) {
            Command cmd = (Command)this.commands.elementAt(i);
            if (!(cmd instanceof NewProdCmd)) continue;
            NewProdCmd newProd = (NewProdCmd)cmd;
            newSpec.addProductions(newProd.getProduction());
        }
    }

    public void unparse(CodeWriter cw) {
        cw.begin(0);
        if (this.include != null) {
            cw.write(this.include + "\n");
        }
        if (this.commands != null) {
            for (int i = 0; i < this.commands.size(); ++i) {
                ((Command)this.commands.elementAt(i)).unparse(cw);
            }
        }
        cw.end();
    }
}

