/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DuplicateDataException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.PutMode;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINBoundary;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.DupCountLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.util.logging.Level;

public class CursorImpl
implements Cloneable {
    private static final boolean DEBUG = false;
    private static final byte CURSOR_NOT_INITIALIZED = 1;
    private static final byte CURSOR_INITIALIZED = 2;
    private static final byte CURSOR_CLOSED = 3;
    private static final String TRACE_DELETE = "Delete";
    private static final String TRACE_MOD = "Mod:";
    private volatile BIN bin = null;
    private volatile int index = -1;
    private volatile DBIN dupBin = null;
    private volatile int dupIndex = -1;
    private volatile BIN binToBeRemoved;
    private volatile DBIN dupBinToBeRemoved;
    private BIN targetBin;
    private int targetIndex;
    private byte[] dupKey;
    private final DatabaseImpl databaseImpl;
    private Locker locker;
    private final boolean retainNonTxnLocks;
    private byte status;
    private CacheMode cacheMode;
    private boolean allowEviction;
    private TestHook testHook;
    private final int thisId = (int)CursorImpl.getNextCursorId();
    private static long lastAllocatedId = 0L;
    private ThreadLocal<TreeWalkerStatsAccumulator> treeStatsAccumulatorTL;
    public static final int FOUND = 1;
    public static final int EXACT_KEY = 2;
    public static final int EXACT_DATA = 4;
    public static final int FOUND_LAST = 8;

    public CursorImpl(DatabaseImpl database, Locker locker) {
        this(database, locker, true);
    }

    public CursorImpl(DatabaseImpl databaseImpl, Locker locker, boolean retainNonTxnLocks) {
        this.retainNonTxnLocks = retainNonTxnLocks;
        this.databaseImpl = databaseImpl;
        this.locker = locker;
        this.locker.registerCursor(this);
        this.cacheMode = CacheMode.DEFAULT;
        this.status = 1;
    }

    private static long getNextCursorId() {
        return ++lastAllocatedId;
    }

    public int hashCode() {
        return this.thisId;
    }

    private void maybeInitTreeStatsAccumulator() {
        if (this.treeStatsAccumulatorTL == null) {
            this.treeStatsAccumulatorTL = new ThreadLocal();
        }
    }

    private TreeWalkerStatsAccumulator getTreeStatsAccumulator() {
        if (EnvironmentImpl.getThreadLocalReferenceCount() > 0) {
            this.maybeInitTreeStatsAccumulator();
            return this.treeStatsAccumulatorTL.get();
        }
        return null;
    }

    public void incrementLNCount() {
        TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
        if (treeStatsAccumulator != null) {
            treeStatsAccumulator.incrementLNCount();
        }
    }

    public void setAllowEviction(boolean allowed) {
        this.allowEviction = allowed;
    }

    public void criticalEviction() {
        if (this.allowEviction && this.cacheMode != CacheMode.MAKE_COLD && this.cacheMode != CacheMode.EVICT_BIN) {
            this.databaseImpl.getDbEnvironment().criticalEviction(false);
        }
    }

    public CursorImpl cloneCursor(boolean addCursor, CacheMode cacheMode) throws DatabaseException {
        return this.cloneCursor(addCursor, cacheMode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CursorImpl cloneCursor(boolean addCursor, CacheMode cacheMode, CursorImpl usePosition) throws DatabaseException {
        CursorImpl ret = null;
        try {
            this.latchBINs();
            ret = (CursorImpl)super.clone();
            ret.setCacheMode(cacheMode);
            if (!this.retainNonTxnLocks) {
                ret.locker = this.locker.newNonTxnLocker();
            }
            ret.locker.registerCursor(ret);
            if (usePosition != null && usePosition.status == 2) {
                ret.bin = usePosition.bin;
                ret.index = usePosition.index;
                ret.dupBin = usePosition.dupBin;
                ret.dupIndex = usePosition.dupIndex;
            }
            if (addCursor) {
                ret.addCursor();
            }
        }
        catch (CloneNotSupportedException cannotOccur) {
            CursorImpl cursorImpl = null;
            return cursorImpl;
        }
        finally {
            this.releaseBINs();
        }
        this.criticalEviction();
        return ret;
    }

    public void setClosingLocker(CursorImpl closingCursor) {
        if (!this.retainNonTxnLocks && this.locker != closingCursor.locker) {
            this.locker.setClosingLocker(closingCursor.locker);
        }
    }

    public void clearClosingLocker() {
        this.locker.setClosingLocker(null);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int idx) {
        this.index = idx;
    }

    public BIN getBIN() {
        return this.bin;
    }

    public void setBIN(BIN newBin) {
        assert (this.bin == newBin || this.bin == this.binToBeRemoved || !this.bin.containsCursor(this));
        this.bin = newBin;
    }

    public BIN getBINToBeRemoved() {
        return this.binToBeRemoved;
    }

    public int getDupIndex() {
        return this.dupIndex;
    }

    public void setDupIndex(int dupIdx) {
        this.dupIndex = dupIdx;
    }

    public DBIN getDupBIN() {
        return this.dupBin;
    }

    public void setDupBIN(DBIN newDupBin) {
        assert (this.dupBin == newDupBin || this.dupBin == this.dupBinToBeRemoved || !this.dupBin.containsCursor(this));
        this.dupBin = newDupBin;
    }

    public DBIN getDupBINToBeRemoved() {
        return this.dupBinToBeRemoved;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public void setCacheMode(CacheMode mode) {
        this.cacheMode = this.databaseImpl.getEffectiveCacheMode(mode);
    }

    public void setTreeStatsAccumulator(TreeWalkerStatsAccumulator tSA) {
        this.maybeInitTreeStatsAccumulator();
        this.treeStatsAccumulatorTL.set(tSA);
    }

    private boolean setTargetBin() {
        this.targetBin = null;
        this.targetIndex = 0;
        boolean isDup = this.dupBin != null;
        this.dupKey = null;
        if (isDup) {
            this.targetBin = this.dupBin;
            this.targetIndex = this.dupIndex;
            this.dupKey = this.dupBin.getDupKey();
        } else {
            this.targetBin = this.bin;
            this.targetIndex = this.index;
        }
        return isDup;
    }

    public boolean advanceCursor(DatabaseEntry key, DatabaseEntry data) {
        BIN oldBin = this.bin;
        DBIN oldDupBin = this.dupBin;
        int oldIndex = this.index;
        int oldDupIndex = this.dupIndex;
        key.setData(null);
        data.setData(null);
        try {
            this.getNext(key, data, LockType.NONE, true, false);
        }
        catch (DatabaseException ignored) {
            // empty catch block
        }
        if (this.bin != oldBin || this.dupBin != oldDupBin || this.index != oldIndex || this.dupIndex != oldDupIndex) {
            if (key.getData() == null && this.bin != null && this.index > 0) {
                CursorImpl.setDbt(key, this.bin.getKey(this.index));
            }
            if (data.getData() == null && this.dupBin != null && this.dupIndex > 0) {
                CursorImpl.setDbt(data, this.dupBin.getKey(this.dupIndex));
            }
            return true;
        }
        return false;
    }

    public BIN latchBIN() throws DatabaseException {
        while (this.bin != null) {
            BIN waitingOn = this.bin;
            waitingOn.latch(this.cacheMode);
            if (this.bin == waitingOn) {
                return this.bin;
            }
            waitingOn.releaseLatch();
        }
        return null;
    }

    public void releaseBIN() {
        if (this.bin != null) {
            this.bin.releaseLatchIfOwner();
        }
    }

    public void latchBINs() throws DatabaseException {
        this.latchBIN();
        this.latchDBIN();
    }

    public void releaseBINs() {
        this.releaseBIN();
        this.releaseDBIN();
    }

    public DBIN latchDBIN() throws DatabaseException {
        while (this.dupBin != null) {
            DBIN waitingOn = this.dupBin;
            waitingOn.latch(this.cacheMode);
            if (this.dupBin == waitingOn) {
                return this.dupBin;
            }
            waitingOn.releaseLatch();
        }
        return null;
    }

    public void releaseDBIN() {
        if (this.dupBin != null) {
            this.dupBin.releaseLatchIfOwner();
        }
    }

    public Locker getLocker() {
        return this.locker;
    }

    public void addCursor(BIN bin) {
        if (bin != null) {
            assert (bin.isLatchOwnerForWrite());
            bin.addCursor(this);
        }
    }

    public void addCursor() {
        if (this.dupBin != null) {
            this.addCursor(this.dupBin);
        }
        if (this.bin != null) {
            this.addCursor(this.bin);
        }
    }

    public void updateBin(BIN bin, int index) throws DatabaseException {
        this.removeCursorDBIN();
        this.setDupIndex(-1);
        this.setDupBIN(null);
        this.setIndex(index);
        this.setBIN(bin);
        this.addCursor(bin);
    }

    public void updateDBin(DBIN dupBin, int dupIndex) {
        this.setDupIndex(dupIndex);
        this.setDupBIN(dupBin);
        this.addCursor(dupBin);
    }

    private void removeCursor() throws DatabaseException {
        this.removeCursorBIN();
        this.removeCursorDBIN();
    }

    private void removeCursorBIN() throws DatabaseException {
        BIN abin = this.latchBIN();
        if (abin != null) {
            abin.removeCursor(this);
            abin.releaseLatch();
        }
    }

    private void removeCursorDBIN() throws DatabaseException {
        DBIN abin = this.latchDBIN();
        if (abin != null) {
            abin.removeCursor(this);
            abin.releaseLatch();
        }
    }

    public void clearDupBIN(boolean alreadyLatched) throws DatabaseException {
        if (this.dupBin != null) {
            if (alreadyLatched) {
                this.dupBin.removeCursor(this);
                this.dupBin.releaseLatch();
            } else {
                this.removeCursorDBIN();
            }
            this.dupBin = null;
            this.dupIndex = -1;
        }
    }

    public void dumpTree() {
        this.databaseImpl.getTree().dump();
    }

    public boolean isClosed() {
        return this.status == 3;
    }

    public boolean isNotInitialized() {
        return this.status == 1;
    }

    public boolean isInternalDbCursor() {
        return this.databaseImpl.isInternalDb();
    }

    public void reset() throws DatabaseException {
        this.removeCursor();
        this.performCacheEviction(null);
        if (!this.retainNonTxnLocks) {
            this.locker.releaseNonTxnLocks();
        }
        this.bin = null;
        this.index = -1;
        this.dupBin = null;
        this.dupIndex = -1;
        this.status = 1;
        this.criticalEviction();
    }

    public void close() throws DatabaseException {
        this.close(null);
    }

    public void close(CursorImpl newCursor) throws DatabaseException {
        assert (this.assertCursorState(false)) : this.dumpToString(true);
        this.removeCursor();
        this.performCacheEviction(newCursor);
        this.locker.unRegisterCursor(this);
        if (!this.retainNonTxnLocks) {
            this.locker.nonTxnOperationEnd();
        }
        this.status = (byte)3;
        this.criticalEviction();
    }

    private void performCacheEviction(CursorImpl newCursor) {
        int nextIndex;
        BIN nextBin;
        EnvironmentImpl envImpl = this.databaseImpl.getDbEnvironment();
        if (this.cacheMode != CacheMode.EVICT_LN && this.cacheMode != CacheMode.EVICT_BIN && (this.cacheMode != CacheMode.MAKE_COLD || !envImpl.isCacheFull() && !envImpl.wasCacheEverFull())) {
            return;
        }
        this.setTargetBin();
        if (this.targetBin == null) {
            return;
        }
        if (newCursor != null) {
            newCursor.setTargetBin();
            nextBin = newCursor.targetBin;
            nextIndex = newCursor.targetIndex;
        } else {
            nextBin = null;
            nextIndex = -1;
        }
        switch (this.cacheMode) {
            case EVICT_LN: {
                if (this.targetBin == nextBin && this.targetIndex == nextIndex) break;
                this.evict();
                break;
            }
            case EVICT_BIN: {
                if (this.targetBin == nextBin) {
                    if (this.targetIndex == nextIndex) break;
                    this.evict();
                    break;
                }
                envImpl.getEvictor().evictIN(this.targetBin, false, Evictor.EvictionSource.CACHEMODE);
                break;
            }
            case MAKE_COLD: {
                if (this.targetBin == nextBin || !envImpl.isCacheFull()) {
                    if (this.targetIndex == nextIndex) break;
                    this.evict();
                    break;
                }
                envImpl.getEvictor().evictIN(this.targetBin, false, Evictor.EvictionSource.CACHEMODE);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(LockType lockType) throws DatabaseException {
        assert (this.assertCursorState(true)) : this.dumpToString(true);
        if (!this.databaseImpl.getSortedDuplicates()) {
            return 1;
        }
        if (this.bin == null) {
            return 0;
        }
        this.latchBIN();
        try {
            if (this.bin.getNEntries() <= this.index) {
                int n = 0;
                return n;
            }
            Node n = this.bin.fetchTarget(this.index);
            if (n != null && n.containsDuplicates()) {
                DIN dupRoot = (DIN)n;
                dupRoot.latch(this.cacheMode);
                this.releaseBIN();
                DupCountLN dupCountLN = (DupCountLN)dupRoot.getDupCountLNRef().fetchTarget(this.databaseImpl, dupRoot);
                dupRoot.releaseLatch();
                this.locker.lock(dupCountLN.getNodeId(), lockType, false, this.databaseImpl);
                int n2 = dupCountLN.getDupCount();
                return n2;
            }
            int n3 = 1;
            return n3;
        }
        finally {
            this.releaseBIN();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus delete(ReplicationContext repContext) throws DatabaseException {
        assert (this.assertCursorState(true)) : this.dumpToString(true);
        boolean isDup = this.setTargetBin();
        if (this.targetBin == null) {
            return OperationStatus.KEYEMPTY;
        }
        if (this.targetBin.isEntryKnownDeleted(this.targetIndex)) {
            this.releaseBINs();
            return OperationStatus.KEYEMPTY;
        }
        LN ln = (LN)this.targetBin.fetchTarget(this.targetIndex);
        if (ln == null) {
            this.releaseBINs();
            return OperationStatus.KEYEMPTY;
        }
        LockResult lockResult = this.lockLN(ln, LockType.WRITE);
        if ((ln = lockResult.getLN()) == null) {
            this.releaseBINs();
            return OperationStatus.KEYEMPTY;
        }
        LockResult dclLockResult = null;
        IN dupRoot = null;
        boolean dupRootIsLatched = false;
        try {
            boolean bl = isDup = this.dupBin != null;
            if (isDup) {
                dupRoot = this.getLatchedDupRoot(true);
                dclLockResult = this.lockDupCountLN((DIN)dupRoot, LockType.WRITE);
                dupRootIsLatched = true;
                dupRoot = (DIN)this.bin.getTarget(this.index);
                this.releaseBIN();
            }
            this.setTargetBin();
            long oldLsn = this.targetBin.getLsn(this.targetIndex);
            byte[] lnKey = this.targetBin.getKey(this.targetIndex);
            lockResult.setAbortLsn(oldLsn, this.targetBin.isEntryKnownDeleted(this.targetIndex));
            long oldLNSize = ln.getMemorySizeIncludedByParent();
            long newLsn = ln.delete(this.databaseImpl, lnKey, this.dupKey, oldLsn, this.locker, repContext);
            this.targetBin.updateNode(this.targetIndex, ln, oldLNSize, newLsn, null);
            this.targetBin.setPendingDeleted(this.targetIndex);
            this.releaseBINs();
            if (isDup) {
                ((DIN)dupRoot).incrementDuplicateCount(dclLockResult, this.dupKey, this.locker, false);
                dupRoot.releaseLatch();
                dupRootIsLatched = false;
                dupRoot = null;
                this.locker.addDeleteInfo(this.dupBin, new Key(lnKey));
            } else {
                this.locker.addDeleteInfo(this.bin, new Key(lnKey));
            }
            this.trace(Level.FINER, TRACE_DELETE, this.targetBin, ln, this.targetIndex, oldLsn, newLsn);
        }
        finally {
            if (dupRoot != null && dupRootIsLatched) {
                dupRoot.releaseLatch();
            }
        }
        return OperationStatus.SUCCESS;
    }

    public CursorImpl dup(boolean samePosition) throws DatabaseException {
        assert (this.assertCursorState(false)) : this.dumpToString(true);
        CursorImpl ret = this.cloneCursor(samePosition, this.cacheMode);
        if (!samePosition) {
            ret.bin = null;
            ret.index = -1;
            ret.dupBin = null;
            ret.dupIndex = -1;
            ret.status = 1;
        }
        return ret;
    }

    public void evict() throws DatabaseException {
        this.evict(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict(boolean alreadyLatched) throws DatabaseException {
        try {
            if (!alreadyLatched) {
                this.latchBINs();
            }
            this.setTargetBin();
            if (this.targetIndex >= 0) {
                this.targetBin.evictLN(this.targetIndex);
            }
        }
        finally {
            if (!alreadyLatched) {
                this.releaseBINs();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockNextKeyForInsert(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        DatabaseEntry tempKey = new DatabaseEntry(key.getData(), key.getOffset(), key.getSize());
        DatabaseEntry tempData = new DatabaseEntry(data.getData(), data.getOffset(), data.getSize());
        tempKey.setPartial(0, 0, true);
        tempData.setPartial(0, 0, true);
        boolean lockedNextKey = false;
        SearchMode searchMode = this.databaseImpl.getSortedDuplicates() ? SearchMode.BOTH_RANGE : SearchMode.SET_RANGE;
        boolean latched = true;
        try {
            int searchResult = this.searchAndPosition(tempKey, tempData, searchMode, LockType.RANGE_INSERT);
            if ((searchResult & 1) != 0 && (searchResult & 8) == 0) {
                OperationStatus status = (searchResult & 2) != 0 ? this.getNext(tempKey, tempData, LockType.RANGE_INSERT, true, true) : this.getNextNoDup(tempKey, tempData, LockType.RANGE_INSERT, true, true);
                if (status == OperationStatus.SUCCESS) {
                    lockedNextKey = true;
                }
                latched = false;
            }
        }
        finally {
            if (latched) {
                this.releaseBINs();
            }
        }
        if (!lockedNextKey) {
            this.lockEofNode(LockType.RANGE_INSERT);
        }
    }

    public OperationStatus put(DatabaseEntry key, DatabaseEntry data, LN ln, PutMode putMode, DatabaseEntry returnOldData, DatabaseEntry returnNewData, ReplicationContext repContext) {
        long checkNodeId;
        boolean overwriteKnownNodeId;
        boolean allowOverwrite;
        boolean allowDups;
        assert (key != null);
        assert (data != null);
        assert (ln != null);
        assert (putMode != null);
        assert (this.assertCursorState(false)) : this.dumpToString(true);
        assert (LatchSupport.countLatchesHeld() == 0);
        switch (putMode) {
            case NO_OVERWRITE: {
                allowDups = false;
                allowOverwrite = false;
                overwriteKnownNodeId = false;
                break;
            }
            case NO_DUP_DATA: {
                assert (this.databaseImpl.getSortedDuplicates());
                allowDups = true;
                allowOverwrite = false;
                overwriteKnownNodeId = false;
                break;
            }
            case OVERWRITE: {
                allowDups = this.databaseImpl.getSortedDuplicates();
                allowOverwrite = true;
                overwriteKnownNodeId = false;
                break;
            }
            case OVERWRITE_KNOWN: {
                allowDups = this.databaseImpl.getSortedDuplicates();
                allowOverwrite = true;
                overwriteKnownNodeId = true;
                break;
            }
            default: {
                throw EnvironmentFailureException.unexpectedState(putMode.toString());
            }
        }
        LockResult lockResult = this.locker.lock(ln.getNodeId(), LockType.WRITE, false, this.databaseImpl);
        if (this.databaseImpl.getTree().insert(ln, Key.makeKey(key), allowDups, this, lockResult, repContext)) {
            this.status = (byte)2;
            if (returnNewData != null) {
                returnNewData.setData(ln.copyData());
            }
            return OperationStatus.SUCCESS;
        }
        if (overwriteKnownNodeId) {
            checkNodeId = ln.getNodeId();
        } else {
            checkNodeId = -1L;
            this.locker.releaseLock(ln.getNodeId());
        }
        if (allowOverwrite) {
            this.status = (byte)2;
            return this.putCurrent(data, null, returnOldData, returnNewData, checkNodeId, repContext);
        }
        return OperationStatus.KEYEXIST;
    }

    public OperationStatus putLN(byte[] key, LN ln, DatabaseEntry returnNewData, boolean allowDuplicates, ReplicationContext repContext) throws DatabaseException {
        assert (this.assertCursorState(false)) : this.dumpToString(true);
        assert (LatchSupport.countLatchesHeld() == 0);
        LockResult lockResult = this.locker.lock(ln.getNodeId(), LockType.WRITE, false, this.databaseImpl);
        if (this.databaseImpl.getTree().insert(ln, key, allowDuplicates, this, lockResult, repContext)) {
            this.status = (byte)2;
            if (returnNewData != null) {
                returnNewData.setData(ln.copyData());
            }
            return OperationStatus.SUCCESS;
        }
        this.locker.releaseLock(ln.getNodeId());
        return OperationStatus.KEYEXIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus putCurrent(DatabaseEntry data, DatabaseEntry foundKey, DatabaseEntry foundData, DatabaseEntry returnNewData, long checkNodeId, ReplicationContext repContext) throws DatabaseException {
        long newLsn;
        long oldLsn;
        LN ln;
        assert (this.assertCursorState(true)) : this.dumpToString(true);
        if (foundKey != null) {
            foundKey.setData(null);
        }
        if (foundData != null) {
            foundData.setData(null);
        }
        if (returnNewData != null) {
            returnNewData.setData(null);
        }
        if (this.bin == null) {
            return OperationStatus.KEYEMPTY;
        }
        this.latchBINs();
        boolean isDup = this.setTargetBin();
        try {
            byte[] newData;
            byte[] foundKeyBytes;
            byte[] foundDataBytes;
            ln = (LN)this.targetBin.fetchTarget(this.targetIndex);
            byte[] lnKey = this.targetBin.getKey(this.targetIndex);
            if (this.targetBin.isEntryKnownDeleted(this.targetIndex) || ln == null) {
                OperationStatus operationStatus = OperationStatus.NOTFOUND;
                return operationStatus;
            }
            LockResult lockResult = this.lockLN(ln, LockType.WRITE);
            if ((ln = lockResult.getLN()) == null) {
                OperationStatus operationStatus = OperationStatus.NOTFOUND;
                return operationStatus;
            }
            if (checkNodeId != -1L && checkNodeId != ln.getNodeId()) {
                EnvironmentFailureException.unexpectedState("Overwrite node ID expected = " + checkNodeId + " but in Btree = " + ln.getNodeId());
            }
            if (isDup = this.setTargetBin()) {
                foundDataBytes = lnKey;
                foundKeyBytes = this.targetBin.getDupKey();
            } else {
                foundDataBytes = ln.getData();
                foundKeyBytes = lnKey;
            }
            if (data.getPartial()) {
                int slicelen;
                int dlen = data.getPartialLength();
                int doff = data.getPartialOffset();
                int origlen = foundDataBytes != null ? foundDataBytes.length : 0;
                int oldlen = doff + dlen > origlen ? doff + dlen : origlen;
                int len = oldlen - dlen + data.getSize();
                newData = len == 0 ? LogUtils.ZERO_LENGTH_BYTE_ARRAY : new byte[len];
                int pos = 0;
                int n = slicelen = doff < origlen ? doff : origlen;
                if (slicelen > 0) {
                    System.arraycopy(foundDataBytes, 0, newData, pos, slicelen);
                }
                slicelen = data.getSize();
                System.arraycopy(data.getData(), data.getOffset(), newData, pos += doff, slicelen);
                pos += slicelen;
                slicelen = origlen - (doff + dlen);
                if (slicelen > 0) {
                    System.arraycopy(foundDataBytes, doff + dlen, newData, pos, slicelen);
                }
            } else {
                int len = data.getSize();
                newData = len == 0 ? LogUtils.ZERO_LENGTH_BYTE_ARRAY : new byte[len];
                System.arraycopy(data.getData(), data.getOffset(), newData, 0, len);
            }
            if (this.databaseImpl.getSortedDuplicates()) {
                boolean keysEqual = false;
                if (foundDataBytes != null) {
                    boolean bl = keysEqual = Key.compareKeys(foundDataBytes, newData, this.databaseImpl.getDuplicateComparator()) == 0;
                }
                if (!keysEqual) {
                    this.revertLock(ln, lockResult);
                    throw new DuplicateDataException("Can't replace a duplicate with data that is unequal according to the duplicate comparator.");
                }
            }
            if (foundData != null) {
                CursorImpl.setDbt(foundData, foundDataBytes);
            }
            if (foundKey != null) {
                CursorImpl.setDbt(foundKey, foundKeyBytes);
            }
            oldLsn = this.targetBin.getLsn(this.targetIndex);
            lockResult.setAbortLsn(oldLsn, this.targetBin.isEntryKnownDeleted(this.targetIndex));
            long oldLNSize = ln.getMemorySizeIncludedByParent();
            byte[] newKey = isDup ? this.targetBin.getDupKey() : lnKey;
            newLsn = ln.modify(newData, this.databaseImpl, newKey, oldLsn, this.locker, repContext);
            if (returnNewData != null) {
                returnNewData.setData(ln.copyData());
            }
            this.targetBin.updateNode(this.targetIndex, ln, oldLNSize, newLsn, (byte[])(isDup ? newData : null));
        }
        finally {
            this.releaseBINs();
        }
        this.trace(Level.FINER, TRACE_MOD, this.targetBin, ln, this.targetIndex, oldLsn, newLsn);
        this.status = (byte)2;
        return OperationStatus.SUCCESS;
    }

    public OperationStatus getCurrent(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType) throws DatabaseException {
        assert (this.assertCursorState(true)) : this.dumpToString(true);
        if (this.bin == null) {
            return OperationStatus.KEYEMPTY;
        }
        if (this.dupBin == null) {
            this.latchBIN();
        } else {
            this.latchDBIN();
        }
        return this.getCurrentAlreadyLatched(foundKey, foundData, lockType, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getCurrentAlreadyLatched(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType, boolean first) throws DatabaseException {
        assert (this.assertCursorState(true)) : this.dumpToString(true);
        assert (this.checkAlreadyLatched(true)) : this.dumpToString(true);
        try {
            OperationStatus operationStatus = this.fetchCurrent(foundKey, foundData, lockType, first);
            return operationStatus;
        }
        finally {
            this.releaseBINs();
        }
    }

    public LN getCurrentLN(LockType lockType) throws DatabaseException {
        assert (this.assertCursorState(true)) : this.dumpToString(true);
        if (this.bin == null) {
            return null;
        }
        this.latchBIN();
        return this.getCurrentLNAlreadyLatched(lockType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LN getCurrentLNAlreadyLatched(LockType lockType) throws DatabaseException {
        try {
            assert (this.assertCursorState(true)) : this.dumpToString(true);
            assert (this.checkAlreadyLatched(true)) : this.dumpToString(true);
            if (this.bin == null) {
                LN lN = null;
                return lN;
            }
            LN ln = null;
            if (!this.bin.isEntryKnownDeleted(this.index)) {
                ln = (LN)this.bin.fetchTarget(this.index);
            }
            if (ln == null) {
                this.releaseBIN();
                LN lN = null;
                return lN;
            }
            this.addCursor(this.bin);
            LockResult lockResult = this.lockLN(ln, lockType);
            LN lN = ln = lockResult.getLN();
            return lN;
        }
        finally {
            this.releaseBINs();
        }
    }

    public OperationStatus getNext(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType, boolean forward, boolean alreadyLatched) throws DatabaseException {
        return this.getNextWithKeyChangeStatus((DatabaseEntry)foundKey, (DatabaseEntry)foundData, (LockType)lockType, (boolean)forward, (boolean)alreadyLatched).status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyChangeStatus getNextWithKeyChangeStatus(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType, boolean forward, boolean alreadyLatched) throws DatabaseException {
        assert (this.assertCursorState(true)) : this.dumpToString(true);
        assert (this.checkAlreadyLatched(alreadyLatched)) : this.dumpToString(true);
        KeyChangeStatus result = new KeyChangeStatus(OperationStatus.NOTFOUND, true);
        try {
            while (this.bin != null) {
                if (this.dupBin != null) {
                    if (this.getNextDuplicate(foundKey, foundData, lockType, forward, alreadyLatched) == OperationStatus.SUCCESS) {
                        result.status = OperationStatus.SUCCESS;
                        result.keyChange = false;
                        break;
                    }
                    this.removeCursorDBIN();
                    alreadyLatched = false;
                    this.dupBin = null;
                    this.dupIndex = -1;
                    continue;
                }
                assert (this.checkAlreadyLatched(alreadyLatched)) : this.dumpToString(true);
                if (!alreadyLatched) {
                    this.latchBIN();
                } else {
                    alreadyLatched = false;
                }
                if (forward && ++this.index < this.bin.getNEntries() || !forward && --this.index > -1) {
                    OperationStatus ret = this.getCurrentAlreadyLatched(foundKey, foundData, lockType, forward);
                    if (ret == OperationStatus.SUCCESS) {
                        this.incrementLNCount();
                        result.status = OperationStatus.SUCCESS;
                        break;
                    }
                    assert (LatchSupport.countLatchesHeld() == 0);
                    if (this.binToBeRemoved == null) continue;
                    this.flushBINToBeRemoved();
                    continue;
                }
                if (this.binToBeRemoved != null) {
                    this.releaseBIN();
                    this.flushBINToBeRemoved();
                    this.latchBIN();
                }
                this.binToBeRemoved = this.bin;
                this.bin = null;
                assert (TestHookExecute.doHookIfSet(this.testHook));
                BIN newBin = forward ? this.databaseImpl.getTree().getNextBin(this.binToBeRemoved, false, this.cacheMode) : this.databaseImpl.getTree().getPrevBin(this.binToBeRemoved, false, this.cacheMode);
                if (newBin == null) {
                    result.status = OperationStatus.NOTFOUND;
                    break;
                }
                this.index = forward ? -1 : newBin.getNEntries();
                this.addCursor(newBin);
                this.bin = newBin;
                alreadyLatched = true;
            }
        }
        finally {
            assert (LatchSupport.countLatchesHeld() == 0) : LatchSupport.latchesHeldToString();
            if (this.binToBeRemoved != null) {
                this.flushBINToBeRemoved();
            }
        }
        return result;
    }

    private void flushBINToBeRemoved() throws DatabaseException {
        this.binToBeRemoved.latch(this.cacheMode);
        this.binToBeRemoved.removeCursor(this);
        this.binToBeRemoved.releaseLatch();
        this.binToBeRemoved = null;
    }

    public OperationStatus getNextNoDup(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType, boolean forward, boolean alreadyLatched) throws DatabaseException {
        assert (this.assertCursorState(true)) : this.dumpToString(true);
        if (this.dupBin != null) {
            this.clearDupBIN(alreadyLatched);
            alreadyLatched = false;
        }
        return this.getNext(foundKey, foundData, lockType, forward, alreadyLatched);
    }

    public OperationStatus getFirstDuplicate(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType) throws DatabaseException {
        assert (this.assertCursorState(true)) : this.dumpToString(true);
        if (this.dupBin != null) {
            this.removeCursorDBIN();
            this.dupBin = null;
            this.dupIndex = -1;
        }
        return this.getCurrent(foundKey, foundData, lockType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getNextDuplicate(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType, boolean forward, boolean alreadyLatched) throws DatabaseException {
        assert (this.assertCursorState(true)) : this.dumpToString(true);
        assert (this.checkAlreadyLatched(alreadyLatched)) : this.dumpToString(true);
        try {
            while (this.dupBin != null) {
                OperationStatus operationStatus;
                if (!alreadyLatched) {
                    this.latchDBIN();
                } else {
                    alreadyLatched = false;
                }
                if (forward && ++this.dupIndex < this.dupBin.getNEntries() || !forward && --this.dupIndex > -1) {
                    OperationStatus ret = OperationStatus.SUCCESS;
                    if (foundKey != null) {
                        ret = this.getCurrentAlreadyLatched(foundKey, foundData, lockType, forward);
                    } else {
                        this.releaseDBIN();
                    }
                    if (ret == OperationStatus.SUCCESS) {
                        this.incrementLNCount();
                        operationStatus = ret;
                        return operationStatus;
                    }
                    assert (LatchSupport.countLatchesHeld() == 0);
                    if (this.dupBinToBeRemoved == null) continue;
                    this.flushDBINToBeRemoved();
                    continue;
                }
                if (this.dupBinToBeRemoved != null) {
                    this.flushDBINToBeRemoved();
                }
                this.dupBinToBeRemoved = this.dupBin;
                this.dupBin = null;
                this.dupBinToBeRemoved.releaseLatch();
                TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
                if (treeStatsAccumulator != null) {
                    this.latchBIN();
                    try {
                        if (this.index < 0) {
                            operationStatus = OperationStatus.NOTFOUND;
                            return operationStatus;
                        }
                        DIN duplicateRoot = (DIN)this.bin.fetchTarget(this.index);
                        duplicateRoot.latch(this.cacheMode);
                        try {
                            DupCountLN dcl = duplicateRoot.getDupCountLN();
                            if (dcl != null) {
                                dcl.accumulateStats(treeStatsAccumulator);
                            }
                        }
                        finally {
                            duplicateRoot.releaseLatch();
                        }
                    }
                    finally {
                        this.releaseBIN();
                    }
                }
                assert (LatchSupport.countLatchesHeld() == 0);
                this.dupBinToBeRemoved.latch(this.cacheMode);
                DBIN newDupBin = forward ? (DBIN)this.databaseImpl.getTree().getNextBin(this.dupBinToBeRemoved, true, this.cacheMode) : (DBIN)this.databaseImpl.getTree().getPrevBin(this.dupBinToBeRemoved, true, this.cacheMode);
                if (newDupBin == null) {
                    OperationStatus operationStatus2 = OperationStatus.NOTFOUND;
                    return operationStatus2;
                }
                this.dupIndex = forward ? -1 : newDupBin.getNEntries();
                this.addCursor(newDupBin);
                this.dupBin = newDupBin;
                alreadyLatched = true;
            }
        }
        finally {
            assert (LatchSupport.countLatchesHeld() == 0);
            if (this.dupBinToBeRemoved != null) {
                this.flushDBINToBeRemoved();
            }
        }
        return OperationStatus.NOTFOUND;
    }

    private void flushDBINToBeRemoved() throws DatabaseException {
        this.dupBinToBeRemoved.latch(this.cacheMode);
        this.dupBinToBeRemoved.removeCursor(this);
        this.dupBinToBeRemoved.releaseLatch();
        this.dupBinToBeRemoved = null;
    }

    public boolean positionFirstOrLast(boolean first, DIN duplicateRoot) throws DatabaseException {
        assert (this.assertCursorState(false)) : this.dumpToString(true);
        IN in = null;
        boolean found = false;
        try {
            if (duplicateRoot == null) {
                this.removeCursorBIN();
                in = first ? this.databaseImpl.getTree().getFirstNode(this.cacheMode) : this.databaseImpl.getTree().getLastNode(this.cacheMode);
                if (in != null) {
                    assert (in instanceof BIN);
                    this.dupBin = null;
                    this.dupIndex = -1;
                    this.bin = (BIN)in;
                    this.index = first ? 0 : this.bin.getNEntries() - 1;
                    this.addCursor(this.bin);
                    TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
                    if (this.bin.getNEntries() == 0) {
                        found = true;
                    } else {
                        Node n = null;
                        if (!this.bin.isEntryKnownDeleted(this.index) && duplicateRoot == null && this.databaseImpl.getSortedDuplicates()) {
                            n = this.bin.fetchTarget(this.index);
                        }
                        if (n != null && n.containsDuplicates()) {
                            DIN dupRoot = (DIN)n;
                            dupRoot.latch(this.cacheMode);
                            in.releaseLatch();
                            in = null;
                            found = this.positionFirstOrLast(first, dupRoot);
                        } else {
                            if (treeStatsAccumulator != null) {
                                if (this.bin.isEntryKnownDeleted(this.index) || this.bin.isEntryPendingDeleted(this.index) || n != null && ((LN)n).isDeleted()) {
                                    treeStatsAccumulator.incrementDeletedLNCount();
                                } else {
                                    treeStatsAccumulator.incrementLNCount();
                                }
                            }
                            found = true;
                        }
                    }
                }
            } else {
                this.removeCursorDBIN();
                in = first ? this.databaseImpl.getTree().getFirstNode(duplicateRoot, this.cacheMode) : this.databaseImpl.getTree().getLastNode(duplicateRoot, this.cacheMode);
                if (in != null) {
                    this.dupBin = (DBIN)in;
                    this.dupIndex = first ? 0 : this.dupBin.getNEntries() - 1;
                    this.addCursor(this.dupBin);
                    found = true;
                }
            }
            this.status = (byte)2;
            return found;
        }
        catch (DatabaseException e) {
            if (in != null) {
                in.releaseLatch();
            }
            throw e;
        }
    }

    public int searchAndPosition(DatabaseEntry matchKey, DatabaseEntry matchData, SearchMode searchMode, LockType lockType) throws DatabaseException {
        assert (this.assertCursorState(false)) : this.dumpToString(true);
        this.removeCursor();
        this.bin = null;
        this.dupBin = null;
        this.dupIndex = -1;
        boolean foundSomething = false;
        boolean foundExactKey = false;
        boolean foundExactData = false;
        boolean foundLast = false;
        boolean exactSearch = searchMode.isExactSearch();
        BINBoundary binBoundary = new BINBoundary();
        try {
            byte[] key = Key.makeKey(matchKey);
            this.bin = (BIN)this.databaseImpl.getTree().search(key, Tree.SearchType.NORMAL, -1L, binBoundary, this.cacheMode);
            if (this.bin != null) {
                this.addCursor(this.bin);
                this.index = this.bin.findEntry(key, true, exactSearch);
                foundSomething = !exactSearch;
                boolean containsDuplicates = false;
                if (this.index >= 0) {
                    if ((this.index & 0x10000) != 0) {
                        foundExactKey = true;
                        this.index &= 0xFFFEFFFF;
                    }
                    if (!this.bin.isEntryKnownDeleted(this.index)) {
                        if (!searchMode.isDataSearch() && lockType == LockType.NONE && !this.databaseImpl.getSortedDuplicates()) {
                            if (!this.bin.isEntryKnownDeleted(this.index)) {
                                foundSomething = true;
                            }
                        } else {
                            Node n = this.bin.fetchTarget(this.index);
                            if (n != null) {
                                containsDuplicates = n.containsDuplicates();
                                if (searchMode.isDataSearch()) {
                                    if (foundExactKey) {
                                        int searchResult = this.searchAndPositionBoth(containsDuplicates, n, matchData, exactSearch, lockType);
                                        foundSomething = (searchResult & 1) != 0;
                                        foundExactData = (searchResult & 4) != 0;
                                    }
                                } else {
                                    foundSomething = true;
                                    if (!containsDuplicates && exactSearch) {
                                        LN ln = (LN)n;
                                        LockResult lockResult = this.lockLN(ln, lockType);
                                        if ((ln = lockResult.getLN()) == null) {
                                            foundSomething = false;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    foundLast = searchMode == SearchMode.SET_RANGE && foundSomething && !containsDuplicates && binBoundary.isLastBin && this.index == this.bin.getNEntries() - 1;
                }
            }
            this.status = (byte)2;
            return (foundSomething ? 1 : 0) | (foundExactKey ? 2 : 0) | (foundExactData ? 4 : 0) | (foundLast ? 8 : 0);
        }
        catch (DatabaseException e) {
            this.releaseBIN();
            throw e;
        }
    }

    private int searchAndPositionBoth(boolean containsDuplicates, Node n, DatabaseEntry matchData, boolean exactSearch, LockType lockType) throws DatabaseException {
        assert (this.assertCursorState(false)) : this.dumpToString(true);
        boolean found = false;
        boolean exact = false;
        assert (matchData != null);
        byte[] data = Key.makeKey(matchData);
        if (containsDuplicates) {
            DIN duplicateRoot = (DIN)n;
            duplicateRoot.latch(this.cacheMode);
            this.releaseBIN();
            this.dupBin = (DBIN)this.databaseImpl.getTree().searchSubTree(duplicateRoot, data, Tree.SearchType.NORMAL, -1L, null, this.cacheMode);
            if (this.dupBin != null) {
                this.addCursor(this.dupBin);
                this.dupIndex = this.dupBin.findEntry(data, true, exactSearch);
                if (this.dupIndex >= 0) {
                    if ((this.dupIndex & 0x10000) != 0) {
                        exact = true;
                    }
                    this.dupIndex &= 0xFFFEFFFF;
                    found = true;
                } else {
                    this.dupIndex = -1;
                    found = !exactSearch;
                }
            }
        } else {
            LN ln = (LN)n;
            LockResult lockResult = this.lockLN(ln, lockType);
            if ((ln = lockResult.getLN()) == null) {
                found = !exactSearch;
            } else {
                int cmp = Key.compareKeys(ln.getData(), data, this.databaseImpl.getDuplicateComparator());
                if (cmp == 0 || cmp <= 0 && !exactSearch) {
                    if (cmp == 0) {
                        exact = true;
                    }
                    found = true;
                } else {
                    if (this.dupBin == null) {
                        --this.index;
                    } else {
                        --this.dupIndex;
                    }
                    found = !exactSearch;
                }
            }
        }
        return (found ? 1 : 0) | (exact ? 4 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus fetchCurrent(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType, boolean first) throws DatabaseException {
        Node n;
        TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
        boolean duplicateFetch = this.setTargetBin();
        if (this.targetBin == null) {
            return OperationStatus.NOTFOUND;
        }
        assert (this.targetBin.isLatchOwnerForWrite());
        if (this.targetIndex < 0 || this.targetIndex >= this.targetBin.getNEntries() || this.targetBin.isEntryKnownDeleted(this.targetIndex)) {
            if (treeStatsAccumulator != null) {
                treeStatsAccumulator.incrementDeletedLNCount();
            }
            this.targetBin.releaseLatch();
            return OperationStatus.KEYEMPTY;
        }
        if (this.targetBin.isEntryPendingDeleted(this.targetIndex)) {
            EnvironmentImpl envImpl = this.databaseImpl.getDbEnvironment();
            envImpl.addToCompressorQueue(this.targetBin, new Key(this.targetBin.getKey(this.targetIndex)), false);
        }
        if (lockType == LockType.NONE && (foundData == null || foundData.getPartial() && foundData.getPartialLength() == 0) && (duplicateFetch || !this.databaseImpl.getSortedDuplicates())) {
            if (this.targetBin.isEntryPendingDeleted(this.targetIndex)) {
                if (treeStatsAccumulator != null) {
                    treeStatsAccumulator.incrementDeletedLNCount();
                }
                return OperationStatus.KEYEMPTY;
            }
            if (foundKey != null) {
                CursorImpl.setDbt(foundKey, duplicateFetch ? this.dupKey : this.targetBin.getKey(this.targetIndex));
            }
            return OperationStatus.SUCCESS;
        }
        try {
            n = this.targetBin.fetchTarget(this.targetIndex);
        }
        catch (DatabaseException DE) {
            this.targetBin.releaseLatch();
            throw DE;
        }
        if (n == null) {
            if (treeStatsAccumulator != null) {
                treeStatsAccumulator.incrementDeletedLNCount();
            }
            this.targetBin.releaseLatch();
            return OperationStatus.KEYEMPTY;
        }
        this.addCursor(this.targetBin);
        if (n.containsDuplicates()) {
            assert (!duplicateFetch);
            DIN duplicateRoot = (DIN)n;
            duplicateRoot.latch(this.cacheMode);
            this.targetBin.releaseLatch();
            if (this.positionFirstOrLast(first, duplicateRoot)) {
                try {
                    return this.fetchCurrent(foundKey, foundData, lockType, first);
                }
                catch (DatabaseException DE) {
                    this.releaseBINs();
                    throw DE;
                }
            }
            return OperationStatus.NOTFOUND;
        }
        LN ln = (LN)n;
        assert (TestHookExecute.doHookIfSet(this.testHook));
        LockResult lockResult = this.lockLN(ln, lockType);
        try {
            byte[] lnData;
            ln = lockResult.getLN();
            byte[] byArray = lnData = ln != null ? ln.getData() : null;
            if (ln == null || lnData == null) {
                if (treeStatsAccumulator != null) {
                    treeStatsAccumulator.incrementDeletedLNCount();
                }
                OperationStatus operationStatus = OperationStatus.KEYEMPTY;
                return operationStatus;
            }
            if (foundKey != null) {
                duplicateFetch = this.setTargetBin();
                CursorImpl.setDbt(foundKey, duplicateFetch ? this.dupKey : this.targetBin.getKey(this.targetIndex));
            }
            if (foundData != null) {
                CursorImpl.setDbt(foundData, lnData);
            }
            OperationStatus operationStatus = OperationStatus.SUCCESS;
            return operationStatus;
        }
        finally {
            this.releaseBINs();
        }
    }

    private LockResult lockLN(LN ln, LockType lockType) throws DatabaseException {
        LockResult lockResult = this.lockLNDeletedAllowed(ln, lockType);
        if ((ln = lockResult.getLN()) != null) {
            this.setTargetBin();
            if (this.targetBin.isEntryKnownDeleted(this.targetIndex) || ln.isDeleted()) {
                this.revertLock(ln.getNodeId(), lockResult.getLockGrant());
                lockResult.setLN(null);
            }
        }
        return lockResult;
    }

    public LockResult lockLNDeletedAllowed(LN ln, LockType lockType) throws DatabaseException {
        LockResult lockResult;
        if (this.locker.getDefaultNoWait()) {
            try {
                lockResult = this.locker.lock(ln.getNodeId(), lockType, true, this.databaseImpl);
            }
            catch (LockConflictException e) {
                this.releaseBINs();
                throw e;
            }
        } else {
            lockResult = this.locker.nonBlockingLock(ln.getNodeId(), lockType, this.databaseImpl);
        }
        if (lockResult.getLockGrant() != LockGrantType.DENIED) {
            lockResult.setLN(ln);
            return lockResult;
        }
        while (true) {
            long nodeId = ln.getNodeId();
            this.releaseBINs();
            lockResult = this.locker.lock(nodeId, lockType, false, this.databaseImpl);
            this.latchBINs();
            this.setTargetBin();
            ln = (LN)this.targetBin.fetchTarget(this.targetIndex);
            if (ln == null || nodeId == ln.getNodeId()) break;
            this.revertLock(nodeId, lockResult.getLockGrant());
        }
        lockResult.setLN(ln);
        return lockResult;
    }

    public LockResult lockDupCountLN(DIN dupRoot, LockType lockType) throws DatabaseException {
        LockResult lockResult;
        DupCountLN ln = dupRoot.getDupCountLN();
        if (this.locker.getDefaultNoWait()) {
            try {
                lockResult = this.locker.lock(ln.getNodeId(), lockType, true, this.databaseImpl);
            }
            catch (LockConflictException e) {
                dupRoot.releaseLatch();
                this.releaseBINs();
                throw e;
            }
        } else {
            lockResult = this.locker.nonBlockingLock(ln.getNodeId(), lockType, this.databaseImpl);
        }
        if (lockResult.getLockGrant() == LockGrantType.DENIED) {
            dupRoot.releaseLatch();
            this.releaseBINs();
            lockResult = this.locker.lock(ln.getNodeId(), lockType, false, this.databaseImpl);
            this.latchBIN();
            dupRoot = (DIN)this.bin.fetchTarget(this.index);
            dupRoot.latch(this.cacheMode);
            this.latchDBIN();
            ln = dupRoot.getDupCountLN();
        }
        lockResult.setLN(ln);
        return lockResult;
    }

    public DIN getLatchedDupRoot(boolean isDBINLatched) throws DatabaseException {
        assert (this.bin != null);
        assert (this.bin.isLatchOwnerForWrite());
        assert (this.index >= 0);
        DIN dupRoot = (DIN)this.bin.fetchTarget(this.index);
        if (isDBINLatched) {
            if (!dupRoot.latchNoWait(this.cacheMode)) {
                this.releaseDBIN();
                dupRoot.latch(this.cacheMode);
                this.latchDBIN();
            }
        } else {
            dupRoot.latch(this.cacheMode);
        }
        return dupRoot;
    }

    public static void setDbt(DatabaseEntry data, byte[] bytes) {
        if (bytes != null) {
            int len;
            boolean partial = data.getPartial();
            int off = partial ? data.getPartialOffset() : 0;
            int n = len = partial ? data.getPartialLength() : bytes.length;
            if (off + len > bytes.length) {
                len = off > bytes.length ? 0 : bytes.length - off;
            }
            byte[] newdata = null;
            if (len == 0) {
                newdata = LogUtils.ZERO_LENGTH_BYTE_ARRAY;
            } else {
                newdata = new byte[len];
                System.arraycopy(bytes, off, newdata, 0, len);
            }
            data.setData(newdata);
            data.setOffset(0);
            data.setSize(len);
        } else {
            data.setData(null);
            data.setOffset(0);
            data.setSize(0);
        }
    }

    private void verifyCursor(BIN bin) throws DatabaseException {
        if (!bin.getCursorSet().contains(this)) {
            throw new EnvironmentFailureException(this.databaseImpl.getDbEnvironment(), EnvironmentFailureReason.UNEXPECTED_STATE, "BIN cursorSet is inconsistent");
        }
    }

    private boolean assertCursorState(boolean mustBeInitialized) {
        try {
            this.checkCursorState(mustBeInitialized);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public void checkCursorState(boolean mustBeInitialized) {
        switch (this.status) {
            case 1: {
                if (!mustBeInitialized) break;
                throw new IllegalStateException("Cursor not initialized.");
            }
            case 2: {
                break;
            }
            case 3: {
                throw new IllegalStateException("Cursor has been closed.");
            }
            default: {
                throw EnvironmentFailureException.unexpectedState("Unknown cursor status: " + this.status);
            }
        }
    }

    private void revertLock(LN ln, LockResult lockResult) throws DatabaseException {
        this.revertLock(ln.getNodeId(), lockResult.getLockGrant());
    }

    private void revertLock(long nodeId, LockGrantType lockStatus) throws DatabaseException {
        if (lockStatus == LockGrantType.NEW || lockStatus == LockGrantType.WAIT_NEW) {
            this.locker.releaseLock(nodeId);
        } else if (lockStatus == LockGrantType.PROMOTION || lockStatus == LockGrantType.WAIT_PROMOTION) {
            this.locker.demoteLock(nodeId);
        }
    }

    public void lockEofNode(LockType lockType) throws DatabaseException {
        this.locker.lock(this.databaseImpl.getEofNodeId(), lockType, false, this.databaseImpl);
    }

    public void checkEnv() {
        this.databaseImpl.getDbEnvironment().checkIfInvalid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traverseDbWithCursor(DatabaseImpl db, LockType lockType, boolean allowEviction, WithCursor withCursor) throws DatabaseException {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        Locker locker = null;
        CursorImpl cursor = null;
        try {
            EnvironmentImpl envImpl = db.getDbEnvironment();
            locker = LockerFactory.getInternalReadOperationLocker(envImpl);
            cursor = new CursorImpl(db, locker);
            cursor.setAllowEviction(allowEviction);
            if (cursor.positionFirstOrLast(true, null)) {
                OperationStatus status = cursor.getCurrentAlreadyLatched(key, data, lockType, true);
                boolean done = false;
                while (!done) {
                    if (status == OperationStatus.SUCCESS && !withCursor.withCursor(cursor, key, data)) {
                        done = true;
                    }
                    if (done || (status = cursor.getNext(key, data, lockType, true, false)) == OperationStatus.SUCCESS) continue;
                    done = true;
                }
            }
        }
        finally {
            if (cursor != null) {
                cursor.releaseBINs();
                cursor.close();
            }
            if (locker != null) {
                locker.operationEnd();
            }
        }
    }

    public void dump(boolean verbose) {
        System.out.println(this.dumpToString(verbose));
    }

    public void dump() {
        System.out.println(this.dumpToString(true));
    }

    private String statusToString(byte status) {
        switch (status) {
            case 1: {
                return "CURSOR_NOT_INITIALIZED";
            }
            case 2: {
                return "CURSOR_INITIALIZED";
            }
            case 3: {
                return "CURSOR_CLOSED";
            }
        }
        return "UNKNOWN (" + Byte.toString(status) + ")";
    }

    public String dumpToString(boolean verbose) {
        StringBuffer sb = new StringBuffer();
        sb.append("<Cursor idx=\"").append(this.index).append("\"");
        if (this.dupBin != null) {
            sb.append(" dupIdx=\"").append(this.dupIndex).append("\"");
        }
        sb.append(" status=\"").append(this.statusToString(this.status)).append("\"");
        sb.append(">\n");
        if (verbose) {
            sb.append(this.bin == null ? "" : this.bin.dumpString(2, true));
            sb.append(this.dupBin == null ? "" : this.dupBin.dumpString(2, true));
        }
        sb.append("\n</Cursor>");
        return sb.toString();
    }

    public StatGroup getLockStats() throws DatabaseException {
        return this.locker.collectStats();
    }

    private void trace(Level level, String changeType, BIN theBin, LN ln, int lnIndex, long oldLsn, long newLsn) {
        EnvironmentImpl envImpl = this.databaseImpl.getDbEnvironment();
        if (envImpl.getLogger().isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(changeType);
            sb.append(" bin=");
            sb.append(theBin.getNodeId());
            sb.append(" ln=");
            sb.append(ln.getNodeId());
            sb.append(" lnIdx=");
            sb.append(lnIndex);
            sb.append(" oldLnLsn=");
            sb.append(DbLsn.getNoFormatString(oldLsn));
            sb.append(" newLnLsn=");
            sb.append(DbLsn.getNoFormatString(newLsn));
            LoggerUtils.logMsg(envImpl.getLogger(), envImpl, level, sb.toString());
        }
    }

    public void setTestHook(TestHook hook) {
        this.testHook = hook;
    }

    private boolean checkAlreadyLatched(boolean alreadyLatched) {
        if (alreadyLatched) {
            if (this.dupBin != null) {
                return this.dupBin.isLatchOwnerForWrite();
            }
            if (this.bin != null) {
                return this.bin.isLatchOwnerForWrite();
            }
        }
        return true;
    }

    public static interface WithCursor {
        public boolean withCursor(CursorImpl var1, DatabaseEntry var2, DatabaseEntry var3) throws DatabaseException;
    }

    public static class KeyChangeStatus {
        public OperationStatus status;
        public boolean keyChange;

        public KeyChangeStatus(OperationStatus status, boolean keyChange) {
            this.status = status;
            this.keyChange = keyChange;
        }
    }

    public static class SearchMode {
        public static final SearchMode SET = new SearchMode(true, false, "SET");
        public static final SearchMode BOTH = new SearchMode(true, true, "BOTH");
        public static final SearchMode SET_RANGE = new SearchMode(false, false, "SET_RANGE");
        public static final SearchMode BOTH_RANGE = new SearchMode(false, true, "BOTH_RANGE");
        private final boolean exactSearch;
        private final boolean dataSearch;
        private final String name;

        private SearchMode(boolean exactSearch, boolean dataSearch, String name) {
            this.exactSearch = exactSearch;
            this.dataSearch = dataSearch;
            this.name = "SearchMode." + name;
        }

        public final boolean isExactSearch() {
            return this.exactSearch;
        }

        public final boolean isDataSearch() {
            return this.dataSearch;
        }

        public String toString() {
            return this.name;
        }
    }
}

