/*
 * Decompiled with CFR 0.152.
 */
package rice.tutorial.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.identity.BindStrategy;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.sourceroute.SourceRoute;
import org.mpisws.p2p.transport.sourceroute.factory.MultiAddressSourceRouteFactory;
import org.mpisws.p2p.transport.ssl.SSLTransportLayerImpl;
import rice.environment.Environment;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.leafset.LeafSet;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.socket.TransportLayerNodeHandle;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.tutorial.ssl.MyApp;

public class DistTutorial {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistTutorial(int bindport, InetSocketAddress bootaddress, Environment env, File keyStoreFile) throws Exception {
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        Security.addProvider((Provider)new BouncyCastleProvider());
        final KeyStore store = KeyStore.getInstance("UBER", "BC");
        store.load(new FileInputStream(keyStoreFile), "".toCharArray());
        Id id = Id.build(keyStoreFile.getName().split("\\.")[0]);
        SocketPastryNodeFactory factory = new SocketPastryNodeFactory(nidFactory, bindport, env){

            @Override
            protected TransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer> getSourceRouteTransportLayer(TransportLayer<MultiInetSocketAddress, ByteBuffer> etl, PastryNode pn, MultiAddressSourceRouteFactory esrFactory) {
                TransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer> sourceRoutingTransportLayer = super.getSourceRouteTransportLayer(etl, pn, esrFactory);
                try {
                    return new SSLTransportLayerImpl<SourceRoute<MultiInetSocketAddress>, ByteBuffer>(sourceRoutingTransportLayer, store, store, pn.getEnvironment());
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }

            @Override
            protected BindStrategy<TransportLayerNodeHandle<MultiInetSocketAddress>, SourceRoute<MultiInetSocketAddress>> getBindStrategy() {
                return new BindStrategy<TransportLayerNodeHandle<MultiInetSocketAddress>, SourceRoute<MultiInetSocketAddress>>(){

                    @Override
                    public boolean accept(TransportLayerNodeHandle<MultiInetSocketAddress> u, SourceRoute<MultiInetSocketAddress> l, Map<String, Object> options) {
                        String idName = (String)options.get("ssl_certificate_subject");
                        if (idName != null) {
                            if (u.getId().toStringFull().equals(idName)) {
                                return true;
                            }
                            System.out.println("Rejecting id:" + u + " which does not match the certificate entry:" + idName);
                            return false;
                        }
                        return true;
                    }
                };
            }
        };
        PastryNode node = ((PastryNodeFactory)factory).newNode(id);
        MyApp app = new MyApp(node);
        node.boot(bootaddress);
        PastryNode pastryNode = node;
        synchronized (pastryNode) {
            while (!node.isReady() && !node.joinFailed()) {
                node.wait(500L);
                if (!node.joinFailed()) continue;
                throw new IOException("Could not join the FreePastry ring.  Reason:" + node.joinFailedReason());
            }
        }
        System.out.println("Finished creating new node " + node);
        env.getTimeSource().sleep(10000L);
        for (int i = 0; i < 10; ++i) {
            Id randId = nidFactory.generateNodeId();
            app.routeMyMsg(randId);
            env.getTimeSource().sleep(1000L);
        }
        env.getTimeSource().sleep(10000L);
        LeafSet leafSet = node.getLeafSet();
        for (int i = -leafSet.ccwSize(); i <= leafSet.cwSize(); ++i) {
            if (i == 0) continue;
            NodeHandle nh = leafSet.get(i);
            app.routeMyMsgDirect(nh);
            env.getTimeSource().sleep(1000L);
        }
    }

    public static void main(String[] args) throws Exception {
        Environment env = new Environment();
        env.getParameters().setString("nat_search_policy", "never");
        try {
            int bindport = Integer.parseInt(args[0]);
            InetAddress bootaddr = InetAddress.getByName(args[1]);
            int bootport = Integer.parseInt(args[2]);
            InetSocketAddress bootaddress = new InetSocketAddress(bootaddr, bootport);
            String keystoreFileName = args[3];
            File keystoreFile = new File(keystoreFileName);
            if (!keystoreFile.exists()) {
                throw new IllegalArgumentException("The file: " + keystoreFileName + " was not found.");
            }
            DistTutorial dt = new DistTutorial(bindport, bootaddress, env, keystoreFile);
        }
        catch (Exception e) {
            System.out.println("Usage:");
            System.out.println("java [-cp FreePastry-<version>.jar] rice.tutorial.lesson3.DistTutorial localbindport bootIP bootPort");
            System.out.println("example java rice.tutorial.DistTutorial 9001 pokey.cs.almamater.edu 9001");
            throw e;
        }
    }
}

