/*
 * Decompiled with CFR 0.152.
 */
package rice.tutorial.scribe;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import rice.environment.Environment;
import rice.p2p.commonapi.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.tutorial.scribe.MyScribeClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScribeTutorial {
    Vector<MyScribeClient> apps = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScribeTutorial(int bindport, InetSocketAddress bootaddress, int numNodes, Environment env) throws Exception {
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        SocketPastryNodeFactory factory = new SocketPastryNodeFactory(nidFactory, bindport, env);
        for (int curNode = 0; curNode < numNodes; ++curNode) {
            PastryNode node = ((PastryNodeFactory)factory).newNode();
            MyScribeClient app = new MyScribeClient(node);
            this.apps.add(app);
            node.boot(bootaddress);
            PastryNode pastryNode = node;
            synchronized (pastryNode) {
                while (!node.isReady() && !node.joinFailed()) {
                    node.wait(500L);
                    if (!node.joinFailed()) continue;
                    throw new IOException("Could not join the FreePastry ring.  Reason:" + node.joinFailedReason());
                }
            }
            System.out.println("Finished creating new node: " + node);
        }
        Iterator<MyScribeClient> i = this.apps.iterator();
        MyScribeClient app = i.next();
        app.subscribe();
        app.startPublishTask();
        while (i.hasNext()) {
            app = i.next();
            app.subscribe();
        }
        env.getTimeSource().sleep(5000L);
        ScribeTutorial.printTree(this.apps);
    }

    public static void printTree(Vector<MyScribeClient> apps) {
        Hashtable<NodeHandle, MyScribeClient> appTable = new Hashtable<NodeHandle, MyScribeClient>();
        for (MyScribeClient app : apps) {
            appTable.put(app.endpoint.getLocalNodeHandle(), app);
        }
        NodeHandle seed = apps.get((int)0).endpoint.getLocalNodeHandle();
        NodeHandle root = ScribeTutorial.getRoot(seed, appTable);
        ScribeTutorial.recursivelyPrintChildren(root, 0, appTable);
    }

    public static NodeHandle getRoot(NodeHandle seed, Hashtable<NodeHandle, MyScribeClient> appTable) {
        MyScribeClient app = appTable.get(seed);
        if (app.isRoot()) {
            return seed;
        }
        NodeHandle nextSeed = app.getParent();
        return ScribeTutorial.getRoot(nextSeed, appTable);
    }

    public static void recursivelyPrintChildren(NodeHandle curNode, int recursionDepth, Hashtable<NodeHandle, MyScribeClient> appTable) {
        String s = "";
        for (int numTabs = 0; numTabs < recursionDepth; ++numTabs) {
            s = s + "  ";
        }
        s = s + curNode.getId().toString();
        System.out.println(s);
        MyScribeClient app = appTable.get(curNode);
        NodeHandle[] children = app.getChildren();
        for (int curChild = 0; curChild < children.length; ++curChild) {
            ScribeTutorial.recursivelyPrintChildren(children[curChild], recursionDepth + 1, appTable);
        }
    }

    public static void main(String[] args) throws Exception {
        Environment env = new Environment();
        env.getParameters().setString("nat_search_policy", "never");
        try {
            int bindport = Integer.parseInt(args[0]);
            InetAddress bootaddr = InetAddress.getByName(args[1]);
            int bootport = Integer.parseInt(args[2]);
            InetSocketAddress bootaddress = new InetSocketAddress(bootaddr, bootport);
            int numNodes = Integer.parseInt(args[3]);
            ScribeTutorial dt = new ScribeTutorial(bindport, bootaddress, numNodes, env);
        }
        catch (Exception e) {
            System.out.println("Usage:");
            System.out.println("java [-cp FreePastry-<version>.jar] rice.tutorial.scribe.ScribeTutorial localbindport bootIP bootPort numNodes");
            System.out.println("example java rice.tutorial.scribe.ScribeTutorial 9001 pokey.cs.almamater.edu 9001 10");
            throw e;
        }
    }
}

