/*
 * Decompiled with CFR 0.152.
 */
package rice.tutorial.past;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Vector;
import rice.Continuation;
import rice.environment.Environment;
import rice.p2p.commonapi.Id;
import rice.p2p.past.Past;
import rice.p2p.past.PastContent;
import rice.p2p.past.PastImpl;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.commonapi.PastryIdFactory;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.persistence.LRUCache;
import rice.persistence.MemoryStorage;
import rice.persistence.StorageManagerImpl;
import rice.tutorial.past.MyPastContent;

public class PastTutorial {
    Vector<Past> apps = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PastTutorial(int bindport, InetSocketAddress bootaddress, int numNodes, final Environment env) throws Exception {
        int ctr;
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        SocketPastryNodeFactory factory = new SocketPastryNodeFactory(nidFactory, bindport, env);
        for (int curNode = 0; curNode < numNodes; ++curNode) {
            PastryNode node = ((PastryNodeFactory)factory).newNode();
            PastryIdFactory idf = new PastryIdFactory(env);
            String storageDirectory = "./storage" + node.getId().hashCode();
            MemoryStorage stor = new MemoryStorage(idf);
            PastImpl app = new PastImpl(node, new StorageManagerImpl(idf, stor, new LRUCache(new MemoryStorage(idf), 524288, node.getEnvironment())), 0, "");
            this.apps.add(app);
            node.boot(bootaddress);
            PastryNode pastryNode = node;
            synchronized (pastryNode) {
                while (!node.isReady() && !node.joinFailed()) {
                    node.wait(500L);
                    if (!node.joinFailed()) continue;
                    throw new IOException("Could not join the FreePastry ring.  Reason:" + node.joinFailedReason());
                }
            }
            System.out.println("Finished creating new node " + node);
        }
        env.getTimeSource().sleep(5000L);
        PastryIdFactory localFactory = new PastryIdFactory(env);
        System.out.println("Storing 5 keys");
        Id[] storedKey = new Id[5];
        for (ctr = 0; ctr < storedKey.length; ++ctr) {
            String s = "test" + env.getRandomSource().nextInt();
            final MyPastContent myContent = new MyPastContent(localFactory.buildId(s), s);
            storedKey[ctr] = myContent.getId();
            Past p = this.apps.get(env.getRandomSource().nextInt(numNodes));
            System.out.println("Inserting " + myContent + " at node " + p.getLocalNodeHandle());
            p.insert(myContent, new Continuation<Boolean[], Exception>(){

                @Override
                public void receiveResult(Boolean[] results) {
                    int numSuccessfulStores = 0;
                    for (int ctr = 0; ctr < results.length; ++ctr) {
                        if (!results[ctr].booleanValue()) continue;
                        ++numSuccessfulStores;
                    }
                    System.out.println(myContent + " successfully stored at " + numSuccessfulStores + " locations.");
                }

                @Override
                public void receiveException(Exception result) {
                    System.out.println("Error storing " + myContent);
                    result.printStackTrace();
                }
            });
        }
        env.getTimeSource().sleep(5000L);
        System.out.println("Looking up the 5 keys");
        for (ctr = 0; ctr < storedKey.length; ++ctr) {
            final Id lookupKey = storedKey[ctr];
            Past p = this.apps.get(env.getRandomSource().nextInt(numNodes));
            System.out.println("Looking up " + lookupKey + " at node " + p.getLocalNodeHandle());
            p.lookup(lookupKey, new Continuation<PastContent, Exception>(){

                @Override
                public void receiveResult(PastContent result) {
                    System.out.println("Successfully looked up " + result + " for key " + lookupKey + ".");
                }

                @Override
                public void receiveException(Exception result) {
                    System.out.println("Error looking up " + lookupKey);
                    result.printStackTrace();
                }
            });
        }
        env.getTimeSource().sleep(5000L);
        System.out.println("Looking up a bogus key");
        final Id bogusKey = localFactory.buildId("bogus");
        Past p = this.apps.get(env.getRandomSource().nextInt(numNodes));
        System.out.println("Looking up bogus key " + bogusKey + " at node " + p.getLocalNodeHandle());
        p.lookup(bogusKey, new Continuation<PastContent, Exception>(){

            @Override
            public void receiveResult(PastContent result) {
                System.out.println("Successfully looked up " + result + " for key " + bogusKey + ".  Notice that the result is null.");
                env.destroy();
            }

            @Override
            public void receiveException(Exception result) {
                System.out.println("Error looking up " + bogusKey);
                result.printStackTrace();
                env.destroy();
            }
        });
    }

    public static void main(String[] args) throws Exception {
        Environment env = new Environment();
        env.getParameters().setString("nat_search_policy", "never");
        try {
            int bindport = Integer.parseInt(args[0]);
            InetAddress bootaddr = InetAddress.getByName(args[1]);
            int bootport = Integer.parseInt(args[2]);
            InetSocketAddress bootaddress = new InetSocketAddress(bootaddr, bootport);
            int numNodes = Integer.parseInt(args[3]);
            PastTutorial dt = new PastTutorial(bindport, bootaddress, numNodes, env);
        }
        catch (Exception e) {
            System.out.println("Usage:");
            System.out.println("java [-cp FreePastry-<version>.jar] rice.tutorial.past.PastTutorial localbindport bootIP bootPort numNodes");
            System.out.println("example java rice.tutorial.past.PastTutorial 9001 pokey.cs.almamater.edu 9001 10");
            throw e;
        }
    }
}

