/*
 * Decompiled with CFR 0.152.
 */
package rice.tutorial.lesson1;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import rice.environment.Environment;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.standard.RandomNodeIdFactory;

public class DistTutorial {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistTutorial(int bindport, InetSocketAddress bootaddress, Environment env) throws Exception {
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        SocketPastryNodeFactory factory = new SocketPastryNodeFactory(nidFactory, bindport, env);
        PastryNode node = ((PastryNodeFactory)factory).newNode();
        node.boot(bootaddress);
        PastryNode pastryNode = node;
        synchronized (pastryNode) {
            while (!node.isReady() && !node.joinFailed()) {
                node.wait(500L);
                if (!node.joinFailed()) continue;
                throw new IOException("Could not join the FreePastry ring.  Reason:" + node.joinFailedReason());
            }
        }
        System.out.println("Finished creating new node " + node);
    }

    public static void main(String[] args) throws Exception {
        Environment env = new Environment();
        env.getParameters().setString("nat_search_policy", "never");
        try {
            int bindport = Integer.parseInt(args[0]);
            InetAddress bootaddr = InetAddress.getByName(args[1]);
            int bootport = Integer.parseInt(args[2]);
            InetSocketAddress bootaddress = new InetSocketAddress(bootaddr, bootport);
            DistTutorial dt = new DistTutorial(bindport, bootaddress, env);
        }
        catch (Exception e) {
            System.out.println("Usage:");
            System.out.println("java [-cp FreePastry-<version>.jar] rice.tutorial.lesson1.DistTutorial localbindport bootIP bootPort");
            System.out.println("example java rice.tutorial.DistTutorial 9001 pokey.cs.almamater.edu 9001");
            throw e;
        }
    }
}

