/*
 * Decompiled with CFR 0.152.
 */
package rice.selector;

import rice.environment.time.TimeSource;
import rice.p2p.commonapi.CancellableTask;
import rice.selector.SelectorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimerTask
implements Comparable<TimerTask>,
CancellableTask {
    private long nextExecutionTime;
    protected boolean cancelled = false;
    protected int seq;
    protected SelectorManager selector;
    protected int period = -1;
    protected boolean fixedRate = false;

    @Override
    public abstract void run();

    public boolean execute(TimeSource ts) {
        if (this.cancelled) {
            return false;
        }
        this.run();
        if (this.cancelled) {
            return false;
        }
        if (this.period > 0) {
            if (this.fixedRate) {
                this.nextExecutionTime += (long)this.period;
                return true;
            }
            this.nextExecutionTime = ts.currentTimeMillis() + (long)this.period;
            return true;
        }
        return false;
    }

    @Override
    public boolean cancel() {
        if (this.cancelled) {
            return false;
        }
        if (this.selector != null) {
            this.selector.removeTask(this);
        }
        this.cancelled = true;
        return true;
    }

    @Override
    public long scheduledExecutionTime() {
        return this.nextExecutionTime;
    }

    @Override
    public int compareTo(TimerTask arg0) {
        TimerTask tt = arg0;
        if (tt == this) {
            return 0;
        }
        int diff = (int)(this.nextExecutionTime - tt.nextExecutionTime);
        if (diff == 0 && (diff = this.seq - tt.seq) == 0) {
            return System.identityHashCode(this) < System.identityHashCode(tt) ? 1 : -1;
        }
        return diff;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setSelectorManager(SelectorManager selector) {
        this.selector = selector;
    }

    protected void setNextExecutionTime(long l) {
        this.nextExecutionTime = l;
    }
}

