/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.io.IOException;
import java.net.NoRouteToHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.mpisws.p2p.transport.exception.NodeIsFaultyException;
import rice.p2p.commonapi.exception.AppNotRegisteredException;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageDispatch;
import rice.pastry.routing.BroadcastRouteRow;
import rice.pastry.routing.NoLegalRouteToMakeProgressException;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.Router;
import rice.pastry.routing.RouterAddress;
import rice.pastry.routing.RouterStrategy;
import rice.pastry.transport.PMessageNotification;
import rice.pastry.transport.PMessageReceipt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardRouter
extends PastryAppl
implements Router {
    MessageDispatch dispatch;
    protected RouterStrategy routerStrategy;
    protected int ROUTE_TABLE_PATCH_THROTTLE = 5000;
    protected Map<NodeHandle, Long> lastTimeSentRouteTablePatch = new HashMap<NodeHandle, Long>();

    public StandardRouter(PastryNode thePastryNode, MessageDispatch dispatch) {
        this(thePastryNode, dispatch, new AliveRouterStrategy());
    }

    public StandardRouter(final PastryNode thePastryNode, MessageDispatch dispatch, RouterStrategy strategy) {
        super(thePastryNode, null, RouterAddress.getCode(), new MessageDeserializer(){

            public rice.p2p.commonapi.Message deserialize(InputBuffer buf, short type, int priority, rice.p2p.commonapi.NodeHandle sender) throws IOException {
                RouteMessage rm = RouteMessage.build(buf, (byte)priority, thePastryNode, (NodeHandle)sender, (byte)thePastryNode.getEnvironment().getParameters().getInt("pastry_protocol_router_routeMsgVersion"));
                return rm;
            }
        });
        this.dispatch = dispatch;
        this.routerStrategy = strategy;
        if (this.routerStrategy == null) {
            this.routerStrategy = new AliveRouterStrategy();
        }
    }

    public void setRouterStrategy(RouterStrategy strategy) {
        this.routerStrategy = strategy;
    }

    @Override
    public void receiveMessage(Message msg) {
        if (this.logger.level <= 400) {
            this.logger.log("receiveMessage(" + msg + ")");
        }
        if (!(msg instanceof RouteMessage)) {
            throw new Error("message " + msg + " bounced at StandardRouter");
        }
        this.route((RouteMessage)msg);
    }

    @Override
    public void route(final RouteMessage rm) {
        if (!this.thePastryNode.getEnvironment().getSelectorManager().isSelectorThread()) {
            this.thePastryNode.getEnvironment().getSelectorManager().invoke(new Runnable(){

                public void run() {
                    StandardRouter.this.route(rm);
                }
            });
            return;
        }
        if (this.logger.level <= 500) {
            this.logger.log("route(" + rm + ")");
        }
        if (!this.routeMessage(rm)) {
            this.receiveRouteMessage(rm);
        }
    }

    public boolean routeMessage(RouteMessage rm) {
        if (this.logger.level <= 400) {
            this.logger.log("routeMessage(" + rm + ")");
        }
        if (rm.getNextHop() == null) {
            return false;
        }
        rm.setSender(this.thePastryNode.getLocalHandle());
        NodeHandle handle = rm.getNextHop();
        rm.setNextHop(null);
        rm.setPrevNode(this.thePastryNode.getLocalHandle());
        if (this.thePastryNode.getLocalHandle().equals(handle)) {
            if (rm.getDestinationHandle() != null && !rm.getDestinationHandle().equals(this.thePastryNode.getLocalHandle())) {
                if (this.logger.level <= 500) {
                    this.logger.log("Message " + rm + " has destination " + rm.getDestinationHandle() + " but I'm the root of the id.  Dropping.  This could happen if the destination has died while the route message was in transit, or if the local node does not yet have logging state because it is boostrapping.");
                }
                rm.sendFailed(new NoRouteToHostException(rm.getDestinationHandle().toString()));
                return true;
            }
            this.thePastryNode.receiveMessage(rm.internalMsg);
            rm.sendSuccess(this.thePastryNode.getLocalHandle());
        } else {
            this.sendTheMessage(rm, handle);
        }
        return true;
    }

    protected void sendTheMessage(final RouteMessage rm, final NodeHandle handle) {
        if (this.logger.level <= 400) {
            this.logger.log("sendTheMessage(" + rm + "," + handle + ")");
        }
        rm.setTLCancellable(this.thePastryNode.send(handle, rm, new PMessageNotification(){

            public void sent(PMessageReceipt msg) {
                rm.sendSuccess(handle);
            }

            public void sendFailed(PMessageReceipt msg, Exception reason) {
                if (rm.sendFailed(reason)) {
                    if (((StandardRouter)StandardRouter.this).logger.level <= 700) {
                        StandardRouter.this.logger.logException("sendFailed(" + rm + ")=>" + handle, reason);
                    }
                } else if (((StandardRouter)StandardRouter.this).logger.level <= 500) {
                    StandardRouter.this.logger.logException("sendFailed(" + rm + ")=>" + handle, reason);
                } else if (reason instanceof NodeIsFaultyException) {
                    if (((StandardRouter)StandardRouter.this).logger.level <= 800) {
                        StandardRouter.this.logger.log("sendFailed(" + rm + ")=>" + handle + " " + reason);
                    }
                } else if (((StandardRouter)StandardRouter.this).logger.level <= 900) {
                    StandardRouter.this.logger.logException("sendFailed(" + rm + ")=>" + handle, reason);
                }
            }
        }, rm.getTLOptions()));
    }

    private void receiveRouteMessage(RouteMessage msg) {
        Id target;
        if (this.logger.level <= 400) {
            this.logger.log("receiveRouteMessage(" + msg + ")");
        }
        if ((target = msg.getTarget()) == null) {
            target = this.thePastryNode.getNodeId();
        }
        int cwSize = this.thePastryNode.getLeafSet().cwSize();
        int ccwSize = this.thePastryNode.getLeafSet().ccwSize();
        int lsPos = this.thePastryNode.getLeafSet().mostSimilar(target);
        if (lsPos == 0) {
            msg.setNextHop(this.thePastryNode.getLocalHandle());
        } else {
            msg.getOptions().setRerouteIfSuspected(true);
            Iterator<NodeHandle> i = this.getBestRoutingCandidates(target);
            NodeHandle nextHop = this.routerStrategy.pickNextHop(msg, i);
            if (nextHop == null) {
                msg.sendFailed(new NoLegalRouteToMakeProgressException(target));
                return;
            }
            msg.setNextHop(nextHop);
        }
        this.checkForRouteTableHole(msg, msg.getNextHop());
        msg.setPrevNode(this.thePastryNode.getLocalHandle());
        this.deliverToApplication(msg);
    }

    @Override
    public Iterator<NodeHandle> getBestRoutingCandidates(Id target) {
        int cwSize = this.thePastryNode.getLeafSet().cwSize();
        int ccwSize = this.thePastryNode.getLeafSet().ccwSize();
        int lsPos = this.thePastryNode.getLeafSet().mostSimilar(target);
        if (lsPos == 0) {
            return Collections.singleton(this.thePastryNode.getLocalHandle()).iterator();
        }
        boolean leafSetOnly = false;
        if (lsPos > 0 && (lsPos < cwSize || !this.thePastryNode.getLeafSet().get(lsPos).getNodeId().clockwise(target)) || lsPos < 0 && (-lsPos < ccwSize || this.thePastryNode.getLeafSet().get(lsPos).getNodeId().clockwise(target))) {
            leafSetOnly = true;
        }
        return this.getBestRoutingCandidates(target, lsPos, leafSetOnly);
    }

    protected Iterator<NodeHandle> getBestRoutingCandidates(final Id target, final int lsPos, boolean leafSetOnly) {
        if (leafSetOnly) {
            return this.getLSCollection(lsPos).iterator();
        }
        return new Iterator<NodeHandle>(){
            Iterator<NodeHandle> rtIterator = null;
            Iterator<NodeHandle> iterator = null;
            ArrayList<NodeHandle> lsCollection = null;
            NodeHandle next;
            RouteSet best = StandardRouter.access$800(StandardRouter.this).getRoutingTable().getBestEntry(target);
            int k = 0;
            {
                if (this.best == null || this.best.isEmpty()) {
                    this.rtIterator = StandardRouter.this.thePastryNode.getRoutingTable().alternateRoutesIterator(target);
                    this.lsCollection = StandardRouter.this.getLSCollection(lsPos);
                    this.iterator = this.rtIterator;
                }
                this.next = this.getNext();
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.next = this.getNext();
                }
                return this.next != null;
            }

            public NodeHandle getNext() {
                if (this.iterator == null && this.best != null) {
                    NodeHandle ret = this.best.get(this.k);
                    ++this.k;
                    if (this.k >= this.best.size()) {
                        this.rtIterator = StandardRouter.this.thePastryNode.getRoutingTable().alternateRoutesIterator(target);
                        this.lsCollection = StandardRouter.this.getLSCollection(lsPos);
                        this.iterator = this.rtIterator;
                    }
                    return ret;
                }
                if (this.iterator.hasNext()) {
                    NodeHandle ret = this.iterator.next();
                    if (this.best != null && this.best.getIndex(ret) != -1) {
                        return this.getNext();
                    }
                    if (this.iterator == this.rtIterator && this.lsCollection.contains(ret)) {
                        this.iterator = this.lsCollection.iterator();
                        return this.iterator.next();
                    }
                    return ret;
                }
                if (this.iterator == this.rtIterator) {
                    this.iterator = this.lsCollection.iterator();
                    return this.getNext();
                }
                return null;
            }

            @Override
            public NodeHandle next() {
                if (this.hasNext()) {
                    NodeHandle ret = this.next;
                    this.next = null;
                    return ret;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new RuntimeException("Operation not allowed.");
            }
        };
    }

    protected ArrayList<NodeHandle> getLSCollection(int lsPos) {
        ArrayList<NodeHandle> lsCollection = new ArrayList<NodeHandle>();
        if (lsPos > 0) {
            for (int i = lsPos; i > 0; --i) {
                NodeHandle temp = this.thePastryNode.getLeafSet().get(i);
                lsCollection.add(temp);
            }
        } else {
            for (int i = lsPos; i < 0; ++i) {
                NodeHandle temp = this.thePastryNode.getLeafSet().get(i);
                lsCollection.add(temp);
            }
        }
        return lsCollection;
    }

    public void deliverToApplication(RouteMessage msg) {
        PastryAppl appl = this.dispatch.getDestinationByAddress(msg.getAuxAddress());
        if (appl == null) {
            if (msg.sendFailed(new AppNotRegisteredException(msg.getAuxAddress()))) {
                if (this.logger.level <= 700) {
                    this.logger.log("Dropping message " + msg + " because the application address " + msg.getAuxAddress() + " is unknown.");
                }
            } else if (this.logger.level <= 900) {
                this.logger.log("Dropping message " + msg + " because the application address " + msg.getAuxAddress() + " is unknown.");
            }
            return;
        }
        appl.receiveMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForRouteTableHole(RouteMessage msg, NodeHandle handle) {
        Id key;
        int index;
        NodeHandle prevNode;
        if (this.logger.level <= 300) {
            this.logger.log("checkForRouteTableHole(" + msg + "," + handle + ")");
        }
        if ((prevNode = msg.getPrevNode()) == null) {
            if (this.logger.level <= 400) {
                this.logger.log("No prevNode defined in " + msg);
            }
            return;
        }
        if (prevNode.equals(this.getNodeHandle())) {
            if (this.logger.level <= 400) {
                this.logger.log("prevNode is me in " + msg);
            }
            return;
        }
        LeafSet ls = this.thePastryNode.getLeafSet();
        if (ls.overlaps()) {
            return;
        }
        if (ls.member(prevNode) && (index = ls.getIndex(prevNode)) != ls.cwSize() && index != -ls.ccwSize()) {
            return;
        }
        Id prevId = prevNode.getNodeId();
        int diffDigit = prevId.indexOfMSDD(key = msg.getTarget(), this.thePastryNode.getRoutingTable().baseBitLength());
        if (diffDigit >= 0 && diffDigit == this.thePastryNode.getNodeId().indexOfMSDD(key, this.thePastryNode.getRoutingTable().baseBitLength())) {
            Map<NodeHandle, Long> map = this.lastTimeSentRouteTablePatch;
            synchronized (map) {
                long lastTime;
                if (this.lastTimeSentRouteTablePatch.containsKey(prevNode) && (lastTime = this.lastTimeSentRouteTablePatch.get(prevNode).longValue()) > this.thePastryNode.getEnvironment().getTimeSource().currentTimeMillis() - (long)this.ROUTE_TABLE_PATCH_THROTTLE) {
                    if (this.logger.level <= 800) {
                        this.logger.log("not sending route table patch to " + prevNode + " because throttled.  Last Time:" + lastTime);
                    }
                    return;
                }
                this.lastTimeSentRouteTablePatch.put(prevNode, this.thePastryNode.getEnvironment().getTimeSource().currentTimeMillis());
            }
            RouteSet[] row = this.thePastryNode.getRoutingTable().getRow(diffDigit);
            BroadcastRouteRow brr = new BroadcastRouteRow(this.thePastryNode.getLocalHandle(), row);
            if (prevNode.isAlive()) {
                if (this.logger.level <= 500) {
                    this.logger.log("Found hole in " + prevNode + "'s routing table. Sending " + brr.toStringFull());
                }
                this.thePastryNode.send(prevNode, brr, null, this.options);
            }
        }
    }

    @Override
    public boolean deliverWhenNotReady() {
        return true;
    }

    @Override
    public void messageForAppl(Message msg) {
        throw new RuntimeException("Should not be called.");
    }

    static /* synthetic */ PastryNode access$800(StandardRouter x0) {
        return x0.thePastryNode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AliveRouterStrategy
    implements RouterStrategy {
        AliveRouterStrategy() {
        }

        @Override
        public NodeHandle pickNextHop(RouteMessage msg, Iterator<NodeHandle> i) {
            NodeHandle first = i.next();
            if (first.getLiveness() < 2) {
                return first;
            }
            while (i.hasNext()) {
                NodeHandle nh = i.next();
                if (nh.getLiveness() < 2) {
                    return nh;
                }
                if (first.getLiveness() <= nh.getLiveness()) continue;
                first = nh;
            }
            if (first.getLiveness() >= 3) {
                return null;
            }
            msg.getOptions().setRerouteIfSuspected(false);
            return first;
        }
    }
}

