/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import rice.environment.params.Parameters;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.util.TimerWeakHashMap;
import rice.pastry.NodeHandle;
import rice.pastry.NodeSetEventSource;
import rice.pastry.NodeSetListener;
import rice.pastry.PastryNode;
import rice.pastry.ReadyStrategy;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RoutingTable;
import rice.pastry.standard.ConsistentJoinMsg;
import rice.pastry.standard.StandardJoinProtocol;
import rice.selector.LoopObserver;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsistentJoinProtocol
extends StandardJoinProtocol
implements Observer,
NodeSetListener,
LoopObserver {
    protected final int MAX_TIME_TO_BE_SCHEDULED;
    protected final int MAX_NUM_TO_HEAR_FROM = 8;
    protected boolean tryingToGoReady = false;
    Map<NodeHandle, Object> gotResponse;
    HashMap<NodeHandle, FailedTime> failed;
    TimerTask cleanupTask;
    int failedNodeExpirationTime;
    int maxFailedEntries;
    HashSet<NodeHandle> observing;
    public final int RETRY_INTERVAL;
    TimerTask retryTask;
    ReadyStrategy nextReadyStrategy;

    public ConsistentJoinProtocol(PastryNode ln, NodeHandle lh, RoutingTable rt, LeafSet ls, ReadyStrategy nextReadyStrategy) {
        this(ln, lh, rt, ls, nextReadyStrategy, null);
    }

    public ConsistentJoinProtocol(PastryNode ln, NodeHandle lh, RoutingTable rt, LeafSet ls, ReadyStrategy nextReadyStrategy, MessageDeserializer md) {
        super(ln, lh, rt, ls, md != null ? md : new CJPDeserializer(ln));
        this.gotResponse = new TimerWeakHashMap<NodeHandle, Object>(ln.getEnvironment().getSelectorManager().getTimer(), 300000);
        this.failed = new HashMap();
        this.observing = new HashSet();
        this.nextReadyStrategy = nextReadyStrategy;
        ls.addNodeSetListener(this);
        ln.addObserver(this);
        Parameters p = ln.getEnvironment().getParameters();
        this.MAX_TIME_TO_BE_SCHEDULED = p.getInt("pastry_protocol_consistentJoin_max_time_to_be_scheduled");
        this.RETRY_INTERVAL = p.getInt("pastry_protocol_consistentJoin_retry_interval");
        this.failedNodeExpirationTime = p.getInt("pastry_protocol_consistentJoin_failedRetentionTime");
        this.maxFailedEntries = p.getInt("pastry_protocol_consistentJoin_maxFailedToSend");
        int cleanupInterval = p.getInt("pastry_protocol_consistentJoin_cleanup_interval");
        ln.getEnvironment().getSelectorManager().addLoopObserver(this);
        this.cleanupTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (((ConsistentJoinProtocol)ConsistentJoinProtocol.this).logger.level <= 500) {
                    ConsistentJoinProtocol.this.logger.log("CJP: Cleanup task.");
                }
                HashMap<NodeHandle, FailedTime> hashMap = ConsistentJoinProtocol.this.failed;
                synchronized (hashMap) {
                    long now = ConsistentJoinProtocol.this.thePastryNode.getEnvironment().getTimeSource().currentTimeMillis();
                    long expiration = now - (long)ConsistentJoinProtocol.this.failedNodeExpirationTime;
                    Iterator<FailedTime> i = ConsistentJoinProtocol.this.failed.values().iterator();
                    while (i.hasNext()) {
                        FailedTime ft = i.next();
                        if (ft.time < expiration) {
                            if (((ConsistentJoinProtocol)ConsistentJoinProtocol.this).logger.level <= 500) {
                                ConsistentJoinProtocol.this.logger.log("CJP: Removing " + ft.handle + " from failed set.");
                            }
                            i.remove();
                            ft.handle.deleteObserver(ConsistentJoinProtocol.this);
                            ConsistentJoinProtocol.this.observing.remove(ft.handle);
                            continue;
                        }
                        if (((ConsistentJoinProtocol)ConsistentJoinProtocol.this).logger.level > 400) continue;
                        ConsistentJoinProtocol.this.logger.log("CJP: Not Removing " + ft.handle + " from failed set until " + (ft.time + (long)ConsistentJoinProtocol.this.failedNodeExpirationTime) + " which is another " + (ft.time + (long)ConsistentJoinProtocol.this.failedNodeExpirationTime - now) + " millis.");
                    }
                }
            }

            public String toString() {
                return "CJP$cleanupTask{" + ConsistentJoinProtocol.this.thePastryNode + "}" + this.cancelled;
            }
        };
        ln.getEnvironment().getSelectorManager().schedule(this.cleanupTask, cleanupInterval, cleanupInterval);
    }

    @Override
    protected void setReady() {
        if (this.joinEvent != null) {
            if (this.logger.level <= 800) {
                this.logger.log("cancelling " + this.joinEvent);
            }
            this.joinEvent.cancel();
            this.joinEvent = null;
        }
        if (this.tryingToGoReady) {
            return;
        }
        this.tryingToGoReady = true;
        if (this.logger.level <= 800) {
            this.logger.log("ConsistentJonProtocol.setReady()");
        }
        this.gotResponse.clear();
        for (NodeHandle nh : this.whoDoWeNeedAResponseFrom()) {
            this.sendTheMessage(nh, false);
        }
        if (this.retryTask == null) {
            this.retryTask = this.thePastryNode.scheduleMsg(new RequestFromEveryoneMsg(this.getAddress()), this.RETRY_INTERVAL, this.RETRY_INTERVAL);
        }
    }

    public void addToLeafSet(NodeHandle nh) {
        this.leafSet.put(nh);
        if (!this.observing.contains(nh)) {
            if (this.logger.level <= 500) {
                this.logger.log("CJP observing " + nh);
            }
            nh.addObserver(this, 40);
            this.observing.add(nh);
        }
    }

    public void requestFromEveryoneWeHaventHeardFrom() {
        if (this.thePastryNode.isReady()) {
            this.retryTask.cancel();
            this.retryTask = null;
            return;
        }
        Collection<NodeHandle> c = this.whoDoWeNeedAResponseFrom();
        if (this.logger.level <= 800) {
            this.logger.log("CJP: timeout1, still waiting to hear from " + c.size() + " nodes.");
        }
        for (NodeHandle nh : c) {
            if (this.logger.level <= 500) {
                this.logger.log("CJP: timeout2, still waiting to hear from " + nh);
            }
            try {
                this.sendTheMessage(nh, false);
            }
            catch (NullPointerException npe) {
                if (this.logger.level <= 900) {
                    this.logger.log("npe, nh = " + nh + " c:" + c);
                }
                throw npe;
            }
        }
    }

    public void otherNodesMaySuspectFaulty(int timeNotScheduled) {
        if (this.logger.level <= 900) {
            this.logger.log("WARNING: CJP.otherNodesMaySuspectFaulty(" + timeNotScheduled + ")");
        }
        this.nextReadyStrategy.stop();
        this.thePastryNode.setReadyStrategy(this.thePastryNode.getDefaultReadyStrategy());
        this.tryingToGoReady = false;
        this.thePastryNode.notifyReadyObservers();
        this.setReady();
    }

    public Collection<NodeHandle> whoDoWeNeedAResponseFrom() {
        int rightIndex;
        HashSet<NodeHandle> ret = new HashSet<NodeHandle>();
        int leftIndex = this.leafSet.ccwSize();
        if (leftIndex > 4) {
            leftIndex = 4;
        }
        if ((rightIndex = this.leafSet.ccwSize()) > 4) {
            rightIndex = 4;
        }
        for (int i = -leftIndex; i <= rightIndex; ++i) {
            NodeHandle nh;
            if (i == 0 || this.gotResponse.get(nh = this.leafSet.get(i)) != null) continue;
            ret.add(nh);
        }
        return ret;
    }

    @Override
    public void receiveMessage(Message msg) {
        if (this.logger.level <= 400) {
            this.logger.log("CJP: receiveMessage(" + msg + ")");
        }
        if (msg instanceof ConsistentJoinMsg) {
            ConsistentJoinMsg cjm = (ConsistentJoinMsg)msg;
            NodeHandle j = cjm.ls.get(0);
            if (j.getLiveness() > 2) {
                if (this.logger.level <= 800) {
                    this.logger.log("got message from dead node:" + msg);
                }
                j.checkLiveness();
            }
            this.failed.remove(j);
            this.addToLeafSet(j);
            for (NodeHandle nh : cjm.failed) {
                if (!this.leafSet.member(nh) || nh.getLiveness() == 3) continue;
                if (this.logger.level <= 500) {
                    this.logger.log("CJP: checking liveness2 on " + nh);
                }
                nh.checkLiveness();
            }
            LeafSet lprime = this.leafSet.copy();
            for (int i = -cjm.ls.ccwSize(); i <= cjm.ls.cwSize(); ++i) {
                NodeHandle nh = cjm.ls.get(i);
                if (this.failed.containsKey(nh) || nh.getLiveness() >= 3) continue;
                lprime.put(nh);
            }
            HashSet<NodeHandle> addThese = new HashSet<NodeHandle>();
            for (int i = -lprime.ccwSize(); i <= lprime.cwSize(); ++i) {
                NodeHandle nh;
                if (i == 0 || this.leafSet.member(nh = lprime.get(i))) continue;
                addThese.add(nh);
            }
            for (NodeHandle nh : addThese) {
                if (this.failed.containsKey(nh) || nh.getLiveness() >= 3) continue;
                this.addToLeafSet(nh);
                this.sendTheMessage(nh, false);
            }
            if (cjm.request) {
                this.sendTheMessage(j, true);
            }
            this.gotResponse.put(j, new Object());
            if (this.tryingToGoReady) {
                this.doneProbing();
            }
        } else if (msg instanceof RequestFromEveryoneMsg) {
            this.requestFromEveryoneWeHaventHeardFrom();
        } else {
            super.receiveMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doneProbing() {
        int leftIndex = this.leafSet.ccwSize();
        int rightIndex = this.leafSet.cwSize();
        if (leftIndex > 4) {
            leftIndex = 4;
        }
        if (rightIndex > 4) {
            rightIndex = 4;
        }
        if (this.leafSet.isComplete() || leftIndex == 4 && rightIndex == 4) {
            ArrayList<NodeHandle> toHearFrom = new ArrayList<NodeHandle>();
            HashSet<NodeHandle> seen = new HashSet<NodeHandle>();
            for (int i = -leftIndex; i <= rightIndex; ++i) {
                if (i == 0) continue;
                NodeHandle nh = this.leafSet.get(i);
                if (!seen.contains(nh) && this.gotResponse.get(nh) == null) {
                    toHearFrom.add(nh);
                }
                seen.add(nh);
            }
            if (toHearFrom.size() == 0) {
                if (!this.thePastryNode.isReady()) {
                    if (this.nextReadyStrategy == null) {
                        this.thePastryNode.setReady();
                    } else {
                        this.nextReadyStrategy.start();
                    }
                    if (this.retryTask != null) {
                        this.retryTask.cancel();
                        this.retryTask = null;
                    }
                    this.tryingToGoReady = false;
                }
            } else if (this.logger.level <= 500) {
                String toHearFromStr = "";
                for (NodeHandle nh : toHearFrom) {
                    toHearFromStr = toHearFromStr + nh + ":" + nh.getLiveness() + ",";
                }
                this.logger.log("CJP: still need to hear from:" + toHearFromStr);
            }
        } else {
            if (this.logger.level <= 500) {
                this.logger.log("CJP: LS is not complete: " + this.leafSet);
            }
            NodeHandle left = null;
            NodeHandle right = null;
            LeafSet leafSet = this.leafSet;
            synchronized (leafSet) {
                int index = -this.leafSet.ccwSize();
                if (index != 0 && index != -this.leafSet.maxSize() / 2) {
                    left = this.leafSet.get(index);
                }
                if ((index = this.leafSet.cwSize()) != 0 && index != this.leafSet.maxSize() / 2) {
                    right = this.leafSet.get(index);
                }
            }
            if (left != null) {
                this.sendTheMessage(left, true);
            }
            if (right != null) {
                this.sendTheMessage(right, true);
            }
        }
    }

    public void sendTheMessage(NodeHandle nh, boolean reply) {
        HashSet<NodeHandle> toSend;
        if (!reply && !this.tryingToGoReady) {
            return;
        }
        if (this.logger.level <= 500) {
            this.logger.log("CJP:  sendTheMessage(" + nh + "," + reply + ")");
        }
        if (this.failed.size() < this.maxFailedEntries) {
            toSend = new HashSet<NodeHandle>(this.failed.keySet());
        } else {
            ArrayList<FailedTime> l = new ArrayList<FailedTime>(this.failed.values());
            Collections.sort(l);
            toSend = new HashSet();
            for (int i = 0; i < this.maxFailedEntries; ++i) {
                FailedTime tf = l.get(i);
                toSend.add(tf.handle);
            }
        }
        this.thePastryNode.send(nh, new ConsistentJoinMsg(this.leafSet, toSend, !reply), null, this.options);
    }

    @Override
    public void nodeSetUpdate(NodeSetEventSource set, NodeHandle handle, boolean added) {
        if (this.thePastryNode.isReady()) {
            return;
        }
        if (added) {
            if (this.gotResponse.get(handle) == null) {
                this.sendTheMessage(handle, false);
            }
        } else {
            this.doneProbing();
        }
    }

    @Override
    public void update(Observable arg0, Object arg) {
        if (this.logger.level <= 300) {
            this.logger.log("CJP: update(" + arg0 + "," + arg + ")" + arg.getClass().getName());
        }
        if (arg0 instanceof NodeHandle) {
            NodeHandle nh = (NodeHandle)arg0;
            if ((Integer)arg == NodeHandle.DECLARED_DEAD) {
                if (this.logger.level <= 500) {
                    this.logger.log("CJP:" + arg0 + " declared dead");
                }
                if (!this.failed.containsKey(nh)) {
                    this.failed.put(nh, new FailedTime(nh, this.thePastryNode.getEnvironment().getTimeSource().currentTimeMillis()));
                }
                this.doneProbing();
            }
            if ((Integer)arg == NodeHandle.DECLARED_LIVE) {
                this.failed.remove(nh);
                if (!this.thePastryNode.isReady() && this.leafSet.test(nh)) {
                    this.leafSet.put(nh);
                    this.sendTheMessage(nh, false);
                }
            }
        } else if (this.logger.level <= 300) {
            this.logger.logException("update()", new Exception("Stack Trace"));
        }
    }

    @Override
    public int delayInterest() {
        return this.MAX_TIME_TO_BE_SCHEDULED;
    }

    @Override
    public void loopTime(int loopTime) {
        this.otherNodesMaySuspectFaulty(loopTime);
    }

    @Override
    public void destroy() {
        if (this.logger.level <= 800) {
            this.logger.log("CJP: destroy() called");
        }
        this.thePastryNode.getEnvironment().getSelectorManager().removeLoopObserver(this);
        this.cleanupTask.cancel();
        Iterator<NodeHandle> it2 = this.observing.iterator();
        while (it2.hasNext()) {
            NodeHandle nh = it2.next();
            nh.deleteObserver(this);
            it2.remove();
        }
        this.observing.clear();
        this.observing = null;
    }

    class RequestFromEveryoneMsg
    extends Message {
        public RequestFromEveryoneMsg(int address) {
            super(address);
        }
    }

    public static class CJPDeserializer
    extends StandardJoinProtocol.SJPDeserializer {
        public CJPDeserializer(PastryNode pn) {
            super(pn);
        }

        public Message deserialize(InputBuffer buf, short type, int priority, NodeHandle sender) throws IOException {
            switch (type) {
                case 2: {
                    return new ConsistentJoinMsg(buf, this.pn, sender);
                }
            }
            return super.deserialize(buf, type, priority, sender);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FailedTime
    implements Comparable<FailedTime> {
        long time;
        NodeHandle handle;

        public FailedTime(NodeHandle handle, long time) {
            this.time = time;
            this.handle = handle;
        }

        @Override
        public int compareTo(FailedTime arg0) {
            FailedTime ft = arg0;
            return (int)(ft.time - this.time);
        }

        public String toString() {
            return "FT:" + this.handle + " " + this.time;
        }
    }
}

