/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.io.IOException;
import java.util.HashSet;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.join.JoinAddress;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.PRawMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsistentJoinMsg
extends PRawMessage {
    private static final long serialVersionUID = -8942404626084999673L;
    public static final short TYPE = 2;
    LeafSet ls;
    boolean request;
    HashSet<NodeHandle> failed;

    public ConsistentJoinMsg(LeafSet ls, HashSet<NodeHandle> failed, boolean request) {
        super(JoinAddress.getCode());
        this.ls = ls;
        this.request = request;
        this.failed = failed;
    }

    public String toString() {
        return "ConsistentJoinMsg " + this.ls + " request:" + this.request;
    }

    @Override
    public short getType() {
        return 2;
    }

    @Override
    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        this.ls.serialize(buf);
        buf.writeBoolean(this.request);
        buf.writeInt(this.failed.size());
        for (NodeHandle h : this.failed) {
            h.serialize(buf);
        }
    }

    public ConsistentJoinMsg(InputBuffer buf, NodeHandleFactory nhf, NodeHandle sender) throws IOException {
        super(JoinAddress.getCode());
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                this.setSender(sender);
                this.ls = LeafSet.build(buf, nhf);
                this.request = buf.readBoolean();
                this.failed = new HashSet();
                int numInSet = buf.readInt();
                for (int i = 0; i < numInSet; ++i) {
                    this.failed.add((NodeHandle)nhf.readNodeHandle(buf));
                }
                break;
            }
            default: {
                throw new IOException("Unknown Version: " + version);
            }
        }
    }
}

