/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.nat.rendezvous;

import java.util.Collection;
import java.util.HashSet;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.sourceroute.manager.simple.NextHopStrategy;
import rice.pastry.leafset.LeafSet;
import rice.pastry.socket.nat.rendezvous.RendezvousSocketNodeHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RendezvousLeafSetNHStrategy
implements NextHopStrategy<MultiInetSocketAddress> {
    LeafSet ls;

    public RendezvousLeafSetNHStrategy(LeafSet leafSet) {
        this.ls = leafSet;
    }

    @Override
    public Collection<MultiInetSocketAddress> getNextHops(MultiInetSocketAddress destination) {
        if (this.ls == null) {
            return null;
        }
        Collection<MultiInetSocketAddress> ret = this.walkLeafSet(destination, 8);
        return ret;
    }

    private Collection<MultiInetSocketAddress> walkLeafSet(MultiInetSocketAddress destination, int numRequested) {
        HashSet<MultiInetSocketAddress> result = new HashSet<MultiInetSocketAddress>();
        LeafSet leafset = this.ls;
        for (int i = 1; i < leafset.maxSize() / 2; ++i) {
            RendezvousSocketNodeHandle snh = (RendezvousSocketNodeHandle)leafset.get(-i);
            if (snh != null && !snh.eaddress.equals(destination) && snh.canContactDirect()) {
                result.add(snh.eaddress);
                if (result.size() >= numRequested) {
                    return result;
                }
            }
            if ((snh = (RendezvousSocketNodeHandle)leafset.get(i)) == null || snh.eaddress.equals(destination) || !snh.canContactDirect()) continue;
            result.add(snh.eaddress);
            if (result.size() < numRequested) continue;
            return result;
        }
        return result;
    }
}

