/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.nat.rendezvous;

import org.mpisws.p2p.transport.multiaddress.AddressStrategy;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.rendezvous.ContactDirectStrategy;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.pastry.socket.nat.rendezvous.RendezvousSocketNodeHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RendezvousContactDirectStrategy
implements ContactDirectStrategy<RendezvousSocketNodeHandle> {
    MultiInetSocketAddress localAddr;
    Environment environment;
    AddressStrategy addressStrategy;
    Logger logger;

    public RendezvousContactDirectStrategy(RendezvousSocketNodeHandle localNodeHandle, AddressStrategy addressStrategy, Environment environment) {
        this.localAddr = localNodeHandle.getAddress();
        this.environment = environment;
        this.addressStrategy = addressStrategy;
        this.logger = environment.getLogManager().getLogger(RendezvousContactDirectStrategy.class, null);
    }

    @Override
    public boolean canContactDirect(RendezvousSocketNodeHandle remoteNode) {
        if (remoteNode.canContactDirect()) {
            return true;
        }
        MultiInetSocketAddress a = remoteNode.getAddress();
        if (a.getNumAddresses() == 1) {
            return a.getInnermostAddress().getAddress().equals(this.localAddr.getInnermostAddress().getAddress());
        }
        boolean ret = this.addressStrategy.getAddress(this.localAddr, a).equals(a.getInnermostAddress());
        if (ret && this.logger.level <= 500) {
            this.logger.log("rendezvous contacting direct:" + remoteNode);
        }
        return ret;
    }
}

