/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.nat.probe;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import org.mpisws.p2p.transport.multiaddress.AddressStrategy;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.networkinfo.ProbeStrategy;
import org.mpisws.p2p.transport.networkinfo.Prober;
import rice.Continuation;
import rice.p2p.commonapi.Cancellable;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.messaging.Message;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.nat.probe.ProbeRequestMessage;
import rice.pastry.socket.nat.rendezvous.RendezvousSocketNodeHandle;
import rice.pastry.transport.PMessageNotification;
import rice.pastry.transport.PMessageReceipt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbeApp
extends PastryAppl
implements ProbeStrategy {
    Prober prober;
    AddressStrategy addressStrategy;

    public ProbeApp(PastryNode pn, Prober prober, AddressStrategy addressStrategy) {
        super(pn, null, 0, null);
        this.prober = prober;
        this.addressStrategy = addressStrategy;
        this.setDeserializer(new MessageDeserializer(){

            public rice.p2p.commonapi.Message deserialize(InputBuffer buf, short type, int priority, rice.p2p.commonapi.NodeHandle sender) throws IOException {
                switch (type) {
                    case 1: {
                        return ProbeRequestMessage.build(buf, ProbeApp.this.getAddress());
                    }
                }
                throw new IllegalArgumentException("Unknown type: " + type);
            }
        });
    }

    @Override
    public void messageForAppl(Message msg) {
        ProbeRequestMessage prm = (ProbeRequestMessage)msg;
        this.handleProbeRequestMessage(prm);
    }

    public void handleProbeRequestMessage(ProbeRequestMessage prm) {
        if (this.logger.level <= 500) {
            this.logger.log("handleProbeRequestMessage(" + prm + ")");
        }
        this.prober.probe(this.addressStrategy.getAddress(((SocketNodeHandle)this.thePastryNode.getLocalHandle()).getAddress(), prm.getProbeRequester()), prm.getUID(), null, null);
    }

    @Override
    public Cancellable requestProbe(MultiInetSocketAddress addr, long uid, final Continuation<Boolean, Exception> deliverResultToMe) {
        if (this.logger.level <= 500) {
            this.logger.log("requestProbe(" + addr + "," + uid + "," + deliverResultToMe + ")");
        }
        ArrayList<SocketNodeHandle> valid = new ArrayList<SocketNodeHandle>();
        for (SocketNodeHandle nh : this.thePastryNode.getLeafSet()) {
            if (nh.equals(this.thePastryNode.getLocalHandle()) || !this.addressStrategy.getAddress(nh.getAddress(), addr).equals(addr.getOutermostAddress())) continue;
            valid.add(nh);
        }
        if (valid.isEmpty()) {
            deliverResultToMe.receiveResult(false);
            return null;
        }
        NodeHandle handle = (NodeHandle)valid.get(this.thePastryNode.getEnvironment().getRandomSource().nextInt(valid.size()));
        ProbeRequestMessage prm = new ProbeRequestMessage(addr, uid, this.getAddress());
        return this.thePastryNode.send(handle, prm, new PMessageNotification(){

            public void sent(PMessageReceipt msg) {
                deliverResultToMe.receiveResult(true);
            }

            public void sendFailed(PMessageReceipt msg, Exception reason) {
                deliverResultToMe.receiveResult(false);
            }
        }, null);
    }

    @Override
    public Collection<InetSocketAddress> getExternalAddresses() {
        ArrayList<InetSocketAddress> ret = new ArrayList<InetSocketAddress>();
        for (NodeHandle nh : this.thePastryNode.getLeafSet()) {
            RendezvousSocketNodeHandle rsnh = (RendezvousSocketNodeHandle)nh;
            if (!rsnh.canContactDirect()) continue;
            ret.add(rsnh.getInetSocketAddress());
        }
        return ret;
    }
}

