/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.util.Serializer;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.Id;
import rice.pastry.NodeHandleFactory;
import rice.pastry.NodeHandleFactoryListener;
import rice.pastry.PastryNode;
import rice.pastry.socket.SocketNodeHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketNodeHandleFactory
implements NodeHandleFactory<SocketNodeHandle>,
Serializer<SocketNodeHandle> {
    protected PastryNode pn;
    protected Map<SocketNodeHandle, SocketNodeHandle> handleSet;
    protected Collection<NodeHandleFactoryListener<SocketNodeHandle>> listeners = new ArrayList<NodeHandleFactoryListener<SocketNodeHandle>>();
    Logger logger;

    public SocketNodeHandleFactory(PastryNode pn) {
        this.pn = pn;
        this.logger = pn.getEnvironment().getLogManager().getLogger(SocketNodeHandleFactory.class, null);
        this.handleSet = new HashMap<SocketNodeHandle, SocketNodeHandle>();
    }

    public SocketNodeHandle getNodeHandle(MultiInetSocketAddress i, long epoch, Id id) {
        SocketNodeHandle handle = new SocketNodeHandle(i, epoch, id, this.pn);
        return this.coalesce(handle);
    }

    @Override
    public SocketNodeHandle readNodeHandle(InputBuffer buf) throws IOException {
        return this.coalesce(SocketNodeHandle.build(buf, this.pn));
    }

    @Override
    public SocketNodeHandle coalesce(SocketNodeHandle h) {
        SocketNodeHandle handle = h;
        if (this.handleSet.containsKey(handle)) {
            return this.handleSet.get(handle);
        }
        handle.setLocalNode(this.pn);
        this.handleSet.put(handle, handle);
        this.notifyListeners(handle);
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(SocketNodeHandle nh) {
        Collection<NodeHandleFactoryListener<SocketNodeHandle>> temp = this.listeners;
        Collection<NodeHandleFactoryListener<SocketNodeHandle>> collection = this.listeners;
        synchronized (collection) {
            temp = new ArrayList<NodeHandleFactoryListener<SocketNodeHandle>>(this.listeners);
        }
        for (NodeHandleFactoryListener<SocketNodeHandle> foo : temp) {
            foo.nodeHandleFound(nh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNodeHandleFactoryListener(NodeHandleFactoryListener<SocketNodeHandle> listener) {
        Collection<NodeHandleFactoryListener<SocketNodeHandle>> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNodeHandleFactoryListener(NodeHandleFactoryListener<SocketNodeHandle> listener) {
        Collection<NodeHandleFactoryListener<SocketNodeHandle>> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public SocketNodeHandle deserialize(InputBuffer buf) throws IOException {
        return this.readNodeHandle(buf);
    }

    @Override
    public void serialize(SocketNodeHandle i, OutputBuffer buf) throws IOException {
        i.serialize(buf);
    }
}

