/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.routing;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.NodeSetI;
import rice.pastry.PastryNode;
import rice.pastry.routing.RoutingTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteSet
implements NodeSetI,
Serializable,
Observer,
Iterable<NodeHandle> {
    public static final short TYPE = 2;
    private static final long serialVersionUID = 8156336294555109590L;
    private NodeHandle[] nodes;
    private int theSize;
    private int closest;
    transient int row;
    transient int col;
    transient PastryNode localNode;
    transient RoutingTable observer;

    public RouteSet(int maxSize, int row, int col, PastryNode local, NodeHandle initialVal) {
        this(maxSize, row, col, local);
        this.nodes[this.theSize++] = initialVal;
        this.closest = 0;
    }

    public RouteSet(int maxSize, int row, int col, PastryNode local) {
        this.localNode = local;
        this.nodes = new NodeHandle[maxSize];
        this.theSize = 0;
        this.closest = -1;
        this.row = row;
        this.col = col;
    }

    public String toString() {
        String s = "RS";
        s = this.col >= 0 ? s + "(" + this.row + "," + Id.tran[this.col] + "):" : s + ":";
        for (int i = 0; i < this.nodes.length; ++i) {
            s = s + this.nodes[i] + ",";
        }
        return s;
    }

    @Override
    public boolean put(NodeHandle handle) {
        if (!handle.isAlive()) {
            return false;
        }
        int worstIndex = -1;
        int worstProximity = Integer.MIN_VALUE;
        for (int i = 0; i < this.theSize; ++i) {
            if (this.nodes[i].equals(handle)) {
                return false;
            }
            if (!this.nodes[i].isAlive()) {
                this.notifyTable(this.nodes[i], false);
                this.nodes[i].deleteObserver(this);
                this.nodes[i] = handle;
                this.notifyTable(handle, true);
                handle.addObserver(this);
                return true;
            }
            int p = this.localNode.proximity(this.nodes[i]);
            if (p < worstProximity) continue;
            worstProximity = p;
            worstIndex = i;
        }
        if (this.theSize < this.nodes.length) {
            this.nodes[this.theSize++] = handle;
            this.notifyTable(handle, true);
            handle.ping();
            handle.addObserver(this);
            return true;
        }
        if (this.localNode.proximity(handle) == Integer.MAX_VALUE) {
            handle.ping();
            handle.addObserver(this);
            return false;
        }
        if (this.localNode.proximity(handle) < worstProximity) {
            this.notifyTable(this.nodes[worstIndex], false);
            this.nodes[worstIndex].deleteObserver(this);
            this.nodes[worstIndex] = handle;
            this.notifyTable(handle, true);
            handle.addObserver(this);
            return true;
        }
        return false;
    }

    @Override
    public void update(Observable o, Object arg) {
        if ((Integer)arg == NodeHandle.PROXIMITY_CHANGED) {
            this.put((NodeHandle)o);
        } else if ((Integer)arg == NodeHandle.DECLARED_DEAD) {
            this.remove((NodeHandle)o);
        }
    }

    public NodeHandle remove(Id nid) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].getNodeId().equals(nid)) continue;
            NodeHandle handle = this.nodes[i];
            this.nodes[i] = this.nodes[--this.theSize];
            this.notifyTable(handle, false);
            handle.deleteObserver(this);
            return handle;
        }
        return null;
    }

    @Override
    public NodeHandle remove(NodeHandle nh) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].equals(nh)) continue;
            NodeHandle handle = this.nodes[i];
            this.nodes[i] = this.nodes[--this.theSize];
            this.notifyTable(handle, false);
            handle.deleteObserver(this);
            return handle;
        }
        return null;
    }

    private void notifyTable(NodeHandle handle, boolean added) {
        if (this.observer != null) {
            this.observer.nodeSetUpdate(this, handle, added);
        }
    }

    public void setRoutingTable(RoutingTable rt) {
        this.observer = rt;
    }

    @Override
    public boolean member(NodeHandle nh) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].equals(nh)) continue;
            return true;
        }
        return false;
    }

    public boolean member(Id nid) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].getNodeId().equals(nid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.theSize;
    }

    public int capacity() {
        return this.nodes.length;
    }

    public void pingAllNew() {
        for (int i = 0; i < this.theSize; ++i) {
            if (this.localNode.proximity(this.nodes[i]) != Integer.MAX_VALUE) continue;
            this.nodes[i].ping();
        }
    }

    public NodeHandle closestNode() {
        return this.closestNode(2);
    }

    public NodeHandle closestNode(int minLiveness) {
        int bestProximity = Integer.MAX_VALUE;
        NodeHandle bestNode = null;
        for (int i = 0; i < this.theSize; ++i) {
            int p;
            if (this.nodes[i].getLiveness() > minLiveness || (p = this.localNode.proximity(this.nodes[i])) > bestProximity) continue;
            bestProximity = p;
            bestNode = this.nodes[i];
            this.closest = i;
        }
        if (bestNode != null && bestProximity == Integer.MAX_VALUE) {
            bestNode.ping();
        }
        return bestNode;
    }

    @Override
    public NodeHandle get(int i) {
        if (i < 0 || i >= this.theSize) {
            throw new NoSuchElementException();
        }
        return this.nodes[i];
    }

    @Override
    public NodeHandle get(Id nid) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].getNodeId().equals(nid)) continue;
            return this.nodes[i];
        }
        return null;
    }

    @Override
    public int getIndex(Id nid) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].getNodeId().equals(nid)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getIndex(NodeHandle nh) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].equals(nh)) continue;
            return i;
        }
        return -1;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.nodes = (NodeHandle[])in.readObject();
        this.theSize = in.readInt();
        this.closest = in.readInt();
        if (this.closest != -1) {
            this.nodes[this.closest].ping();
        }
        this.closest = -1;
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        if (this.closest == -1) {
            this.closestNode();
        }
        NodeHandle[] tmp = new NodeHandle[this.nodes.length];
        int j = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (this.nodes[i] == null || !this.nodes[i].isAlive()) continue;
            tmp[j] = this.nodes[i];
            ++j;
        }
        out.writeObject(tmp);
        out.writeInt(j);
        int closest = -1;
        for (int i = 0; i < j; ++i) {
            if (closest != -1 && this.localNode.proximity(tmp[i]) >= this.localNode.proximity(tmp[closest])) continue;
            closest = i;
        }
        out.writeInt(closest);
    }

    @Override
    public boolean putHandle(rice.p2p.commonapi.NodeHandle handle) {
        return this.put((NodeHandle)handle);
    }

    @Override
    public rice.p2p.commonapi.NodeHandle getHandle(rice.p2p.commonapi.Id id) {
        return this.getHandle((Id)id);
    }

    @Override
    public rice.p2p.commonapi.NodeHandle getHandle(int i) {
        return this.get(i);
    }

    @Override
    public boolean memberHandle(rice.p2p.commonapi.Id id) {
        return this.member((Id)id);
    }

    @Override
    public rice.p2p.commonapi.NodeHandle removeHandle(rice.p2p.commonapi.Id id) {
        return this.remove((Id)id);
    }

    @Override
    public int getIndexHandle(rice.p2p.commonapi.Id id) throws NoSuchElementException {
        return this.getIndex((Id)id);
    }

    @Override
    public short getType() {
        return 2;
    }

    @Override
    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)this.nodes.length);
        buf.writeByte((byte)this.theSize);
        buf.writeByte((byte)this.closest);
        for (int i = 0; i < this.theSize; ++i) {
            this.nodes[i].serialize(buf);
        }
    }

    public RouteSet(InputBuffer buf, NodeHandleFactory nhf, PastryNode local) throws IOException {
        this.localNode = local;
        byte maxSize = buf.readByte();
        this.theSize = buf.readByte();
        this.closest = buf.readByte();
        this.nodes = new NodeHandle[maxSize];
        for (int i = 0; i < this.theSize; ++i) {
            this.nodes[i] = nhf.readNodeHandle(buf);
        }
        this.row = -1;
        this.col = -1;
    }

    public void destroy() {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].deleteObserver(this);
            this.nodes[i] = null;
        }
    }

    @Override
    public Iterator<NodeHandle> iterator() {
        return Arrays.asList(this.nodes).iterator();
    }

    public boolean isEmpty() {
        return this.theSize <= 0;
    }
}

