/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.leafset.testing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.liveness.LivenessListener;
import org.mpisws.p2p.transport.proximity.ProximityListener;
import rice.environment.Environment;
import rice.p2p.commonapi.appsocket.AppSocketReceiver;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeSetEventSource;
import rice.pastry.NodeSetListener;
import rice.pastry.PastryNode;
import rice.pastry.ScheduledMessage;
import rice.pastry.boot.Bootstrapper;
import rice.pastry.client.PastryAppl;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RoutingTable;
import rice.pastry.transport.PMessageNotification;
import rice.pastry.transport.PMessageReceipt;

public class MergeTest {
    public static LeafSet getLeafSet(String str) {
        String[] a = str.split("\\[");
        assert (a.length == 2);
        String[] b = a[1].split("]");
        assert (b.length == 2);
        String s_ccw = a[0];
        String s_cw = b[1];
        String s_base = b[0];
        NodeHandle[] ccw = MergeTest.getHandles(s_ccw);
        MergeTest.flip(ccw);
        NodeHandle base = MergeTest.getHandles(s_base)[0];
        NodeHandle[] cw = MergeTest.getHandles(s_cw);
        LeafSet ls = new LeafSet(base, 24, true, cw, ccw);
        return ls;
    }

    public static void flip(NodeHandle[] nds) {
        for (int a = 0; a < nds.length / 2; ++a) {
            int b = nds.length - a - 1;
            NodeHandle temp = nds[a];
            nds[a] = nds[b];
            nds[b] = temp;
        }
    }

    public static NodeHandle[] getHandles(String str) {
        ArrayList<TestNodeHandle> list = new ArrayList<TestNodeHandle>();
        String[] a = str.split("[< ]");
        for (int ctr = 0; ctr < a.length; ++ctr) {
            if (a[ctr].length() <= 3) continue;
            assert (a[ctr].substring(0, 2).equals("0x"));
            assert (a[ctr].substring(a[ctr].length() - 3, a[ctr].length()).equals("..>"));
            a[ctr] = a[ctr].substring(2, a[ctr].length() - 3);
            list.add(new TestNodeHandle(Id.build(a[ctr])));
        }
        return list.toArray(new NodeHandle[0]);
    }

    public static void main(String[] args) {
        Environment env = new Environment();
        String s_ls1 = "<0xD74D4F..><0xD7B075..><0xD98A9D..><0xDAC7F0..><0xDB39A6..><0xDD5A73..><0xE050B3..><0xE0B735..><0xE33A04..><0xE48D40..><0xE678CB..><0xE73F09..> [ <0xEA5EAF..> ] <0xEBC2BB..><0xEBD2CB..><0xEF7F43..><0xF09044..><0xF10B96..><0xF33C36..><0xF64DA9..><0xF66CD9..><0xF9E251..><0xFB7F46..><0xFC1B02..><0xFC4718..>";
        LeafSet ls1 = MergeTest.getLeafSet(s_ls1);
        String s_ls2 = " [ <0xEA1020..> ] ";
        LeafSet ls2 = MergeTest.getLeafSet(s_ls2);
        PastryNode pn = new PastryNode((Id)ls2.get(0).getId(), env){

            @Override
            public NodeHandle readNodeHandle(InputBuffer buf) throws IOException {
                return null;
            }

            @Override
            public PMessageReceipt send(NodeHandle handle, Message message, PMessageNotification deliverAckToMe, Map<String, Object> options) {
                return null;
            }

            @Override
            public ScheduledMessage scheduleMsgAtFixedRate(Message msg, long delay, long period) {
                return null;
            }

            @Override
            public ScheduledMessage scheduleMsg(Message msg, long delay) {
                return null;
            }

            @Override
            public ScheduledMessage scheduleMsg(Message msg, long delay, long period) {
                return null;
            }

            @Override
            public int proximity(NodeHandle nh) {
                return 0;
            }

            @Override
            public int proximity(NodeHandle nh, Map<String, Object> options) {
                return 0;
            }

            @Override
            public void nodeIsReady() {
            }

            @Override
            public SocketRequestHandle connect(NodeHandle handle, AppSocketReceiver receiver, PastryAppl appl, int timeout) {
                return null;
            }

            @Override
            public NodeHandle coalesce(NodeHandle newHandle) {
                return null;
            }

            @Override
            public Bootstrapper getBootstrapper() {
                return null;
            }

            @Override
            public void addLivenessListener(LivenessListener<NodeHandle> name) {
            }

            @Override
            public boolean checkLiveness(NodeHandle i, Map<String, Object> options) {
                return false;
            }

            @Override
            public int getLiveness(NodeHandle i, Map<String, Object> options) {
                return 0;
            }

            @Override
            public boolean removeLivenessListener(LivenessListener<NodeHandle> name) {
                return false;
            }

            @Override
            public void clearState(NodeHandle i) {
            }

            @Override
            public void addProximityListener(ProximityListener<NodeHandle> listener) {
            }

            @Override
            public boolean removeProximityListener(ProximityListener<NodeHandle> listener) {
                return false;
            }

            @Override
            public String printRouteState() {
                return null;
            }
        };
        RoutingTable rt = new RoutingTable(ls2.get(0), 1, 4, pn);
        ls2.addNodeSetListener(new NodeSetListener(){

            public void nodeSetUpdate(NodeSetEventSource nodeSetEventSource, NodeHandle handle, boolean added) {
                System.out.println("nodeSetUpdate(" + handle + "," + added + ")");
            }
        });
        ls2.merge(ls1, ls1.get(0), rt, false, null);
        env.destroy();
    }

    public static class TestNodeHandle
    extends NodeHandle {
        private Id id;

        public TestNodeHandle(Id id) {
            this.id = id;
        }

        public Id getNodeId() {
            return this.id;
        }

        public int getLiveness() {
            return 1;
        }

        public int proximity() {
            return 1;
        }

        public boolean ping() {
            return true;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TestNodeHandle) {
                return ((TestNodeHandle)obj).id.equals(this.id);
            }
            return false;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public void receiveMessage(Message m) {
        }

        public String toString() {
            return this.id.toString();
        }

        public void serialize(OutputBuffer buf) throws IOException {
            throw new RuntimeException("not implemented.");
        }
    }
}

