/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.leafset;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeSetEventSource;
import rice.pastry.NodeSetListener;
import rice.pastry.NodeSetUpdate;
import rice.pastry.leafset.LeafSet;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimilarSet
extends Observable
implements NodeSetEventSource,
Serializable {
    private static final long serialVersionUID = 2289610430696506873L;
    private NodeHandle ln;
    private boolean clockwise;
    private NodeHandle[] nodes;
    private int theSize;
    private LeafSet leafSet;
    transient ArrayList<NodeSetListener> listeners = new ArrayList();
    transient Id.Distance d1 = new Id.Distance();
    transient Id.Distance d = new Id.Distance();

    private SimilarSet(SimilarSet that, LeafSet ls) {
        this.ln = that.ln;
        this.clockwise = that.clockwise;
        this.nodes = new NodeHandle[that.nodes.length];
        System.arraycopy(that.nodes, 0, this.nodes, 0, this.nodes.length);
        this.theSize = that.theSize;
        this.leafSet = ls;
    }

    protected void swap(int i, int j) {
        NodeHandle handle = this.nodes[i];
        this.nodes[i] = this.nodes[j];
        this.nodes[j] = handle;
    }

    public SimilarSet(LeafSet leafSet, NodeHandle localNode, int size, boolean cw) {
        this.leafSet = leafSet;
        this.ln = localNode;
        this.clockwise = cw;
        this.theSize = 0;
        this.nodes = new NodeHandle[size];
    }

    public SimilarSet(LeafSet leafSet, NodeHandle localNode, int size, boolean cw, NodeHandle[] handles) {
        this.leafSet = leafSet;
        this.ln = localNode;
        this.clockwise = cw;
        this.theSize = Math.min(handles.length, size);
        this.nodes = new NodeHandle[size];
        System.arraycopy(handles, 0, this.nodes, 0, this.theSize);
    }

    public boolean test(NodeHandle handle) {
        Id nid = handle.getNodeId();
        if (nid.equals(this.ln.getNodeId())) {
            return false;
        }
        for (int i = 0; i < this.theSize; ++i) {
            if (!nid.equals(this.nodes[i].getNodeId())) continue;
            return false;
        }
        if (this.theSize < this.nodes.length) {
            return true;
        }
        return !(this.clockwise ? !nid.isBetween(this.ln.getNodeId(), this.nodes[this.theSize - 1].getNodeId()) : !nid.isBetween(this.nodes[this.theSize - 1].getNodeId(), this.ln.getNodeId()));
    }

    public boolean put(NodeHandle handle) {
        return this.put(handle, false);
    }

    public boolean put(NodeHandle handle, boolean suppressNotify) {
        Id nid = handle.getNodeId();
        if (!this.test(handle)) {
            return false;
        }
        if (this.theSize < this.nodes.length) {
            this.nodes[this.theSize] = handle;
            ++this.theSize;
        } else {
            NodeHandle removed = this.nodes[this.theSize - 1];
            this.nodes[this.theSize - 1] = handle;
            if (this.leafSet.isProperlyRemoved(removed) && this.leafSet.observe) {
                this.notifyListeners(removed, false);
            }
        }
        if (this.clockwise) {
            for (int i = this.theSize - 1; i > 0 && nid.isBetween(this.ln.getNodeId(), this.nodes[i - 1].getNodeId()); --i) {
                this.swap(i, i - 1);
            }
        } else {
            for (int i = this.theSize - 1; i > 0 && nid.isBetween(this.nodes[i - 1].getNodeId(), this.ln.getNodeId()); --i) {
                this.swap(i, i - 1);
            }
        }
        if (!suppressNotify && !this.leafSet.testOtherSet(this, handle) && this.leafSet.observe) {
            this.notifyListeners(handle, true);
        }
        return true;
    }

    @Override
    public void addObserver(Observer o) {
        super.addObserver(o);
    }

    @Override
    public void deleteObserver(Observer o) {
        super.deleteObserver(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNodeSetListener(NodeSetListener listener) {
        ArrayList<NodeSetListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNodeSetListener(NodeSetListener listener) {
        ArrayList<NodeSetListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(NodeHandle handle, boolean added) {
        ArrayList<NodeSetListener> arrayList = this.listeners;
        synchronized (arrayList) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).nodeSetUpdate(this, handle, added);
            }
        }
        if (this.countObservers() > 0) {
            this.setChanged();
            this.notifyObservers(new NodeSetUpdate(handle, added));
        }
    }

    public NodeHandle get(Id nid) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].getNodeId().equals(nid)) continue;
            return this.nodes[i];
        }
        return null;
    }

    public NodeHandle get(NodeHandle nh) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].equals(nh)) continue;
            return this.nodes[i];
        }
        return null;
    }

    public NodeHandle get(int i) {
        if (i < -1 || i >= this.theSize) {
            return null;
        }
        if (i == -1) {
            return this.ln;
        }
        return this.nodes[i];
    }

    public boolean member(NodeHandle nid) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].equals(nid)) continue;
            return true;
        }
        return false;
    }

    public boolean member(Id nid) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].getId().equals(nid)) continue;
            return true;
        }
        return false;
    }

    public NodeHandle remove(Id nid) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].getNodeId().equals(nid)) continue;
            return this.remove(i);
        }
        return null;
    }

    public NodeHandle remove(NodeHandle nh) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].equals(nh)) continue;
            return this.remove(i);
        }
        return null;
    }

    void findMoreEntriesFromRoutingTable() {
        if (this.theSize < this.nodes.length) {
            int colIndex;
            RouteSet[] row;
            int rowIndex;
            RoutingTable table = this.leafSet.routingTable;
            if (table == null) {
                return;
            }
            int numRows = table.numRows();
            Id lnId = (Id)this.ln.getId();
            int numCols = table.numColumns();
            byte baseBitLength = table.baseBitLength();
            for (rowIndex = 0; rowIndex < numRows; ++rowIndex) {
                row = table.getRow(rowIndex);
                if (row == null) continue;
                int colIndexStart = lnId.getDigit(rowIndex, baseBitLength);
                if (this.clockwise) {
                    for (colIndex = colIndexStart + 1; colIndex < numCols; ++colIndex) {
                        if (!this.addNextEntry(row[colIndex])) continue;
                        return;
                    }
                    continue;
                }
                for (colIndex = colIndexStart - 1; colIndex >= 0; --colIndex) {
                    if (!this.addNextEntry(row[colIndex])) continue;
                    return;
                }
            }
            for (rowIndex = numRows - 1; rowIndex >= 0; --rowIndex) {
                row = table.getRow(rowIndex);
                if (row == null) continue;
                int colIndexEnd = lnId.getDigit(rowIndex, baseBitLength);
                if (this.clockwise) {
                    for (colIndex = 0; colIndex < colIndexEnd; ++colIndex) {
                        if (!this.addNextEntry(row[colIndex])) continue;
                        return;
                    }
                    continue;
                }
                for (colIndex = numCols - 1; colIndex > colIndexEnd; --colIndex) {
                    if (!this.addNextEntry(row[colIndex])) continue;
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean addNextEntry(RouteSet rs) {
        if (rs == null) {
            return false;
        }
        if (rs.size() == 1) {
            NodeHandle nh = rs.get(0);
            if (!nh.isAlive() || this.put(nh)) {
                // empty if block
            }
            if (this.theSize != this.nodes.length) return false;
            return true;
        }
        ArrayList<NodeHandle> toUse = new ArrayList<NodeHandle>();
        for (int index = 0; index < rs.size(); ++index) {
            NodeHandle nh = rs.get(index);
            if (!nh.isAlive()) continue;
            toUse.add(nh);
        }
        switch (toUse.size()) {
            case 0: {
                return false;
            }
            case 1: {
                NodeHandle nh = (NodeHandle)toUse.get(0);
                if (this.put(nh)) break;
                break;
            }
            default: {
                Collections.sort(toUse, new Comparator<NodeHandle>(){

                    @Override
                    public int compare(NodeHandle a, NodeHandle b) {
                        if (SimilarSet.this.clockwise) {
                            return a.getId().compareTo(b.getId());
                        }
                        return b.getId().compareTo(a.getId());
                    }
                });
                for (NodeHandle nh : toUse) {
                    if (this.put(nh)) continue;
                }
            }
        }
        if (this.theSize != this.nodes.length) return false;
        return true;
    }

    protected NodeHandle remove(int i) {
        if (i < 0 || i >= this.theSize) {
            return null;
        }
        NodeHandle handle = this.nodes[i];
        for (int j = i + 1; j < this.theSize; ++j) {
            this.nodes[j - 1] = this.nodes[j];
        }
        --this.theSize;
        if (this.leafSet.isProperlyRemoved(handle) && this.leafSet.observe) {
            this.notifyListeners(handle, false);
        }
        return handle;
    }

    public int getIndex(Id nid) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].getNodeId().equals(nid)) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(NodeHandle nh) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].equals(nh)) continue;
            return i;
        }
        return -1;
    }

    public int size() {
        return this.theSize;
    }

    public int mostSimilar(Id nid) {
        if (this.theSize == 0) {
            return -1;
        }
        Id.Distance other = this.d;
        Id.Distance minDist = this.ln.getNodeId().distance(nid, this.d1);
        int min = -1;
        for (int i = 0; i < this.theSize; ++i) {
            other = this.nodes[i].getNodeId().distance(nid, other);
            int cmp = other.compareTo(minDist);
            if ((this.clockwise || cmp >= 0) && (!this.clockwise || cmp > 0)) continue;
            Id.Distance tmp = minDist;
            minDist = other;
            other = tmp;
            min = i;
        }
        return min;
    }

    public boolean putHandle(rice.p2p.commonapi.NodeHandle handle) {
        return this.put((NodeHandle)handle);
    }

    public rice.p2p.commonapi.NodeHandle getHandle(int i) {
        return this.get(i);
    }

    public boolean memberHandle(rice.p2p.commonapi.Id id) {
        return this.member((Id)id);
    }

    public rice.p2p.commonapi.NodeHandle removeHandle(rice.p2p.commonapi.Id id) {
        return this.remove((Id)id);
    }

    public int getIndexHandle(rice.p2p.commonapi.Id id) throws NoSuchElementException {
        return this.getIndex((Id)id);
    }

    SimilarSet copy(LeafSet newLeafSet) {
        return new SimilarSet(this, newLeafSet);
    }

    public Collection<NodeHandle> getCollection() {
        ArrayList<NodeHandle> al = new ArrayList<NodeHandle>();
        for (int i = 0; i < this.theSize; ++i) {
            NodeHandle nh = this.nodes[i];
            if (nh == null) continue;
            al.add(nh);
        }
        return al;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.d1 = new Id.Distance();
        this.d = new Id.Distance();
        this.listeners = new ArrayList();
    }

    public String toString() {
        return "SimilarSet{" + this.ln + "}";
    }

    public void destroy() {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i] = null;
        }
        this.theSize = 0;
    }
}

