/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.commonapi;

import java.io.IOException;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.p2p.util.rawserialization.JavaSerializedMessage;
import rice.pastry.NodeHandle;
import rice.pastry.messaging.PRawMessage;

public class PastryEndpointMessage
extends PRawMessage {
    private static final long serialVersionUID = 4499456388556140871L;
    protected RawMessage message;

    public PastryEndpointMessage(int address, Message message, NodeHandle sender) {
        this(address, message instanceof RawMessage ? (RawMessage)message : new JavaSerializedMessage(message), sender);
    }

    public static void checkRawType(RawMessage message) {
        if (message.getType() == 0 && !(message instanceof JavaSerializedMessage)) {
            throw new IllegalArgumentException("Message " + message + " is raw, but its type is 0, this is only allowed by Java Serialized Messages.");
        }
    }

    public PastryEndpointMessage(int address, RawMessage message, NodeHandle sender) {
        super(address);
        PastryEndpointMessage.checkRawType(message);
        this.setSender(sender);
        this.message = message;
        this.setPriority(message.getPriority());
    }

    public Message getMessage() {
        if (this.message.getType() == 0) {
            return ((JavaSerializedMessage)this.message).getMessage();
        }
        return this.message;
    }

    public void setMessage(Message message) {
        if (message instanceof RawMessage) {
            this.setMessage((RawMessage)message);
        } else {
            this.message = new JavaSerializedMessage(message);
        }
    }

    public void setMessage(RawMessage message) {
        this.message = message;
    }

    public String toString() {
        return this.getMessage().toString();
    }

    public short getType() {
        return this.message.getType();
    }

    public void serialize(OutputBuffer buf) throws IOException {
        int priority = this.message.getPriority();
        if (priority > 127) {
            throw new IllegalStateException("Priority must be in the range of -128 to 127.  Lower values are higher priority. Priority of " + this.message + " was " + priority + ".");
        }
        if (priority < -128) {
            throw new IllegalStateException("Priority must be in the range of -128 to 127.  Lower values are higher priority. Priority of " + this.message + " was " + priority + ".");
        }
        this.message.serialize(buf);
    }

    public PastryEndpointMessage(int address, InputBuffer buf, MessageDeserializer md, short type, int priority, NodeHandle sender) throws IOException {
        super(address);
        int version = 0;
        switch (version) {
            case 0: {
                this.setSender(sender);
                this.message = type == 0 ? new JavaSerializedMessage(md.deserialize(buf, type, priority, sender)) : (RawMessage)md.deserialize(buf, type, priority, sender);
                if (this.getMessage() != null) break;
                throw new IOException("PEM.deserialize() message = null type:" + type + " md:" + md);
            }
            default: {
                throw new IOException("Unknown Version: " + version);
            }
        }
    }
}

