/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import org.mpisws.p2p.transport.ClosedChannelException;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.liveness.LivenessListener;
import org.mpisws.p2p.transport.liveness.LivenessProvider;
import org.mpisws.p2p.transport.proximity.ProximityListener;
import org.mpisws.p2p.transport.proximity.ProximityProvider;
import org.mpisws.p2p.transport.util.SocketRequestHandleImpl;
import rice.Continuation;
import rice.Destructable;
import rice.Executable;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.appsocket.AppSocketReceiver;
import rice.p2p.commonapi.exception.AppNotRegisteredException;
import rice.p2p.commonapi.exception.AppSocketException;
import rice.p2p.commonapi.exception.NoReceiverAvailableException;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.pastry.Id;
import rice.pastry.JoinFailedException;
import rice.pastry.NetworkListener;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.NodeHandleFactoryListener;
import rice.pastry.NodeHandleFetcher;
import rice.pastry.NodeSetListener;
import rice.pastry.ReadyStrategy;
import rice.pastry.ScheduledMessage;
import rice.pastry.boot.Bootstrapper;
import rice.pastry.client.PastryAppl;
import rice.pastry.commonapi.PastryEndpoint;
import rice.pastry.commonapi.PastryIdFactory;
import rice.pastry.join.JoinProtocol;
import rice.pastry.leafset.InitiateLeafSetMaintenance;
import rice.pastry.leafset.LeafSet;
import rice.pastry.leafset.LeafSetProtocol;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageDispatch;
import rice.pastry.messaging.PJavaSerializedMessage;
import rice.pastry.messaging.PRawMessage;
import rice.pastry.routing.InitiateRouteSetMaintenance;
import rice.pastry.routing.RouteSetProtocol;
import rice.pastry.routing.Router;
import rice.pastry.routing.RoutingTable;
import rice.pastry.transport.PMessageNotification;
import rice.pastry.transport.PMessageReceipt;
import rice.pastry.transport.PMessageReceiptImpl;
import rice.pastry.transport.SocketAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PastryNode
extends Observable
implements Node,
Destructable,
NodeHandleFactory,
LivenessProvider<NodeHandle>,
ProximityProvider<NodeHandle>,
ProximityListener<NodeHandle>,
TransportLayerCallback<NodeHandle, RawMessage>,
LivenessListener<NodeHandle> {
    public static final byte CONNECTION_UNKNOWN_ERROR = -1;
    public static final byte CONNECTION_UNKNOWN = -100;
    public static final byte CONNECTION_OK = 0;
    public static final byte CONNECTION_NO_APP = 1;
    public static final byte CONNECTION_NO_ACCEPTOR = 2;
    protected Id myNodeId;
    private Environment myEnvironment;
    private MessageDispatch myMessageDispatch;
    protected LeafSet leafSet;
    protected RoutingTable routeSet;
    protected NodeHandle localhandle;
    protected Vector apps;
    protected Logger logger;
    ReadyStrategy readyStrategy;
    protected boolean joinFailed = false;
    protected boolean isDestroyed = false;
    protected Router router;
    protected NodeHandleFactory handleFactory;
    protected JoinProtocol joiner;
    protected Bootstrapper bootstrapper;
    protected TransportLayer<NodeHandle, RawMessage> tl;
    protected ProximityProvider<NodeHandle> proxProvider;
    ReadyStrategy defaultReadyStrategy = null;
    private boolean neverBeenReady = true;
    HashSet<Destructable> destructables = new HashSet();
    protected JoinFailedException joinFailedReason;
    protected int leafSetMaintFreq;
    protected int routeSetMaintFreq;
    protected ScheduledMessage leafSetRoutineMaintenance = null;
    protected ScheduledMessage routeSetRoutineMaintenance = null;
    protected LivenessProvider<NodeHandle> livenessProvider;
    Map<String, Object> vars = new HashMap<String, Object>();
    Collection<LivenessListener<NodeHandle>> livenessListeners = new ArrayList<LivenessListener<NodeHandle>>();
    private ArrayList<NetworkListener> networkListeners = new ArrayList();
    NodeHandleFetcher nodeHandleFetcher;

    public PastryNode(Id id, Environment e) {
        this.myEnvironment = e;
        this.myNodeId = id;
        this.readyStrategy = this.getDefaultReadyStrategy();
        this.apps = new Vector();
        this.logger = e.getLogManager().getLogger(this.getClass(), null);
        e.addDestructable(this);
    }

    public void boot(Object o) {
        if (o == null) {
            this.getBootstrapper().boot(Collections.EMPTY_LIST);
        } else if (o instanceof Collection) {
            this.boot((Collection)o);
        } else {
            this.getBootstrapper().boot(Collections.singleton(o));
        }
    }

    public void boot(Collection o2) {
        ArrayList o = new ArrayList(o2);
        while (o.remove(null)) {
        }
        this.getBootstrapper().boot(o);
    }

    public ReadyStrategy getDefaultReadyStrategy() {
        if (this.defaultReadyStrategy != null) {
            return this.defaultReadyStrategy;
        }
        this.defaultReadyStrategy = new ReadyStrategy(){
            private boolean ready = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setReady(boolean r) {
                if (r != this.ready) {
                    PastryNode pastryNode = PastryNode.this;
                    synchronized (pastryNode) {
                        this.ready = r;
                    }
                    PastryNode.this.notifyReadyObservers();
                }
            }

            public boolean isReady() {
                return this.ready;
            }

            public void start() {
                this.setReady(true);
            }

            public void stop() {
            }
        };
        return this.defaultReadyStrategy;
    }

    public void setReadyStrategy(ReadyStrategy rs) {
        this.readyStrategy = rs;
    }

    public void setElements(NodeHandle lh, MessageDispatch md, LeafSet ls, RoutingTable rt, Router router) {
        this.localhandle = lh;
        this.setMessageDispatch(md);
        this.leafSet = ls;
        this.routeSet = rt;
        this.router = router;
    }

    public void setJoinProtocols(Bootstrapper boot, JoinProtocol joinP, LeafSetProtocol leafsetP, RouteSetProtocol routeP) {
        this.bootstrapper = boot;
        this.joiner = joinP;
    }

    @Override
    public rice.p2p.commonapi.NodeHandle getLocalNodeHandle() {
        return this.localhandle;
    }

    @Override
    public Environment getEnvironment() {
        return this.myEnvironment;
    }

    public NodeHandle getLocalHandle() {
        return this.localhandle;
    }

    public Id getNodeId() {
        return this.myNodeId;
    }

    public boolean isReady() {
        return this.readyStrategy.isReady();
    }

    public MessageDispatch getMessageDispatch() {
        return this.myMessageDispatch;
    }

    public void setMessageDispatch(MessageDispatch md) {
        this.myMessageDispatch = md;
        this.addDestructable(this.myMessageDispatch);
    }

    public Destructable addDestructable(Destructable d) {
        this.destructables.add(d);
        return d;
    }

    public boolean removeDestructable(Destructable d) {
        return this.destructables.remove(d);
    }

    public void nodeIsReady(boolean state) {
    }

    public void setReady() {
        this.setReady(true);
    }

    public void setReady(boolean ready) {
        this.readyStrategy.setReady(ready);
    }

    public NodeHandle coalesce(NodeHandle newHandle) {
        if (this.logger.level <= 400) {
            this.logger.log("coalesce(" + newHandle + ")");
        }
        return this.handleFactory.coalesce(newHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyReadyObservers() {
        boolean ready = this.readyStrategy.isReady();
        if (this.logger.level <= 800) {
            this.logger.log("PastryNode.notifyReadyObservers(" + ready + ")");
        }
        if (ready) {
            this.nodeIsReady();
            this.nodeIsReady(true);
            this.setChanged();
            this.notifyObservers(true);
            if (this.neverBeenReady) {
                Vector tmpApps = new Vector(this.apps);
                Iterator it = tmpApps.iterator();
                while (it.hasNext()) {
                    ((PastryAppl)it.next()).notifyReady();
                }
                this.neverBeenReady = false;
            }
            PastryNode pastryNode = this;
            synchronized (pastryNode) {
                this.notifyAll();
            }
        } else {
            this.nodeIsReady(false);
            this.setChanged();
            this.notifyObservers(new Boolean(false));
        }
    }

    public boolean isClosest(Id key) {
        return this.leafSet.mostSimilar(key) == 0;
    }

    public LeafSet getLeafSet() {
        return this.leafSet;
    }

    public RoutingTable getRoutingTable() {
        return this.routeSet;
    }

    public void addLeafSetObserver(Observer o) {
        this.leafSet.addObserver(o);
    }

    public void deleteLeafSetObserver(Observer o) {
        this.leafSet.deleteObserver(o);
    }

    public void addLeafSetListener(NodeSetListener listener) {
        this.leafSet.addNodeSetListener(listener);
    }

    public void deleteLeafSetListener(NodeSetListener listener) {
        this.leafSet.deleteNodeSetListener(listener);
    }

    public void addRouteSetObserver(Observer o) {
        this.routeSet.addObserver(o);
    }

    public void deleteRouteSetObserver(Observer o) {
        this.routeSet.deleteObserver(o);
    }

    public void addRouteSetListener(NodeSetListener listener) {
        this.routeSet.addNodeSetListener(listener);
    }

    public void removeRouteSetListener(NodeSetListener listener) {
        this.routeSet.removeNodeSetListener(listener);
    }

    public synchronized void receiveMessage(Message msg) {
        if (this.isDestroyed) {
            return;
        }
        if (this.logger.level <= 500) {
            this.logger.log("receiveMessage(" + msg + ")");
        }
        this.myMessageDispatch.dispatchMessage(msg);
    }

    public void registerReceiver(int address, PastryAppl receiver) {
        if (this.logger.level <= 500) {
            this.logger.log("registerReceiver(" + address + "," + receiver + "):" + receiver.getDeserializer());
        }
        this.myMessageDispatch.registerReceiver(address, receiver);
    }

    public void registerApp(PastryAppl app) {
        if (this.isReady()) {
            app.notifyReady();
        }
        this.apps.add(app);
    }

    public String toString() {
        return "PastryNode" + this.localhandle;
    }

    @Override
    public Endpoint registerApplication(Application application, String instance) {
        return new PastryEndpoint(this, application, instance, true);
    }

    @Override
    public Endpoint buildEndpoint(Application application, String instance) {
        return new PastryEndpoint(this, application, instance, false);
    }

    @Override
    public rice.p2p.commonapi.Id getId() {
        return this.getNodeId();
    }

    @Override
    public IdFactory getIdFactory() {
        return new PastryIdFactory(this.getEnvironment());
    }

    public void process(Executable task, Continuation command) {
        try {
            this.myEnvironment.getProcessor().process(task, command, this.myEnvironment.getSelectorManager(), this.myEnvironment.getTimeSource(), this.myEnvironment.getLogManager());
        }
        catch (Exception e) {
            command.receiveException(e);
        }
    }

    @Override
    public void destroy() {
        if (this.isDestroyed) {
            return;
        }
        if (this.logger.level <= 800) {
            this.logger.log("Destroying " + this);
        }
        this.isDestroyed = true;
        for (Destructable d : this.destructables) {
            if (this.logger.level <= 795) {
                this.logger.log("Destroying " + d);
            }
            d.destroy();
        }
        this.getEnvironment().removeDestructable(this);
        if (this.getEnvironment().getSelectorManager().isSelectorThread()) {
            if (this.tl != null) {
                this.tl.destroy();
            }
        } else {
            this.getEnvironment().getSelectorManager().invoke(new Runnable(){

                public void run() {
                    if (PastryNode.this.tl != null) {
                        PastryNode.this.tl.destroy();
                    }
                }
            });
        }
    }

    public SocketRequestHandle connect(final NodeHandle i, final AppSocketReceiver deliverSocketToMe, final PastryAppl appl, int timeout) {
        final SocketRequestHandleImpl<NodeHandle> handle = new SocketRequestHandleImpl<NodeHandle>(i, null, this.logger);
        Runnable r = new Runnable(){

            public void run() {
                final ByteBuffer b = ByteBuffer.allocate(4);
                b.asIntBuffer().put(appl.getAddress());
                b.clear();
                handle.setSubCancellable(PastryNode.this.tl.openSocket(i, new SocketCallback<NodeHandle>(){

                    @Override
                    public void receiveResult(SocketRequestHandle<NodeHandle> c, P2PSocket<NodeHandle> result) {
                        if (c != handle.getSubCancellable()) {
                            throw new RuntimeException("c != handle.getSubCancellable() (indicates a bug in the code) c:" + c + " sub:" + handle.getSubCancellable());
                        }
                        if (PastryNode.this.logger.level <= 400) {
                            PastryNode.this.logger.log("openSocket(" + i + "):receiveResult(" + result + ")");
                        }
                        result.register(false, true, new P2PSocketReceiver<NodeHandle>(){

                            @Override
                            public void receiveSelectResult(P2PSocket<NodeHandle> socket, boolean canRead, boolean canWrite) throws IOException {
                                if (canRead || !canWrite) {
                                    throw new IOException("Expected to write! " + canRead + "," + canWrite);
                                }
                                if (socket.write(b) == -1L) {
                                    deliverSocketToMe.receiveException(new SocketAdapter<NodeHandle>(socket, PastryNode.this.getEnvironment()), new ClosedChannelException("Remote node closed socket while opening.  Try again."));
                                    return;
                                }
                                if (b.hasRemaining()) {
                                    socket.register(false, true, this);
                                } else {
                                    final ByteBuffer answer = ByteBuffer.allocate(1);
                                    socket.register(true, false, new P2PSocketReceiver<NodeHandle>(){

                                        @Override
                                        public void receiveSelectResult(P2PSocket<NodeHandle> socket, boolean canRead, boolean canWrite) throws IOException {
                                            if (socket.read(answer) == -1L) {
                                                deliverSocketToMe.receiveException(new SocketAdapter<NodeHandle>(socket, PastryNode.this.getEnvironment()), new ClosedChannelException("Remote node closed socket while opening.  Try again."));
                                                return;
                                            }
                                            if (!answer.hasRemaining()) {
                                                answer.clear();
                                                byte connectResult = answer.get();
                                                switch (connectResult) {
                                                    case 0: {
                                                        deliverSocketToMe.receiveSocket(new SocketAdapter<NodeHandle>(socket, PastryNode.this.getEnvironment()));
                                                        return;
                                                    }
                                                    case 1: {
                                                        deliverSocketToMe.receiveException(new SocketAdapter<NodeHandle>(socket, PastryNode.this.getEnvironment()), new AppNotRegisteredException(appl.getAddress()));
                                                        return;
                                                    }
                                                    case 2: {
                                                        deliverSocketToMe.receiveException(new SocketAdapter<NodeHandle>(socket, PastryNode.this.getEnvironment()), new NoReceiverAvailableException());
                                                        return;
                                                    }
                                                }
                                                deliverSocketToMe.receiveException(new SocketAdapter<NodeHandle>(socket, PastryNode.this.getEnvironment()), new AppSocketException("Unknown error " + connectResult));
                                                return;
                                            }
                                            socket.register(true, false, this);
                                        }

                                        @Override
                                        public void receiveException(P2PSocket<NodeHandle> socket, Exception ioe) {
                                            deliverSocketToMe.receiveException(new SocketAdapter<NodeHandle>(socket, PastryNode.this.getEnvironment()), ioe);
                                        }
                                    });
                                }
                            }

                            @Override
                            public void receiveException(P2PSocket<NodeHandle> socket, Exception e) {
                                deliverSocketToMe.receiveException(new SocketAdapter<NodeHandle>(socket, PastryNode.this.getEnvironment()), e);
                            }
                        });
                    }

                    @Override
                    public void receiveException(SocketRequestHandle<NodeHandle> s, Exception ex) {
                        deliverSocketToMe.receiveException(null, ex);
                    }
                }, null));
            }
        };
        if (this.myEnvironment.getSelectorManager().isSelectorThread()) {
            r.run();
        } else {
            this.myEnvironment.getSelectorManager().invoke(r);
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinFailed(JoinFailedException cje) {
        if (this.logger.level <= 900) {
            this.logger.log("joinFailed(" + cje + ")");
        }
        this.joinFailedReason = cje;
        PastryNode pastryNode = this;
        synchronized (pastryNode) {
            this.joinFailed = true;
            this.notifyAll();
        }
        this.setChanged();
        this.notifyObservers(cje);
    }

    public boolean joinFailed() {
        return this.joinFailed;
    }

    public JoinFailedException joinFailedReason() {
        return this.joinFailedReason;
    }

    public Router getRouter() {
        return this.router;
    }

    @Override
    public String printRouteState() {
        String ret = this.leafSet.toString() + "\n";
        ret = ret + this.routeSet.toString();
        return ret;
    }

    public void setSocketElements(int lsmf, int rsmf, TransportLayer<NodeHandle, RawMessage> tl, LivenessProvider<NodeHandle> livenessProvider, ProximityProvider<NodeHandle> proxProvider, NodeHandleFactory handleFactory) {
        this.localhandle = this.localhandle;
        this.leafSetMaintFreq = lsmf;
        this.routeSetMaintFreq = rsmf;
        this.handleFactory = handleFactory;
        this.proxProvider = proxProvider;
        proxProvider.addProximityListener(this);
        this.tl = tl;
        this.livenessProvider = livenessProvider;
        tl.setCallback(this);
        livenessProvider.addLivenessListener(this);
    }

    public Map<String, Object> getVars() {
        return this.vars;
    }

    @Override
    public void incomingSocket(P2PSocket<NodeHandle> s) throws IOException {
        final ByteBuffer appIdBuffer = ByteBuffer.allocate(4);
        s.register(true, false, new P2PSocketReceiver<NodeHandle>(){

            @Override
            public void receiveSelectResult(P2PSocket<NodeHandle> socket, boolean canRead, boolean canWrite) throws IOException {
                if (socket.read(appIdBuffer) == -1L) {
                    if (PastryNode.this.logger.level <= 900) {
                        PastryNode.this.logger.log("AppId Socket from " + socket + " closed unexpectedly.");
                    }
                    return;
                }
                if (appIdBuffer.hasRemaining()) {
                    socket.register(true, false, this);
                } else {
                    appIdBuffer.clear();
                    final int appId = appIdBuffer.asIntBuffer().get();
                    socket.register(false, true, new P2PSocketReceiver<NodeHandle>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void receiveSelectResult(P2PSocket<NodeHandle> socket, boolean canRead, boolean canWrite) throws IOException {
                            PastryAppl acceptorAppl = PastryNode.this.getMessageDispatch().getDestinationByAddress(appId);
                            ByteBuffer toWrite = ByteBuffer.allocate(1);
                            boolean success = false;
                            if (acceptorAppl == null) {
                                if (PastryNode.this.logger.level <= 900) {
                                    PastryNode.this.logger.log("Sending error to connecter " + socket + " " + new AppNotRegisteredException(appId));
                                }
                                toWrite.put((byte)1);
                                toWrite.clear();
                                socket.write(toWrite);
                                socket.close();
                            } else {
                                PastryAppl pastryAppl = acceptorAppl;
                                synchronized (pastryAppl) {
                                    if (acceptorAppl.canReceiveSocket()) {
                                        toWrite.put((byte)0);
                                        toWrite.clear();
                                        success = true;
                                    } else {
                                        if (PastryNode.this.logger.level <= 900) {
                                            PastryNode.this.logger.log("Sending error to connecter " + socket + " " + new NoReceiverAvailableException());
                                        }
                                        toWrite.put((byte)2);
                                        toWrite.clear();
                                    }
                                    socket.write(toWrite);
                                    if (toWrite.hasRemaining()) {
                                        if (PastryNode.this.logger.level <= 900) {
                                            PastryNode.this.logger.log("couldn't write 1 bite!!! " + toWrite);
                                        }
                                        socket.close();
                                        return;
                                    }
                                    if (success) {
                                        acceptorAppl.finishReceiveSocket(new SocketAdapter<NodeHandle>(socket, PastryNode.this.getEnvironment()));
                                    }
                                }
                            }
                        }

                        @Override
                        public void receiveException(P2PSocket<NodeHandle> socket, Exception ioe) {
                            if (PastryNode.this.logger.level <= 900) {
                                PastryNode.this.logger.logException("incomingSocket(" + socket + ")", ioe);
                            }
                        }
                    });
                }
            }

            @Override
            public void receiveException(P2PSocket<NodeHandle> socket, Exception ioe) {
                if (PastryNode.this.logger.level <= 900) {
                    PastryNode.this.logger.logException("incomingSocket(" + socket + ")", ioe);
                }
            }
        });
    }

    protected void acceptAppSocket(int appId) throws AppSocketException {
        PastryAppl acceptorAppl = this.getMessageDispatch().getDestinationByAddress(appId);
        if (acceptorAppl == null) {
            throw new AppNotRegisteredException(appId);
        }
        if (!acceptorAppl.canReceiveSocket()) {
            throw new NoReceiverAvailableException();
        }
    }

    public int proximity(NodeHandle nh) {
        return this.proximity(nh, (Map<String, Object>)null);
    }

    @Override
    public int proximity(NodeHandle nh, Map<String, Object> options) {
        return this.proxProvider.proximity(nh, options);
    }

    public ScheduledMessage scheduleMsg(Message msg, long delay) {
        ScheduledMessage sm = new ScheduledMessage(this, msg);
        this.getEnvironment().getSelectorManager().getTimer().schedule(sm, delay);
        return sm;
    }

    public ScheduledMessage scheduleMsg(Message msg, long delay, long period) {
        ScheduledMessage sm = new ScheduledMessage(this, msg);
        this.getEnvironment().getSelectorManager().getTimer().schedule(sm, delay, period);
        return sm;
    }

    public ScheduledMessage scheduleMsgAtFixedRate(Message msg, long delay, long period) {
        ScheduledMessage sm = new ScheduledMessage(this, msg);
        this.getEnvironment().getSelectorManager().getTimer().scheduleAtFixedRate(sm, delay, period);
        return sm;
    }

    public PMessageReceipt send(final NodeHandle handle, final Message msg, final PMessageNotification deliverAckToMe, Map<String, Object> tempOptions) {
        if (tempOptions == null || !tempOptions.containsKey("OPTION_PRIORITY")) {
            tempOptions = tempOptions == null ? new HashMap<String, Object>() : new HashMap<String, Object>(tempOptions);
            tempOptions.put("OPTION_PRIORITY", msg.getPriority());
        }
        final Map<String, Object> options = tempOptions;
        if (handle.equals(this.localhandle)) {
            this.receiveMessage(msg);
            PMessageReceipt ret = new PMessageReceipt(){

                @Override
                public boolean cancel() {
                    return false;
                }

                @Override
                public NodeHandle getIdentifier() {
                    return PastryNode.this.localhandle;
                }

                @Override
                public Map<String, Object> getOptions() {
                    return options;
                }

                @Override
                public Message getMessage() {
                    return msg;
                }

                public String toString() {
                    return "TLPN$PMsgRecpt{" + msg + "," + PastryNode.this.localhandle + "}";
                }
            };
            if (deliverAckToMe != null) {
                deliverAckToMe.sent(ret);
            }
            return ret;
        }
        final PRawMessage rm = msg instanceof PRawMessage ? (PRawMessage)msg : new PJavaSerializedMessage(msg);
        final PMessageReceiptImpl ret = new PMessageReceiptImpl(msg, options);
        final MessageCallback<NodeHandle, RawMessage> callback = deliverAckToMe == null ? null : new MessageCallback<NodeHandle, RawMessage>(){

            @Override
            public void ack(MessageRequestHandle<NodeHandle, RawMessage> msg) {
                if (ret.getInternal() == null) {
                    ret.setInternal(msg);
                }
                deliverAckToMe.sent(ret);
            }

            @Override
            public void sendFailed(MessageRequestHandle<NodeHandle, RawMessage> msg, Exception reason) {
                if (ret.getInternal() == null) {
                    ret.setInternal(msg);
                }
                deliverAckToMe.sendFailed(ret, reason);
            }
        };
        if (this.getEnvironment().getSelectorManager().isSelectorThread()) {
            ret.setInternal(this.tl.sendMessage(handle, rm, callback, options));
        } else {
            this.getEnvironment().getSelectorManager().invoke(new Runnable(){

                public void run() {
                    ret.setInternal(PastryNode.this.tl.sendMessage(handle, rm, callback, options));
                }
            });
        }
        return ret;
    }

    @Override
    public void messageReceived(NodeHandle i, RawMessage m, Map<String, Object> options) throws IOException {
        if (m.getType() == 0 && m instanceof PJavaSerializedMessage) {
            this.receiveMessage(((PJavaSerializedMessage)m).getMessage());
        } else {
            this.receiveMessage((Message)((Object)m));
        }
    }

    public NodeHandle readNodeHandle(InputBuffer buf) throws IOException {
        return this.handleFactory.readNodeHandle(buf);
    }

    public Bootstrapper getBootstrapper() {
        return this.bootstrapper;
    }

    public void doneNode(Collection<NodeHandle> bootstrap) {
        if (this.logger.level <= 800) {
            this.logger.log("doneNode:" + bootstrap);
        }
        if (this.logger.level <= 800) {
            this.logger.log("doneNode:" + bootstrap);
        }
        if (this.routeSetMaintFreq > 0) {
            this.routeSetRoutineMaintenance = this.scheduleMsgAtFixedRate(new InitiateRouteSetMaintenance(), this.routeSetMaintFreq * 1000, this.routeSetMaintFreq * 1000);
            if (this.logger.level <= 700) {
                this.logger.log("Scheduling routeSetMaint for " + this.routeSetMaintFreq * 1000 + "," + this.routeSetMaintFreq * 1000);
            }
        }
        if (this.leafSetMaintFreq > 0) {
            this.leafSetRoutineMaintenance = this.scheduleMsgAtFixedRate(new InitiateLeafSetMaintenance(), this.leafSetMaintFreq * 1000, this.leafSetMaintFreq * 1000);
            if (this.logger.level <= 700) {
                this.logger.log("Scheduling leafSetMaint for " + this.leafSetMaintFreq * 1000 + "," + this.leafSetMaintFreq * 1000);
            }
        }
        this.joiner.initiateJoin(bootstrap);
    }

    @Override
    public void livenessChanged(NodeHandle i, int val, Map<String, Object> options) {
        if (val == 1) {
            i.update(NodeHandle.DECLARED_LIVE);
        } else if (val >= 3) {
            i.update(NodeHandle.DECLARED_DEAD);
        }
        this.notifyLivenessListeners(i, val, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLivenessListener(LivenessListener<NodeHandle> name) {
        Collection<LivenessListener<NodeHandle>> collection = this.livenessListeners;
        synchronized (collection) {
            this.livenessListeners.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLivenessListener(LivenessListener<NodeHandle> name) {
        Collection<LivenessListener<NodeHandle>> collection = this.livenessListeners;
        synchronized (collection) {
            return this.livenessListeners.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLivenessListeners(NodeHandle i, int val, Map<String, Object> options) {
        ArrayList<LivenessListener<NodeHandle>> temp;
        if (this.logger.level <= 500) {
            this.logger.log("notifyLivenessListeners(" + i + "," + val + ")");
        }
        Collection<LivenessListener<NodeHandle>> collection = this.livenessListeners;
        synchronized (collection) {
            temp = new ArrayList<LivenessListener<NodeHandle>>(this.livenessListeners);
        }
        for (LivenessListener<NodeHandle> ll : temp) {
            ll.livenessChanged(i, val, options);
        }
    }

    @Override
    public boolean checkLiveness(NodeHandle i, Map<String, Object> options) {
        return this.livenessProvider.checkLiveness(i, options);
    }

    @Override
    public int getLiveness(NodeHandle i, Map<String, Object> options) {
        return this.livenessProvider.getLiveness(i, options);
    }

    public int getLiveness(NodeHandle i) {
        return this.livenessProvider.getLiveness(i, null);
    }

    public boolean isAlive(NodeHandle i) {
        return this.livenessProvider.getLiveness(i, null) < 3;
    }

    @Override
    public void proximityChanged(NodeHandle handle, int val, Map<String, Object> options) {
        handle.update(NodeHandle.PROXIMITY_CHANGED);
    }

    public LivenessProvider<NodeHandle> getLivenessProvider() {
        return this.livenessProvider;
    }

    public ProximityProvider<NodeHandle> getProxProvider() {
        return this.proxProvider;
    }

    public TransportLayer<NodeHandle, RawMessage> getTL() {
        return this.tl;
    }

    @Override
    public void clearState(NodeHandle i) {
        this.livenessProvider.clearState(i);
    }

    @Override
    public void addProximityListener(ProximityListener<NodeHandle> listener) {
        this.proxProvider.addProximityListener(listener);
    }

    @Override
    public boolean removeProximityListener(ProximityListener<NodeHandle> listener) {
        return this.proxProvider.removeProximityListener(listener);
    }

    public void nodeIsReady() {
    }

    public NodeHandleFactory getHandleFactroy() {
        return this.handleFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNetworkListener(NetworkListener listener) {
        ArrayList<NetworkListener> arrayList = this.networkListeners;
        synchronized (arrayList) {
            this.networkListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNetworkListener(NetworkListener listener) {
        ArrayList<NetworkListener> arrayList = this.networkListeners;
        synchronized (arrayList) {
            this.networkListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterable<NetworkListener> getNetworkListeners() {
        ArrayList<NetworkListener> arrayList = this.networkListeners;
        synchronized (arrayList) {
            return new ArrayList<NetworkListener>(this.networkListeners);
        }
    }

    public void broadcastChannelClosed(InetSocketAddress addr) {
        for (NetworkListener listener : this.getNetworkListeners()) {
            listener.channelClosed(addr);
        }
    }

    public void broadcastChannelOpened(InetSocketAddress addr, int reason) {
        for (NetworkListener listener : this.getNetworkListeners()) {
            listener.channelOpened(addr, reason);
        }
    }

    public void broadcastSentListeners(int address, short msgType, InetSocketAddress dest, int size, int wireType) {
        for (NetworkListener listener : this.getNetworkListeners()) {
            listener.dataSent(address, msgType, dest, size, wireType);
        }
    }

    public void broadcastReceivedListeners(int address, short msgType, InetSocketAddress from, int size, int wireType) {
        for (NetworkListener listener : this.getNetworkListeners()) {
            listener.dataReceived(address, msgType, from, size, wireType);
        }
    }

    public void addNodeHandleFactoryListener(NodeHandleFactoryListener listener) {
        this.handleFactory.addNodeHandleFactoryListener(listener);
    }

    public void removeNodeHandleFactoryListener(NodeHandleFactoryListener listener) {
        this.handleFactory.removeNodeHandleFactoryListener(listener);
    }

    public void setNodeHandleFetcher(NodeHandleFetcher nodeHandleFetcher) {
        this.nodeHandleFetcher = nodeHandleFetcher;
    }

    public void getNodeHandle(Object o, Continuation<NodeHandle, Exception> c) {
        this.nodeHandleFetcher.getNodeHandle(o, c);
    }
}

