/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observer;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawSerializable;
import rice.pastry.Id;
import rice.pastry.PastryNode;
import rice.pastry.messaging.Message;

public abstract class NodeHandle
extends rice.p2p.commonapi.NodeHandle
implements RawSerializable {
    public static final int LIVENESS_ALIVE = 1;
    public static final int LIVENESS_SUSPECTED = 2;
    public static final int LIVENESS_DEAD = 3;
    protected transient PastryNode localnode;
    protected transient Logger logger;
    static final long serialVersionUID = 987479397660721015L;
    transient List<ObsPri> obs = new ArrayList<ObsPri>();

    public abstract Id getNodeId();

    public rice.p2p.commonapi.Id getId() {
        return this.getNodeId();
    }

    public final boolean isAlive() {
        return this.getLiveness() < 3;
    }

    public abstract int getLiveness();

    public boolean checkLiveness() {
        return this.ping();
    }

    public abstract int proximity();

    public abstract boolean ping();

    public final PastryNode getLocalNode() {
        return this.localnode;
    }

    public void assertLocalNode() {
        if (this.localnode == null) {
            throw new RuntimeException("PANIC: localnode is null in " + this + "@" + System.identityHashCode(this));
        }
    }

    public abstract boolean equals(Object var1);

    public void bootstrap(Message msg) throws IOException {
        this.receiveMessage(msg);
    }

    public abstract int hashCode();

    public abstract void receiveMessage(Message var1);

    public abstract void serialize(OutputBuffer var1) throws IOException;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.obs = new ArrayList<ObsPri>();
    }

    public void addObserver(Observer o) {
        this.addObserver(o, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(Observer o, int priority) {
        if (this.logger.level <= 400) {
            this.logger.log(this + ".addObserver(" + o + ")");
        }
        List<ObsPri> list = this.obs;
        synchronized (list) {
            for (int i = 0; i < this.obs.size(); ++i) {
                ObsPri op = this.obs.get(i);
                if (!op.obs.equals(o) || op.pri == priority) continue;
                if (this.logger.level <= 900) {
                    this.logger.log(this + ".addObserver(" + o + "," + priority + ") changed priority, was:" + op);
                }
                op.pri = priority;
                Collections.sort(this.obs);
                return;
            }
            this.obs.add(new ObsPri(o, priority));
            Collections.sort(this.obs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObserver(Observer o) {
        if (this.logger.level <= 400) {
            this.logger.log(this + ".deleteObserver(" + o + ")");
        }
        List<ObsPri> list = this.obs;
        synchronized (list) {
            for (int i = 0; i < this.obs.size(); ++i) {
                ObsPri op = this.obs.get(i);
                if (!op.obs.equals(o)) continue;
                if (this.logger.level <= 300) {
                    this.logger.log(this + ".deleteObserver(" + o + "):success");
                }
                this.obs.remove(i);
                return;
            }
            if (this.logger.level <= 800) {
                this.logger.log(this + ".deleteObserver(" + o + "):failure " + o + " was not an observer.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Object arg) {
        ArrayList<ObsPri> l;
        List<ObsPri> list = this.obs;
        synchronized (list) {
            l = new ArrayList<ObsPri>(this.obs);
        }
        for (ObsPri op : l) {
            if (this.logger.level <= 300) {
                this.logger.log(this + ".notifyObservers(" + arg + "):notifying " + op);
            }
            op.obs.update(this, arg);
        }
    }

    public synchronized int countObservers() {
        return this.obs.size();
    }

    public synchronized void deleteObservers() {
        this.obs.clear();
    }

    public void update(Object update) {
        if (this.logger != null && this.logger.level <= 500) {
            this.logger.log(this + ".update(" + update + ")" + this.countObservers());
        }
        this.notifyObservers(update);
        if (this.logger != null && this.logger.level <= 300) {
            this.logger.log(this + ".update(" + update + ")" + this.countObservers() + " done");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ObsPri
    implements Comparable<ObsPri> {
        Observer obs;
        int pri;

        public ObsPri(Observer o, int priority) {
            this.obs = o;
            this.pri = priority;
        }

        @Override
        public int compareTo(ObsPri o) {
            ObsPri that = o;
            int ret = that.pri - this.pri;
            if (ret == 0) {
                if (that.equals(o)) {
                    return 0;
                }
                return System.identityHashCode(that) - System.identityHashCode(this);
            }
            return ret;
        }

        public String toString() {
            return this.obs + ":" + this.pri;
        }
    }
}

