/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util.testing;

import java.io.IOException;
import java.util.Iterator;
import rice.environment.Environment;
import rice.environment.random.RandomSource;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdSet;
import rice.p2p.multiring.MultiringIdFactory;
import rice.p2p.past.gc.GCIdFactory;
import rice.p2p.util.IdBloomFilter;
import rice.pastry.commonapi.PastryIdFactory;

public class IdBloomFilterReplicationTest {
    public static int NUM = 10000;
    public static int NUM_RUNS = 100;
    public static RandomSource random = null;
    public static IdFactory pFactory = null;
    public static IdFactory factory = null;
    public static GCIdFactory gFactory = null;
    public static Id[] SHARED = new Id[NUM];
    public static Id[] EXTRA = new Id[2 * NUM];
    public static IdSet remote;

    public static void main(String[] args) throws IOException {
        Environment env = new Environment();
        random = env.getRandomSource();
        pFactory = new PastryIdFactory(env);
        factory = new MultiringIdFactory(pFactory.buildRandomId(random), pFactory);
        gFactory = new GCIdFactory(factory);
        IdBloomFilterReplicationTest.doConfig();
    }

    public static void buildShared() {
        int i;
        remote = factory.buildIdSet();
        for (i = 0; i < SHARED.length; ++i) {
            IdBloomFilterReplicationTest.SHARED[i] = factory.buildRandomId(random);
            remote.addId(SHARED[i]);
        }
        for (i = 0; i < EXTRA.length; ++i) {
            IdBloomFilterReplicationTest.EXTRA[i] = factory.buildRandomId(random);
        }
    }

    public static void doConfig() {
        int i;
        System.out.println();
        System.out.println("BPK: " + IdBloomFilter.NUM_BITS_PER_KEY + "\tHASH: " + IdBloomFilter.NUM_HASH_FUNCTIONS);
        System.out.print("\t\t");
        for (i = 0; i < 2 * NUM; i += NUM / 10) {
            System.out.print(i + "\t");
        }
        System.out.println("\n");
        for (i = 0; i < NUM; i += NUM / 10) {
            System.out.print(i + "\t\t");
            System.out.print(IdBloomFilterReplicationTest.doRun(i, 10000) + "\t");
            System.out.println();
        }
    }

    public static double doRun(int has, int extra) {
        int total = 0;
        for (int i = 0; i < NUM_RUNS; ++i) {
            total += IdBloomFilterReplicationTest.run(has, extra);
        }
        return (double)total / (double)NUM_RUNS;
    }

    public static int run(int has, int extra) {
        int i;
        IdBloomFilterReplicationTest.buildShared();
        IdSet local = factory.buildIdSet();
        for (i = 0; i < has; ++i) {
            local.addId(SHARED[i]);
        }
        for (i = 0; i < extra; ++i) {
            local.addId(EXTRA[i]);
        }
        int count = 0;
        int missing = NUM - has;
        while (missing > 0) {
            ++count;
            IdBloomFilter filter = new IdBloomFilter(local);
            Iterator<Id> i2 = remote.getIterator();
            while (i2.hasNext()) {
                Id next = i2.next();
                if (filter.check(next)) continue;
                local.addId(next);
                --missing;
            }
        }
        return count;
    }
}

