/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedLinkedList<E extends Comparable<E>>
extends LinkedList<E> {
    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (Comparable elt : c) {
            this.add((E)elt);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException("Does not guarantee sortedness.");
    }

    @Override
    public void addFirst(E o) {
        throw new UnsupportedOperationException("Does not guarantee sortedness.");
    }

    @Override
    public void addLast(E o) {
        throw new UnsupportedOperationException("Does not guarantee sortedness.");
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        final ListIterator it = super.listIterator(index);
        return new ListIterator<E>(){

            @Override
            public void add(E o) {
                throw new UnsupportedOperationException("Does not guarantee sortedness.");
            }

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                return it.hasPrevious();
            }

            @Override
            public E next() {
                return (Comparable)it.next();
            }

            @Override
            public int nextIndex() {
                return it.nextIndex();
            }

            @Override
            public E previous() {
                return (Comparable)it.previous();
            }

            @Override
            public int previousIndex() {
                return it.previousIndex();
            }

            @Override
            public void remove() {
                it.remove();
            }

            @Override
            public void set(E o) {
                throw new UnsupportedOperationException("Does not guarantee sortedness.");
            }
        };
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException("Does not guarantee sortedness.");
    }

    @Override
    public boolean add(E o) {
        Comparable elt;
        int diff;
        if (this.isEmpty()) {
            super.add(o);
            return true;
        }
        if (((Comparable)this.getFirst()).compareTo(o) >= 0) {
            super.addFirst(o);
            return true;
        }
        if (((Comparable)this.getLast()).compareTo(o) <= 0) {
            super.addLast(o);
            return true;
        }
        ListIterator<E> i = super.listIterator(0);
        while (i.hasNext() && (diff = (elt = (Comparable)i.next()).compareTo(o)) < 0) {
        }
        i.previous();
        i.add(o);
        return true;
    }
}

