/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.replication.testing;

import java.io.IOException;
import java.util.Iterator;
import rice.Continuation;
import rice.environment.Environment;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.testing.CommonAPITest;
import rice.p2p.replication.ReplicationClient;
import rice.p2p.replication.ReplicationImpl;
import rice.persistence.MemoryStorage;

public class ReplicationRegrTest
extends CommonAPITest {
    public static final int REPLICATION_FACTOR = 3;
    public static String INSTANCE = "ReplicationRegrTest";
    protected ReplicationImpl[] replications;
    protected TestReplicationClient[] clients;

    public ReplicationRegrTest(Environment env) throws IOException {
        super(env);
        this.replications = new ReplicationImpl[this.NUM_NODES];
        this.clients = new TestReplicationClient[this.NUM_NODES];
    }

    public static void main(String[] args) throws IOException {
        Environment env = ReplicationRegrTest.parseArgs(args);
        ReplicationRegrTest test = new ReplicationRegrTest(env);
        test.start();
        env.destroy();
    }

    protected void processNode(int num, Node node) {
        this.clients[num] = new TestReplicationClient(node);
        this.replications[num] = new ReplicationImpl(node, this.clients[num], 3, INSTANCE);
    }

    protected void runTest() {
        this.testBasic();
        this.testMaintenance();
    }

    public void testBasic() {
        int num = this.environment.getRandomSource().nextInt(this.NUM_NODES);
        Id id = this.nodes[num].getId();
        IdRange all = this.FACTORY.buildIdRange(this.FACTORY.buildId(new byte[20]), this.FACTORY.buildId(new byte[20]));
        this.sectionStart("Testing Basic Functionality");
        this.stepStart("Inserting Object");
        this.clients[num].insert(id);
        this.stepDone("SUCCESS");
        this.stepStart("Initiating Maintenance");
        this.runMaintenance();
        this.simulate();
        int count = 0;
        for (int i = 0; i < this.NUM_NODES; ++i) {
            if (!this.clients[i].scan(all).isMemberId(id)) continue;
            ++count;
        }
        this.assertTrue("Correct number of replicas should be 4 was " + count, count == 4);
        this.stepDone("SUCCESS");
        this.sectionDone();
    }

    public void testMaintenance() {
        int i;
        int num = this.environment.getRandomSource().nextInt(this.NUM_NODES);
        Id id = this.nodes[num].getId();
        IdRange all = this.FACTORY.buildIdRange(this.FACTORY.buildId(new byte[20]), this.FACTORY.buildId(new byte[20]));
        this.sectionStart("Testing Basic Functionality");
        this.stepStart("Inserting Object");
        this.clients[num].insert(id);
        this.stepDone("SUCCESS");
        this.stepStart("Initiating Maintenance");
        this.runMaintenance();
        this.simulate();
        int count = 0;
        for (i = 0; i < this.NUM_NODES; ++i) {
            if (!this.clients[i].scan(all).isMemberId(id)) continue;
            ++count;
        }
        this.assertTrue("Correct number of replicas should be 4 was " + count, count == 4);
        this.stepDone("SUCCESS");
        this.stepStart("Killing Primary Replica");
        this.kill(num);
        this.waitToRecoverFromKilling(5000);
        this.stepDone("SUCCESS");
        this.stepStart("Initiating Maintenance");
        this.runMaintenance();
        this.simulate();
        count = 0;
        for (i = 0; i < this.NUM_NODES; ++i) {
            if (!this.clients[i].scan(all).isMemberId(id)) continue;
            ++count;
        }
        this.assertTrue("Correct number of replicas should be 5 was " + count, count == 5);
        this.stepDone("SUCCESS");
        this.sectionDone();
    }

    public void runMaintenance() {
        for (int i = 0; i < this.NUM_NODES; ++i) {
            this.replications[i].replicate();
        }
        this.simulate();
    }

    private Id generateId() {
        byte[] data = new byte[20];
        this.environment.getRandomSource().nextBytes(data);
        return this.FACTORY.buildId(data);
    }

    protected class TestReplicationClient
    implements ReplicationClient {
        public MemoryStorage storage;
        public Node node;

        public TestReplicationClient(Node node) {
            this.storage = new MemoryStorage(ReplicationRegrTest.this.FACTORY);
            this.node = node;
        }

        public void fetch(IdSet keySet, NodeHandle hint) {
            Iterator<Id> i = keySet.getIterator();
            while (i.hasNext()) {
                Id next = i.next();
                this.storage.store(next, null, next, new Continuation.ListenerContinuation("Insertion of " + next, ReplicationRegrTest.this.environment));
            }
        }

        public void setRange(IdRange range) {
            IdRange notRange = range.getComplementRange();
            IdSet set = this.storage.scan(notRange);
            Iterator<Id> i = set.getIterator();
            while (i.hasNext()) {
                Id next = i.next();
                this.storage.unstore(next, new Continuation.ListenerContinuation("Removal of " + next, ReplicationRegrTest.this.environment));
            }
        }

        public IdSet scan(IdRange range) {
            return this.storage.scan(range);
        }

        public void insert(Id id) {
            this.storage.store(id, null, id, new Continuation.ListenerContinuation("Insertion of id " + id, ReplicationRegrTest.this.environment));
        }

        public String toString() {
            return "TestRepClient " + this.node.toString();
        }
    }
}

