/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past.testing;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import rice.Continuation;
import rice.environment.Environment;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.p2p.commonapi.testing.CommonAPITest;
import rice.p2p.past.Past;
import rice.p2p.past.PastContent;
import rice.p2p.past.PastContentHandle;
import rice.p2p.past.PastException;
import rice.p2p.past.PastImpl;
import rice.p2p.past.messaging.LookupMessage;
import rice.p2p.past.rawserialization.PastContentDeserializer;
import rice.p2p.past.rawserialization.PastContentHandleDeserializer;
import rice.p2p.past.rawserialization.RawPastContent;
import rice.p2p.past.rawserialization.RawPastContentHandle;
import rice.persistence.LRUCache;
import rice.persistence.MemoryStorage;
import rice.persistence.PersistentStorage;
import rice.persistence.StorageManager;
import rice.persistence.StorageManagerImpl;

public class RawPastRegrTest
extends CommonAPITest {
    public static String INSTANCE = "PastRegrTest";
    public static final int REPLICATION_FACTOR = 3;
    protected StorageManager[] storages;
    protected PastImpl[] pasts = new PastImpl[this.NUM_NODES];
    protected boolean running = true;

    public RawPastRegrTest(Environment env) throws IOException {
        super(env);
        this.storages = new StorageManager[this.NUM_NODES];
        if (this.PROTOCOL == "direct") {
            new Thread(){

                public void run() {
                    while (RawPastRegrTest.this.running) {
                        try {
                            1.sleep(50L);
                            RawPastRegrTest.this.simulate();
                        }
                        catch (Exception e) {
                            System.out.println(e + " blah");
                        }
                    }
                }
            }.start();
        }
    }

    protected void processNode(int num, Node node) {
        try {
            this.storages[num] = new StorageManagerImpl(this.FACTORY, new PersistentStorage(this.FACTORY, "root-" + num, ".", 1000000L, this.environment), new LRUCache(new MemoryStorage(this.FACTORY), 100000, this.environment));
            this.pasts[num] = new PastImpl(node, this.storages[num], 3, INSTANCE);
            this.pasts[num].setContentDeserializer(new PastContentDeserializer(){

                public PastContent deserializePastContent(InputBuffer buf, Endpoint endpoint, short contentType) throws IOException {
                    switch (contentType) {
                        case 1: {
                            return new TestPastContent(buf, endpoint, this);
                        }
                        case 2: {
                            return new VersionedTestPastContent(buf, endpoint, this);
                        }
                        case 3: {
                            return new NonOverwritingTestPastContent(buf, endpoint, this);
                        }
                    }
                    throw new IllegalArgumentException("Unknown type:" + contentType);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.pasts[num].setContentHandleDeserializer(new PastContentHandleDeserializer(){

            public PastContentHandle deserializePastContentHandle(InputBuffer buf, Endpoint endpoint, short contentType) throws IOException {
                switch (contentType) {
                    case 1: {
                        return new TestPastContentHandle(buf, endpoint);
                    }
                }
                throw new IllegalArgumentException("Unknown type:" + contentType);
            }
        });
    }

    protected void runTest() {
        if (this.NUM_NODES < 2) {
            System.out.println("The DistPastRegrTest must be run with at least 2 nodes for proper testing.  Use the '-nodes n' to specify the number of nodes.");
            return;
        }
        this.testRouteRequest();
    }

    protected void testRouteRequest() {
        final PastImpl local = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        final PastImpl remote = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        final Id remoteId = remote.getLocalNodeHandle().getId();
        final TestPastContent file = new TestPastContent(remoteId);
        this.sectionStart("Simple Route Request");
        this.stepStart("Initial Lookup");
        local.lookup(remoteId, new TestCommand(){

            public void receive(Object result) throws Exception {
                RawPastRegrTest.this.assertTrue("File returned should be null", result == null);
                RawPastRegrTest.this.stepDone();
                RawPastRegrTest.this.stepStart("File Insertion");
                local.insert(file, (Continuation)new TestCommand(){

                    public void receive(Object result) throws Exception {
                        RawPastRegrTest.this.assertTrue("Insert of file result should not be null", result != null);
                        RawPastRegrTest.this.assertTrue("Insert of file should return Boolean[]", result instanceof Boolean[]);
                        for (int i = 0; i < ((Boolean[])result).length; ++i) {
                            RawPastRegrTest.this.assertTrue("Insert of file should not return null at replica", ((Boolean[])result)[i] != null);
                            RawPastRegrTest.this.assertTrue("Insert of file should succeed at replica", ((Boolean[])result)[i]);
                        }
                        RawPastRegrTest.this.stepDone();
                        RawPastRegrTest.this.runReplicaMaintence();
                        RawPastRegrTest.this.stepStart("Remote File Lookup");
                        local.lookup(remoteId, new TestCommand(){

                            public void receive(Object result) throws Exception {
                                RawPastRegrTest.this.assertTrue("File should not be null", result != null);
                                RawPastRegrTest.this.assertEquals("Lookup of file should be correct", file, result);
                                RawPastRegrTest.this.stepDone();
                                RawPastRegrTest.this.stepStart("Local File Lookup");
                                remote.getStorageManager().getObject(remoteId, new TestCommand(){

                                    public void receive(Object result) throws Exception {
                                        RawPastRegrTest.this.assertTrue("File should be inserted at known node", result != null);
                                        RawPastRegrTest.this.assertEquals("Retrieved local file should be the same", file, result);
                                        RawPastRegrTest.this.stepDone();
                                        RawPastRegrTest.this.sectionDone();
                                        RawPastRegrTest.this.testVersionControl();
                                    }
                                });
                                RawPastRegrTest.this.simulate();
                            }
                        });
                        RawPastRegrTest.this.simulate();
                    }
                });
                RawPastRegrTest.this.simulate();
            }
        });
        this.simulate();
    }

    protected void testVersionControl() {
        final PastImpl local = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        PastImpl remote = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        final Id remoteId = remote.getLocalNodeHandle().getId();
        final VersionedTestPastContent oldFile = new VersionedTestPastContent(remoteId, 0);
        final VersionedTestPastContent newFile = new VersionedTestPastContent(remoteId, 1);
        final NonOverwritingTestPastContent newNewFile = new NonOverwritingTestPastContent(remoteId, 2);
        this.sectionStart("Version Control");
        this.stepStart("File Insertion");
        local.insert((PastContent)oldFile, (Continuation)new TestCommand(){

            public void receive(Object result) throws Exception {
                RawPastRegrTest.this.assertTrue("Insert of file result should not be null", result != null);
                RawPastRegrTest.this.assertTrue("Insert of file should return Boolean[]", result instanceof Boolean[]);
                for (int i = 0; i < ((Boolean[])result).length; ++i) {
                    RawPastRegrTest.this.assertTrue("Insert of file should not return null at replica", ((Boolean[])result)[i] != null);
                    RawPastRegrTest.this.assertTrue("Insert of file should succeed at replica", ((Boolean[])result)[i]);
                }
                RawPastRegrTest.this.stepDone();
                RawPastRegrTest.this.runReplicaMaintence();
                RawPastRegrTest.this.stepStart("Remote File Lookup");
                local.lookup(remoteId, new TestCommand(){

                    public void receive(Object result) throws Exception {
                        RawPastRegrTest.this.assertTrue("File should not be null", result != null);
                        RawPastRegrTest.this.assertEquals("Lookup of file should be correct", oldFile, result);
                        RawPastRegrTest.this.stepDone();
                        RawPastRegrTest.this.stepStart("Overwriting File Insertion");
                        local.insert(newFile, (Continuation)new TestCommand(){

                            public void receive(Object result) throws Exception {
                                RawPastRegrTest.this.assertTrue("Insert of file result should not be null", result != null);
                                RawPastRegrTest.this.assertTrue("Insert of file should return Boolean[]", result instanceof Boolean[]);
                                for (int i = 0; i < ((Boolean[])result).length; ++i) {
                                    RawPastRegrTest.this.assertTrue("Insert of file should not return null at replica", ((Boolean[])result)[i] != null);
                                    RawPastRegrTest.this.assertTrue("Insert of file should succeed at replica", ((Boolean[])result)[i]);
                                }
                                RawPastRegrTest.this.stepDone();
                                RawPastRegrTest.this.runReplicaMaintence();
                                RawPastRegrTest.this.stepStart("Remote Overwriting File Lookup");
                                local.lookup(remoteId, new TestCommand(){

                                    public void receive(Object result) throws Exception {
                                        RawPastRegrTest.this.assertTrue("Overwriting file should not be null", result != null);
                                        RawPastRegrTest.this.assertEquals("Lookup of overwriting file should be correct version", newFile, result);
                                        RawPastRegrTest.this.stepDone();
                                        RawPastRegrTest.this.stepStart("Non-overwriting File Insertion");
                                        local.insert(newNewFile, (Continuation)new TestCommand(){

                                            public void receive(Object result) throws Exception {
                                                RawPastRegrTest.this.assertTrue("Insert of file result should not be null", result != null);
                                                RawPastRegrTest.this.assertTrue("Insert of file should return Boolean[]", result instanceof Boolean[]);
                                                for (int i = 0; i < ((Boolean[])result).length; ++i) {
                                                    RawPastRegrTest.this.assertTrue("Insert of file should not return null at replica", ((Boolean[])result)[i] != null);
                                                    RawPastRegrTest.this.assertTrue("Insert of file should succeed at replica", ((Boolean[])result)[i]);
                                                }
                                                RawPastRegrTest.this.stepDone();
                                                RawPastRegrTest.this.runReplicaMaintence();
                                                RawPastRegrTest.this.stepStart("Remote Non-Overwriting File Lookup");
                                                local.lookup(remoteId, new TestCommand(){

                                                    public void receive(Object result) throws Exception {
                                                        RawPastRegrTest.this.assertTrue("Non-Overwriting file should not be null", result != null);
                                                        RawPastRegrTest.this.assertEquals("Lookup of non-overwriting file should be correct (second) version", newFile, result);
                                                        RawPastRegrTest.this.stepDone();
                                                        RawPastRegrTest.this.sectionDone();
                                                        RawPastRegrTest.this.testFetch();
                                                    }
                                                });
                                                RawPastRegrTest.this.simulate();
                                            }
                                        });
                                        RawPastRegrTest.this.simulate();
                                    }
                                });
                                RawPastRegrTest.this.simulate();
                            }
                        });
                        RawPastRegrTest.this.simulate();
                    }
                });
                RawPastRegrTest.this.simulate();
            }
        });
        this.simulate();
    }

    protected void testFetch() {
        final PastImpl local = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        final PastImpl remote1 = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        PastImpl tmp = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        while (tmp == remote1) {
            tmp = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        }
        final PastImpl remote2 = tmp;
        final Id id = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)].getLocalNodeHandle().getId();
        final VersionedTestPastContent file1 = new VersionedTestPastContent(id, 1);
        final VersionedTestPastContent file2 = new VersionedTestPastContent(id, 2);
        final TestPastContentHandle handle1 = new TestPastContentHandle(remote1, id);
        final TestPastContentHandle handle2 = new TestPastContentHandle(remote2, id);
        this.sectionStart("Fetch Testing");
        this.stepStart("File 1 Insertion");
        remote1.getStorageManager().store(id, null, file1, new TestCommand(){

            public void receive(Object result) throws Exception {
                RawPastRegrTest.this.assertTrue("Storage of file 1 should succeed", (Boolean)result);
                RawPastRegrTest.this.stepDone();
                RawPastRegrTest.this.stepStart("File 2 Insertion");
                remote2.getStorageManager().store(id, null, file2, new TestCommand(){

                    public void receive(Object result) throws Exception {
                        RawPastRegrTest.this.assertTrue("Storage of file 2 should succeed", (Boolean)result);
                        RawPastRegrTest.this.stepDone();
                        RawPastRegrTest.this.stepStart("File 1 Fetch");
                        local.fetch(handle1, new TestCommand(){

                            public void receive(Object result) throws Exception {
                                RawPastRegrTest.this.assertTrue("Result should be non-null", result != null);
                                RawPastRegrTest.this.assertEquals("Result should be correct", file1, result);
                                RawPastRegrTest.this.assertTrue("Result should not be file 2", !file2.equals(result));
                                final Object received1 = result;
                                RawPastRegrTest.this.stepDone();
                                RawPastRegrTest.this.stepStart("File 2 Fetch");
                                local.fetch(handle2, new TestCommand(){

                                    public void receive(Object result) throws Exception {
                                        RawPastRegrTest.this.assertTrue("Result should be non-null", result != null);
                                        RawPastRegrTest.this.assertEquals("Result should be correct", file2, result);
                                        RawPastRegrTest.this.assertTrue("Result should not be file 1", !file1.equals(result));
                                        Object received2 = result;
                                        RawPastRegrTest.this.stepDone();
                                        RawPastRegrTest.this.stepStart("File 1 and 2 Different");
                                        RawPastRegrTest.this.assertTrue("Files should not be equal", !received1.equals(received2));
                                        RawPastRegrTest.this.stepDone();
                                        RawPastRegrTest.this.stepStart("File 1 Removal");
                                        remote1.getStorageManager().unstore(id, new TestCommand(){

                                            public void receive(Object result) throws Exception {
                                                RawPastRegrTest.this.assertTrue("Removal of file 1 should succeed", (Boolean)result);
                                                RawPastRegrTest.this.stepDone();
                                                RawPastRegrTest.this.stepStart("File 2 Removal");
                                                remote2.getStorageManager().unstore(id, new TestCommand(){

                                                    public void receive(Object result) throws Exception {
                                                        RawPastRegrTest.this.assertTrue("Removal of file 2 should succeed", (Boolean)result);
                                                        RawPastRegrTest.this.stepDone();
                                                        RawPastRegrTest.this.sectionDone();
                                                        RawPastRegrTest.this.testLookupHandles();
                                                    }
                                                });
                                                RawPastRegrTest.this.simulate();
                                            }
                                        });
                                        RawPastRegrTest.this.simulate();
                                    }
                                });
                                RawPastRegrTest.this.simulate();
                            }
                        });
                        RawPastRegrTest.this.simulate();
                    }
                });
                RawPastRegrTest.this.simulate();
            }
        });
        this.simulate();
    }

    protected void testLookupHandles() {
        final PastImpl local = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        PastImpl remote = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        final Id remoteId = remote.getLocalNodeHandle().getId();
        TestPastContent file = new TestPastContent(remoteId);
        this.sectionStart("Lookup Handles Testing");
        this.stepStart("File Insertion");
        local.insert((PastContent)file, (Continuation)new TestCommand(){

            public void receive(Object result) throws Exception {
                RawPastRegrTest.this.assertTrue("Insert of file result should not be null", result != null);
                RawPastRegrTest.this.assertTrue("Insert of file should return Boolean[]", result instanceof Boolean[]);
                for (int i = 0; i < ((Boolean[])result).length; ++i) {
                    RawPastRegrTest.this.assertTrue("Insert of file should not return null at replica", ((Boolean[])result)[i] != null);
                    RawPastRegrTest.this.assertTrue("Insert of file should succeed at replica", ((Boolean[])result)[i]);
                }
                RawPastRegrTest.this.stepDone();
                RawPastRegrTest.this.runReplicaMaintence();
                RawPastRegrTest.this.stepStart("Remote Handles Lookup - 1 Replica");
                local.lookupHandles(remoteId, 1, new TestCommand(){

                    public void receive(Object result) throws Exception {
                        RawPastRegrTest.this.assertTrue("Replicas should not be null", result != null);
                        RawPastRegrTest.this.assertTrue("Replicas should be handle[]", result instanceof PastContentHandle[]);
                        RawPastRegrTest.this.assertTrue("Only 1 replica should be returned", ((PastContentHandle[])result).length == 1);
                        if (((PastContentHandle[])result)[0] == null) {
                            System.out.println("PastRegrTest.problem");
                        }
                        RawPastRegrTest.this.assertEquals("Replica should be for right object", remoteId, ((PastContentHandle[])result)[0].getId());
                        RawPastRegrTest.this.stepDone();
                        RawPastRegrTest.this.stepStart("Remote Handles Lookup - All Replicas");
                        local.lookupHandles(remoteId, 4, new TestCommand(){

                            public void receive(Object result) throws Exception {
                                int i;
                                RawPastRegrTest.this.assertTrue("Replicas should not be null", result != null);
                                RawPastRegrTest.this.assertTrue("Replicas should be handle[]", result instanceof PastContentHandle[]);
                                PastContentHandle[] handles = (PastContentHandle[])result;
                                RawPastRegrTest.this.assertTrue("All replicas should be returned", handles.length == 4 || RawPastRegrTest.this.NUM_NODES < 4 && handles.length == RawPastRegrTest.this.NUM_NODES);
                                for (i = 0; i < handles.length; ++i) {
                                    RawPastRegrTest.this.assertTrue("Replica " + i + " should not be null", handles[i] != null);
                                    RawPastRegrTest.this.assertEquals("Replica " + i + " should be for right object", remoteId, handles[i].getId());
                                }
                                for (i = 0; i < handles.length; ++i) {
                                    for (int j = 0; j < handles.length; ++j) {
                                        if (i == j) continue;
                                        RawPastRegrTest.this.assertTrue("Handles " + handles[i] + " and " + handles[j] + " should be different", !handles[i].getNodeHandle().getId().equals(handles[j].getNodeHandle().getId()));
                                    }
                                }
                                RawPastRegrTest.this.stepDone();
                                RawPastRegrTest.this.stepStart("Remote Handles Lookup - 12 Replicas");
                                local.lookupHandles(remoteId, 12, new TestCommand(){

                                    public void receive(Object result) throws Exception {
                                        int i;
                                        RawPastRegrTest.this.assertTrue("Replicas should not be null", result != null);
                                        RawPastRegrTest.this.assertTrue("Replicas should be handle[]", result instanceof PastContentHandle[]);
                                        PastContentHandle[] handles = (PastContentHandle[])result;
                                        RawPastRegrTest.this.assertTrue("All replicas should be returned, got " + handles.length, handles.length >= 4 || RawPastRegrTest.this.NUM_NODES < 4 && handles.length == RawPastRegrTest.this.NUM_NODES);
                                        int count = 0;
                                        for (i = 0; i < handles.length; ++i) {
                                            if (handles[i] == null) continue;
                                            RawPastRegrTest.this.assertEquals("Replica " + i + " should be for right object", remoteId, handles[i].getId());
                                            ++count;
                                        }
                                        RawPastRegrTest.this.assertTrue("All replicas should be returned (got " + count + "/" + 4 + ")", count == 4);
                                        for (i = 0; i < handles.length; ++i) {
                                            for (int j = 0; j < handles.length; ++j) {
                                                if (i == j || handles[i] == null || handles[j] == null) continue;
                                                RawPastRegrTest.this.assertTrue("Handles " + handles[i] + " and " + handles[j] + " should be different", !handles[i].getNodeHandle().getId().equals(handles[j].getNodeHandle().getId()));
                                            }
                                        }
                                        RawPastRegrTest.this.stepDone();
                                        RawPastRegrTest.this.sectionDone();
                                        RawPastRegrTest.this.testCaching();
                                    }
                                });
                                RawPastRegrTest.this.simulate();
                            }
                        });
                        RawPastRegrTest.this.simulate();
                    }
                });
                RawPastRegrTest.this.simulate();
            }
        });
        this.simulate();
    }

    protected void testCaching() {
        final PastImpl local = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        final Id id1 = this.generateId();
        final Id id2 = this.generateId();
        final TestPastContent file1 = new TestPastContent(id1);
        final TestPastContent file2 = new TestPastContent(id2);
        final NonMutableTestPastContent file3 = new NonMutableTestPastContent(id2);
        this.sectionStart("Caching Testing");
        this.stepStart("Manually Inserting Object Into Cache");
        local.getStorageManager().getCache().cache(id1, null, file1, new TestCommand(){

            public void receive(Object result) throws Exception {
                RawPastRegrTest.this.assertTrue("Object should not be null", result != null);
                RawPastRegrTest.this.assertTrue("Object should be True", result.equals(new Boolean(true)));
                RawPastRegrTest.this.stepDone();
                RawPastRegrTest.this.stepStart("Local Lookup Satisfied by Cache");
                local.lookup(id1, new TestCommand(){

                    public void receive(Object result) throws Exception {
                        RawPastRegrTest.this.assertTrue("File should not be null", result != null);
                        RawPastRegrTest.this.assertEquals("Lookup of file should be correct", file1, result);
                        RawPastRegrTest.this.stepDone();
                        RawPastRegrTest.this.stepStart("Caching Mutable Object");
                        final LookupMessage lmsg = new LookupMessage(1, id2, local.getLocalNodeHandle(), id2);
                        lmsg.receiveResult(file2);
                        RawPastRegrTest.this.assertTrue("Message should continue to be routed", local.forward(new TestRouteMessage(id2, null, lmsg)));
                        RawPastRegrTest.this.stepDone();
                        RawPastRegrTest.this.stepStart("Cache Shouldn't Contain Object");
                        local.getStorageManager().getObject(id2, new TestCommand(){

                            public void receive(Object result) throws Exception {
                                RawPastRegrTest.this.assertTrue("Object should be null", result == null);
                                RawPastRegrTest.this.stepDone();
                                RawPastRegrTest.this.stepStart("Caching Non-Mutable Object");
                                lmsg.receiveResult(file3);
                                RawPastRegrTest.this.assertTrue("Message should continue to be routed", local.forward(new TestRouteMessage(id2, null, lmsg)));
                                RawPastRegrTest.this.stepDone();
                                RawPastRegrTest.this.stepStart("Cache Should Contain Object");
                                local.getStorageManager().getObject(id2, new TestCommand(){

                                    public void receive(Object result) throws Exception {
                                        RawPastRegrTest.this.stepDone();
                                        LookupMessage lmsg = new LookupMessage(-1, id2, local.getLocalNodeHandle(), id2);
                                        RawPastRegrTest.this.stepStart("Lookup Satisfied By Cache");
                                        RawPastRegrTest.this.stepDone();
                                        RawPastRegrTest.this.sectionDone();
                                        RawPastRegrTest.this.cleanUp();
                                    }
                                });
                                RawPastRegrTest.this.simulate();
                            }
                        });
                        RawPastRegrTest.this.simulate();
                    }
                });
                RawPastRegrTest.this.simulate();
            }
        });
        this.simulate();
    }

    private void runReplicaMaintence() {
        for (int i = 0; i < this.NUM_NODES; ++i) {
            this.pasts[i].getReplication().replicate();
        }
        this.simulate();
    }

    private Id generateId() {
        byte[] data = new byte[20];
        this.environment.getRandomSource().nextBytes(data);
        return this.FACTORY.buildId(data);
    }

    public static void main(String[] args) throws Exception {
        LinkedList<File> delme = new LinkedList<File>();
        delme.add(new File("FreePastry-Storage-Root"));
        while (!delme.isEmpty()) {
            File f = (File)delme.removeFirst();
            if (f.isDirectory()) {
                File[] subs = f.listFiles();
                if (subs.length == 0) {
                    f.delete();
                    continue;
                }
                delme.addAll(Arrays.asList(subs));
                delme.addLast(f);
                continue;
            }
            f.delete();
        }
        Environment env = RawPastRegrTest.parseArgs(args);
        env.getParameters().setDouble("p2p_past_successfulInsertThreshold", 1.0);
        RawPastRegrTest pastTest = new RawPastRegrTest(env);
        pastTest.start();
    }

    protected void cleanUp() {
        this.running = false;
        this.environment.destroy();
    }

    protected static class TestRouteMessage
    implements RouteMessage {
        private Id id;
        private NodeHandle nextHop;
        private Message message;

        public TestRouteMessage(Id id, NodeHandle nextHop, Message message) {
            this.id = id;
            this.nextHop = nextHop;
            this.message = message;
        }

        public Id getDestinationId() {
            return this.id;
        }

        public NodeHandle getNextHopHandle() {
            return this.nextHop;
        }

        public Message getMessage() {
            return this.message;
        }

        public Message getMessage(MessageDeserializer md) {
            return this.message;
        }

        public void setDestinationId(Id id) {
            this.id = id;
        }

        public void setNextHopHandle(NodeHandle nextHop) {
            this.nextHop = nextHop;
        }

        public void setMessage(Message message) {
            this.message = message;
        }

        public void setMessage(RawMessage message) {
            this.message = message;
        }
    }

    protected static class TestPastContentHandle
    implements RawPastContentHandle {
        public static final short TYPE = 1;
        protected NodeHandle handle;
        protected Id id;

        public TestPastContentHandle(Past past, Id id) {
            this.handle = past.getLocalNodeHandle();
            this.id = id;
        }

        public Id getId() {
            return this.id;
        }

        public NodeHandle getNodeHandle() {
            return this.handle;
        }

        public short getType() {
            return 1;
        }

        public TestPastContentHandle(InputBuffer buf, Endpoint endpoint) throws IOException {
            this.handle = endpoint.readNodeHandle(buf);
            this.id = endpoint.readId(buf, buf.readShort());
        }

        public void serialize(OutputBuffer buf) throws IOException {
            this.handle.serialize(buf);
            buf.writeShort(this.id.getType());
            this.id.serialize(buf);
        }
    }

    protected static class NonMutableTestPastContent
    extends TestPastContent {
        public NonMutableTestPastContent(Id id) {
            super(id);
        }

        public boolean isMutable() {
            return false;
        }

        public boolean equals(Object o) {
            if (!(o instanceof NonMutableTestPastContent)) {
                return false;
            }
            return ((NonMutableTestPastContent)o).id.equals(this.id);
        }
    }

    protected static class NonOverwritingTestPastContent
    extends VersionedTestPastContent {
        public static final short TYPE = 3;

        public NonOverwritingTestPastContent(Id id, int version) {
            super(id, version);
        }

        public PastContent checkInsert(Id id, PastContent existingContent) throws PastException {
            return existingContent;
        }

        public String toString() {
            return "NonOverwritingTestPastContent(" + this.id + ", " + this.version + ")";
        }

        public short getType() {
            return 3;
        }

        public NonOverwritingTestPastContent(InputBuffer buf, Endpoint endpoint, PastContentDeserializer pcd) throws IOException {
            super(buf, endpoint, pcd);
        }

        public boolean equals(Object o) {
            if (!(o instanceof NonOverwritingTestPastContent)) {
                return false;
            }
            return ((NonOverwritingTestPastContent)o).id.equals(this.id) && ((NonOverwritingTestPastContent)o).version == this.version;
        }
    }

    protected static class VersionedTestPastContent
    extends TestPastContent {
        public static final short TYPE = 2;
        protected int version = 0;

        public VersionedTestPastContent(Id id, int version) {
            super(id);
            this.version = version;
        }

        public boolean equals(Object o) {
            if (!(o instanceof VersionedTestPastContent)) {
                return false;
            }
            return ((VersionedTestPastContent)o).id.equals(this.id) && ((VersionedTestPastContent)o).version == this.version;
        }

        public String toString() {
            return "VersionedTestPastContent(" + this.id + ", " + this.version + ")";
        }

        public short getType() {
            return 2;
        }

        public VersionedTestPastContent(InputBuffer buf, Endpoint endpoint, PastContentDeserializer pcd) throws IOException {
            super(buf, endpoint, pcd);
            this.version = buf.readInt();
        }

        public void serialize(OutputBuffer buf) throws IOException {
            super.serialize(buf);
            buf.writeInt(this.version);
        }
    }

    protected static class TestPastContent
    implements RawPastContent {
        public static final short TYPE = 1;
        protected Id id;
        protected RawPastContent existing;

        public TestPastContent(Id id) {
            this.id = id;
        }

        public PastContent checkInsert(Id id, PastContent existingContent) throws PastException {
            this.existing = (RawPastContent)existingContent;
            return this;
        }

        public PastContentHandle getHandle(Past past) {
            return new TestPastContentHandle(past, this.id);
        }

        public Id getId() {
            return this.id;
        }

        public boolean isMutable() {
            return true;
        }

        public boolean equals(Object o) {
            if (!(o instanceof TestPastContent)) {
                return false;
            }
            return ((TestPastContent)o).id.equals(this.id);
        }

        public String toString() {
            return "TestPastContent(" + this.id + ")";
        }

        public short getType() {
            return 1;
        }

        public TestPastContent(InputBuffer buf, Endpoint endpoint, PastContentDeserializer pcd) throws IOException {
            this.id = endpoint.readId(buf, buf.readShort());
            if (buf.readBoolean()) {
                short contentType = buf.readShort();
                this.existing = (RawPastContent)pcd.deserializePastContent(buf, endpoint, contentType);
            }
        }

        public void serialize(OutputBuffer buf) throws IOException {
            buf.writeShort(this.id.getType());
            this.id.serialize(buf);
            if (this.existing == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                buf.writeShort(this.existing.getType());
                this.existing.serialize(buf);
            }
        }
    }

    protected class TestExceptionCommand
    implements Continuation {
        protected TestExceptionCommand() {
        }

        public void receiveResult(Object result) {
            RawPastRegrTest.this.stepDone("FAILURE", "Command should throw an exception - got " + result);
        }

        public void receive(Object result) throws Exception {
        }

        public void receiveException(Exception e) {
            try {
                this.receive(e);
            }
            catch (Exception ex) {
                this.receiveException(ex);
            }
        }
    }

    protected class TestCommand
    implements Continuation {
        protected TestCommand() {
        }

        public void receiveResult(Object result) {
            try {
                this.receive(result);
            }
            catch (Exception e) {
                this.receiveException(e);
            }
        }

        public void receive(Object result) throws Exception {
        }

        public void receiveException(Exception e) {
            RawPastRegrTest.this.stepException(e);
        }
    }
}

