/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier.v2.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.glacier.FragmentKey;
import rice.p2p.glacier.v2.messaging.GlacierMessage;

public class GlacierResponseMessage
extends GlacierMessage {
    public static final short TYPE = 13;
    protected FragmentKey[] keys;
    protected long[] lifetimes;
    protected boolean[] haveIt;
    protected boolean[] authoritative;

    public GlacierResponseMessage(int uid, FragmentKey key, boolean haveIt, long lifetime, boolean authoritative, NodeHandle source, Id dest, boolean isResponse, char tag) {
        this(uid, new FragmentKey[]{key}, new boolean[]{haveIt}, new long[]{lifetime}, new boolean[]{authoritative}, source, dest, isResponse, tag);
    }

    public GlacierResponseMessage(int uid, FragmentKey[] keys, boolean[] haveIt, long[] lifetimes, boolean[] authoritative, NodeHandle source, Id dest, boolean isResponse, char tag) {
        super(uid, source, dest, isResponse, tag);
        this.keys = keys;
        this.haveIt = haveIt;
        this.authoritative = authoritative;
        this.lifetimes = lifetimes;
    }

    public int numKeys() {
        return this.keys.length;
    }

    public FragmentKey getKey(int index) {
        return this.keys[index];
    }

    public boolean getHaveIt(int index) {
        return this.haveIt[index];
    }

    public boolean getAuthoritative(int index) {
        return this.authoritative[index];
    }

    public long getExpiration(int index) {
        return this.lifetimes[index];
    }

    public String toString() {
        return "[GlacierResponse for " + this.keys[0] + " (" + (this.numKeys() - 1) + " more keys)]";
    }

    public short getType() {
        return 13;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        int i;
        buf.writeByte((byte)0);
        super.serialize(buf);
        buf.writeInt(this.keys.length);
        for (i = 0; i < this.keys.length; ++i) {
            this.keys[i].serialize(buf);
        }
        buf.writeInt(this.lifetimes.length);
        for (i = 0; i < this.lifetimes.length; ++i) {
            buf.writeLong(this.lifetimes[i]);
        }
        buf.writeInt(this.authoritative.length);
        for (i = 0; i < this.authoritative.length; ++i) {
            buf.writeBoolean(this.authoritative[i]);
        }
        buf.writeInt(this.haveIt.length);
        for (i = 0; i < this.haveIt.length; ++i) {
            buf.writeBoolean(this.haveIt[i]);
        }
    }

    public static GlacierResponseMessage build(InputBuffer buf, Endpoint endpoint) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new GlacierResponseMessage(buf, endpoint);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }

    private GlacierResponseMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        super(buf, endpoint);
        int i;
        this.keys = new FragmentKey[buf.readInt()];
        for (i = 0; i < this.keys.length; ++i) {
            this.keys[i] = new FragmentKey(buf, endpoint);
        }
        this.lifetimes = new long[buf.readInt()];
        for (i = 0; i < this.lifetimes.length; ++i) {
            this.lifetimes[i] = buf.readLong();
        }
        this.authoritative = new boolean[buf.readInt()];
        for (i = 0; i < this.authoritative.length; ++i) {
            this.authoritative[i] = buf.readBoolean();
        }
        this.haveIt = new boolean[buf.readInt()];
        for (i = 0; i < this.haveIt.length; ++i) {
            this.haveIt[i] = buf.readBoolean();
        }
    }
}

