/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.glacier.VersionKey;
import rice.p2p.util.MathUtils;

public class FragmentKey
implements Id {
    public static final short TYPE = 42;
    protected VersionKey key;
    protected int id;
    private static final long serialVersionUID = 5373228569261524536L;

    public FragmentKey(VersionKey key, int id) {
        this.id = id;
        this.key = key;
    }

    public boolean isBetween(Id ccw, Id cw) {
        throw new RuntimeException("FragmentKey.isBetween() is not supported!");
    }

    public VersionKey getVersionKey() {
        return this.key;
    }

    public int getFragmentID() {
        return this.id;
    }

    public FragmentKey getPeerKey(int otherId) {
        return new FragmentKey(this.key, otherId);
    }

    public boolean equals(Object peer) {
        if (!(peer instanceof FragmentKey)) {
            return false;
        }
        FragmentKey sk = (FragmentKey)peer;
        return sk.key.equals(this.key) && sk.id == this.id;
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.getByteArrayLength()];
        this.toByteArray(result, 0);
        return result;
    }

    public void toByteArray(byte[] result, int offset) {
        this.key.toByteArray(result, offset);
        MathUtils.intToByteArray(this.id, result, offset + this.key.getByteArrayLength());
    }

    public int getByteArrayLength() {
        return this.key.getByteArrayLength() + 4;
    }

    public String toStringFull() {
        return this.key.toStringFull() + "#" + this.id;
    }

    public String toString() {
        return this.key.toString() + "#" + this.id;
    }

    public Id.Distance longDistanceFromId(Id nid) {
        throw new RuntimeException("FragmentKey.longDistanceFromId() is not supported!");
    }

    public Id.Distance distanceFromId(Id nid) {
        throw new RuntimeException("FragmentKey.distanceFromId() is not supported!");
    }

    public Id addToId(Id.Distance offset) {
        throw new RuntimeException("FragmentKey.addToId() is not supported!");
    }

    public boolean clockwise(Id nid) {
        throw new RuntimeException("FragmentKey.clockwise() is not supported!");
    }

    public int compareTo(Id o) {
        int keyResult = this.key.compareTo(((FragmentKey)o).key);
        if (keyResult != 0) {
            return keyResult;
        }
        if (this.id < ((FragmentKey)o).id) {
            return -1;
        }
        if (this.id > ((FragmentKey)o).id) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return this.key.hashCode() + this.id;
    }

    public FragmentKey(InputBuffer buf, Endpoint endpoint) throws IOException {
        this.id = buf.readInt();
        this.key = new VersionKey(buf, endpoint);
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeInt(this.id);
        this.key.serialize(buf);
    }

    public short getType() {
        return 42;
    }
}

