/*
 * Decompiled with CFR 0.152.
 */
package rice.environment.processing.simple;

import java.util.LinkedList;
import java.util.List;
import rice.environment.processing.WorkRequest;
import rice.environment.processing.simple.WorkQueueOverflowException;

public class WorkQueue {
    List<WorkRequest> q = new LinkedList<WorkRequest>();
    int capacity = -1;
    volatile boolean running = true;

    public WorkQueue() {
    }

    public synchronized int getLength() {
        return this.q.size();
    }

    public WorkQueue(int capacity) {
        this.capacity = capacity;
    }

    public synchronized void enqueue(WorkRequest request) {
        if (this.capacity < 0 || this.q.size() < this.capacity) {
            this.q.add(request);
            this.notifyAll();
        } else {
            request.returnError(new WorkQueueOverflowException());
        }
    }

    public synchronized WorkRequest dequeue() {
        while (this.q.isEmpty() && this.running) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (!this.running) {
            return null;
        }
        return this.q.remove(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.running = false;
        WorkQueue workQueue = this;
        synchronized (workQueue) {
            this.notifyAll();
        }
    }
}

