/*
 * Decompiled with CFR 0.152.
 */
package rice.environment.processing.simple;

import rice.Continuation;
import rice.Executable;
import rice.environment.logging.LogManager;
import rice.environment.logging.Logger;
import rice.environment.time.TimeSource;
import rice.p2p.commonapi.Cancellable;
import rice.selector.SelectorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessingRequest
implements Runnable,
Comparable<ProcessingRequest>,
Cancellable {
    Continuation c;
    Executable r;
    private boolean cancelled = false;
    private boolean running = false;
    TimeSource timeSource;
    SelectorManager selectorManager;
    Logger logger;
    int priority = 0;
    long seq;

    public ProcessingRequest(Executable r, Continuation c, int priority, long seq, LogManager logging, TimeSource timeSource, SelectorManager selectorManager) {
        this.r = r;
        this.c = c;
        this.logger = logging.getLogger(this.getClass(), null);
        this.timeSource = timeSource;
        this.selectorManager = selectorManager;
        this.priority = priority;
        this.seq = seq;
    }

    public void returnResult(Object o) {
        this.c.receiveResult(o);
    }

    public void returnError(Exception e) {
        this.c.receiveException(e);
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(ProcessingRequest request) {
        if (this.priority == request.getPriority()) {
            if (this.seq > request.seq) {
                return 1;
            }
            return -1;
        }
        if (this.priority > request.getPriority()) {
            return 1;
        }
        return -1;
    }

    @Override
    public void run() {
        if (this.cancelled) {
            return;
        }
        this.running = true;
        if (this.logger.level <= 400) {
            this.logger.log("COUNT: Starting execution of " + this);
        }
        try {
            long start = this.timeSource.currentTimeMillis();
            final Object result = this.r.execute();
            if (this.logger.level <= 300) {
                this.logger.log("QT: " + (this.timeSource.currentTimeMillis() - start) + " " + this.r.toString());
            }
            this.selectorManager.invoke(new Runnable(){

                public void run() {
                    ProcessingRequest.this.returnResult(result);
                }

                public String toString() {
                    return "return ProcessingRequest for " + ProcessingRequest.this.r + " to " + ProcessingRequest.this.c;
                }
            });
        }
        catch (Exception e) {
            this.selectorManager.invoke(new Runnable(){

                public void run() {
                    ProcessingRequest.this.returnError(e);
                }

                public String toString() {
                    return "return ProcessingRequest for " + ProcessingRequest.this.r + " to " + ProcessingRequest.this.c;
                }
            });
        }
        if (this.logger.level <= 400) {
            this.logger.log("COUNT: Done execution of " + this);
        }
    }

    @Override
    public boolean cancel() {
        this.cancelled = true;
        return !this.running;
    }
}

