/*
 * Decompiled with CFR 0.152.
 */
package rice.environment.processing;

import rice.Continuation;
import rice.p2p.commonapi.Cancellable;
import rice.selector.SelectorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkRequest<R>
implements Runnable,
Cancellable {
    private Continuation<R, Exception> c;
    private SelectorManager selectorManager;
    protected boolean cancelled = false;
    protected boolean running = false;

    public WorkRequest(Continuation<R, Exception> c, SelectorManager sm) {
        this.c = c;
        this.selectorManager = sm;
    }

    public WorkRequest() {
    }

    public void returnResult(R o) {
        this.c.receiveResult(o);
    }

    public void returnError(Exception e) {
        this.c.receiveException(e);
    }

    @Override
    public void run() {
        if (this.cancelled) {
            return;
        }
        this.running = true;
        try {
            final R result = this.doWork();
            this.selectorManager.invoke(new Runnable(){

                public void run() {
                    WorkRequest.this.returnResult(result);
                }

                public String toString() {
                    return "invc result of " + WorkRequest.this.c;
                }
            });
        }
        catch (Exception e) {
            this.selectorManager.invoke(new Runnable(){

                public void run() {
                    WorkRequest.this.returnError(e);
                }

                public String toString() {
                    return "invc error of " + WorkRequest.this.c;
                }
            });
        }
    }

    @Override
    public boolean cancel() {
        this.cancelled = true;
        return !this.running;
    }

    public abstract R doWork() throws Exception;
}

