/*
 * Decompiled with CFR 0.152.
 */
package rice.environment.logging;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import javax.swing.text.DateFormatter;
import rice.environment.logging.HeirarchyLogger;
import rice.environment.logging.InvalidLogLevelException;
import rice.environment.logging.LogManager;
import rice.environment.logging.Logger;
import rice.environment.params.ParameterChangeListener;
import rice.environment.params.Parameters;
import rice.environment.time.TimeSource;

public abstract class AbstractLogManager
implements LogManager {
    protected Hashtable<String, Logger> loggers;
    protected Parameters params;
    protected TimeSource time;
    protected PrintStream ps;
    protected String prefix;
    protected String dateFormat;
    int globalLogLevel;
    protected boolean packageOnly = true;
    protected boolean enabled;
    protected static final PrintStream nullPrintStream = new PrintStream(new NullOutputStream());
    public DateFormatter dateFormatter;
    public static final String SYSTEM_OUT = "System.out";
    public static final String SYSTEM_ERR = "System.err";

    protected AbstractLogManager(PrintStream stream, TimeSource timeSource, Parameters params, String prefix, String df) {
        this.ps = stream;
        if (this.ps == null) {
            this.ps = System.out;
            if (params.contains("logging_output_stream")) {
                String loggingType = params.getString("logging_output_stream");
                if (loggingType.equals(SYSTEM_OUT)) {
                    this.ps = System.out;
                } else if (loggingType.equals(SYSTEM_ERR)) {
                    this.ps = System.err;
                } else {
                    try {
                        this.ps = new PrintStream(new FileOutputStream(loggingType, true));
                    }
                    catch (FileNotFoundException fnfe) {
                        throw new RuntimeException(fnfe);
                    }
                }
            }
        }
        this.time = timeSource;
        this.params = params;
        this.prefix = prefix;
        this.dateFormat = df;
        if (this.dateFormat == null) {
            this.dateFormat = params.getString("logging_date_format");
        }
        if (this.dateFormat != null && !this.dateFormat.equals("")) {
            this.dateFormatter = new DateFormatter(new SimpleDateFormat(this.dateFormat));
        }
        this.enabled = params.getBoolean("logging_enable");
        if (params.contains("logging_packageOnly")) {
            this.packageOnly = params.getBoolean("logging_packageOnly");
        }
        this.loggers = new Hashtable();
        this.globalLogLevel = this.parseVal("loglevel");
        params.addChangeListener(new ParameterChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void parameterChange(String paramName, String newVal) {
                block10: {
                    block9: {
                        if (!paramName.equals("logging_enable")) break block9;
                        AbstractLogManager.this.enabled = Boolean.valueOf(newVal);
                        break block10;
                    }
                    if (paramName.equals("loglevel")) {
                        1 var3_3 = this;
                        synchronized (var3_3) {
                            AbstractLogManager.this.globalLogLevel = AbstractLogManager.this.parseVal(paramName);
                            for (HeirarchyLogger heirarchyLogger : AbstractLogManager.this.loggers.values()) {
                                if (!heirarchyLogger.useDefault) continue;
                                heirarchyLogger.level = AbstractLogManager.this.globalLogLevel;
                            }
                        }
                    }
                    if (!paramName.endsWith("_loglevel")) break block10;
                    String loggerName = paramName.substring(0, paramName.length() - "_loglevel".length());
                    if (newVal == null || newVal.equals("")) {
                        for (String string : AbstractLogManager.this.loggers.keySet()) {
                            if (!string.startsWith(loggerName)) continue;
                            HeirarchyLogger hl = (HeirarchyLogger)AbstractLogManager.this.loggers.get(string);
                            hl.useDefault = true;
                            hl.level = AbstractLogManager.this.globalLogLevel;
                        }
                    } else {
                        for (String string : AbstractLogManager.this.loggers.keySet()) {
                            if (!string.startsWith(loggerName)) continue;
                            HeirarchyLogger hl = (HeirarchyLogger)AbstractLogManager.this.loggers.get(string);
                            hl.useDefault = false;
                            hl.level = AbstractLogManager.this.parseVal(paramName);
                        }
                    }
                }
            }
        });
    }

    protected int parseVal(String key) {
        try {
            return this.params.getInt(key);
        }
        catch (NumberFormatException nfe) {
            String val = this.params.getString(key);
            if (val.equalsIgnoreCase("ALL")) {
                return Integer.MIN_VALUE;
            }
            if (val.equalsIgnoreCase("OFF")) {
                return Integer.MAX_VALUE;
            }
            if (val.equalsIgnoreCase("SEVERE")) {
                return 1000;
            }
            if (val.equalsIgnoreCase("WARNING")) {
                return 900;
            }
            if (val.equalsIgnoreCase("INFO")) {
                return 800;
            }
            if (val.equalsIgnoreCase("CONFIG")) {
                return 700;
            }
            if (val.equalsIgnoreCase("FINE")) {
                return 500;
            }
            if (val.equalsIgnoreCase("FINER")) {
                return 400;
            }
            if (val.equalsIgnoreCase("FINEST")) {
                return 300;
            }
            throw new InvalidLogLevelException(key, val);
        }
    }

    public Logger getLogger(Class clazz, String instance) {
        String loggerName;
        String className = clazz.getName();
        String[] parts = null;
        if (this.packageOnly) {
            parts = className.split("\\.");
            loggerName = parts[0];
            for (int curPart = 1; curPart < parts.length - 1; ++curPart) {
                loggerName = loggerName + "." + parts[curPart];
            }
        } else {
            loggerName = className;
        }
        if (instance != null) {
            loggerName = loggerName + "@" + instance;
        }
        if (this.loggers.containsKey(loggerName)) {
            return this.loggers.get(loggerName);
        }
        if (parts == null) {
            parts = className.split("\\.");
        }
        int level = this.globalLogLevel;
        boolean useDefault = true;
        int lastPart = parts.length;
        if (this.packageOnly) {
            --lastPart;
        }
        for (int numParts = lastPart; numParts >= 0; --numParts) {
            String searchString;
            String baseStr = parts[0];
            for (int curPart = 1; curPart < numParts; ++curPart) {
                baseStr = baseStr + "." + parts[curPart];
            }
            if (instance != null && this.params.contains(searchString = baseStr + "@" + instance + "_loglevel")) {
                level = this.parseVal(searchString);
                useDefault = false;
                break;
            }
            searchString = baseStr + "_loglevel";
            if (!this.params.contains(searchString)) continue;
            level = this.parseVal(searchString);
            useDefault = false;
            break;
        }
        Logger logger = this.constructLogger(loggerName, level, useDefault);
        this.loggers.put(loggerName, logger);
        return logger;
    }

    protected abstract Logger constructLogger(String var1, int var2, boolean var3);

    public TimeSource getTimeSource() {
        return this.time;
    }

    public PrintStream getPrintStream() {
        if (this.enabled) {
            return this.ps;
        }
        return nullPrintStream;
    }

    public String getPrefix() {
        return this.prefix;
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(int arg0) throws IOException {
        }

        public void write(byte[] buf) throws IOException {
        }

        public void write(byte[] buf, int a, int b) throws IOException {
        }

        public void close() {
        }
    }
}

