/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.mpisws.p2p.transport.ClosedChannelException;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import rice.Continuation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferReader<Identifier>
implements P2PSocketReceiver<Identifier> {
    boolean readSize = false;
    int size = -1;
    ByteBuffer buf;
    Continuation<ByteBuffer, Exception> continuation;

    public BufferReader(P2PSocket<Identifier> socket, Continuation<ByteBuffer, Exception> continuation) {
        this(socket, continuation, -1);
    }

    public BufferReader(P2PSocket<Identifier> socket, Continuation<ByteBuffer, Exception> continuation, int size) {
        this.continuation = continuation;
        this.size = size;
        this.buf = size < 0 ? ByteBuffer.allocate(4) : ByteBuffer.allocate(size);
        try {
            this.receiveSelectResult(socket, true, false);
        }
        catch (IOException ioe) {
            this.receiveException(socket, ioe);
        }
    }

    @Override
    public void receiveException(P2PSocket<Identifier> socket, Exception ioe) {
        this.continuation.receiveException(ioe);
    }

    @Override
    public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
        if (socket.read(this.buf) < 0L) {
            this.receiveException(socket, new ClosedChannelException("Unexpected closure of channel to " + socket.getIdentifier()));
            return;
        }
        if (this.buf.hasRemaining()) {
            socket.register(true, false, this);
            return;
        }
        this.buf.flip();
        if (this.size < 0) {
            this.size = this.buf.asIntBuffer().get();
            this.buf = ByteBuffer.allocate(this.size);
            this.receiveSelectResult(socket, true, false);
        } else {
            this.continuation.receiveResult(this.buf);
        }
    }
}

