/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.table;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.table.TableStore;
import org.mpisws.p2p.transport.table.TableTransportLayer;
import org.mpisws.p2p.transport.table.UnknownValueException;
import org.mpisws.p2p.transport.util.BufferReader;
import org.mpisws.p2p.transport.util.BufferWriter;
import org.mpisws.p2p.transport.util.DefaultErrorHandler;
import org.mpisws.p2p.transport.util.Serializer;
import org.mpisws.p2p.transport.util.SocketRequestHandleImpl;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.Cancellable;
import rice.p2p.util.rawserialization.SimpleInputBuffer;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableTransprotLayerImpl<Identifier, Key, Value>
implements TableTransportLayer<Identifier, Key, Value>,
TransportLayerCallback<Identifier, ByteBuffer> {
    public static final byte PASSTHROUGH = 0;
    public static final byte REQUEST = 1;
    public static final byte RESPONSE_SUCCESS = 2;
    public static final byte RESPONSE_FAILED = 3;
    protected TableStore<Key, Value> knownValues;
    protected TransportLayerCallback<Identifier, ByteBuffer> callback;
    protected TransportLayer<Identifier, ByteBuffer> tl;
    protected Serializer<Key> keySerializer;
    protected Serializer<Value> valueSerializer;
    protected ErrorHandler<Identifier> errorHandler;
    protected Logger logger;

    public TableTransprotLayerImpl(Serializer<Key> iSerializer, Serializer<Value> cSerializer, TableStore<Key, Value> tableStore, TransportLayer<Identifier, ByteBuffer> tl, Environment env) {
        this.keySerializer = iSerializer;
        this.valueSerializer = cSerializer;
        this.knownValues = tableStore;
        this.tl = tl;
        this.logger = env.getLogManager().getLogger(this.getClass(), null);
        this.errorHandler = new DefaultErrorHandler(this.logger);
    }

    @Override
    public Cancellable requestValue(final Identifier source, final Key principal, final Continuation<Value, Exception> c, Map<String, Object> options) {
        if (this.logger.level <= 500) {
            this.logger.log("requestValue(" + source + "," + principal + ")");
        }
        if (this.knownValues.containsKey(principal)) {
            if (c != null) {
                c.receiveResult(this.knownValues.get(principal));
            }
            return null;
        }
        if (this.logger.level <= 400) {
            this.logger.log("requestValue(" + source + "," + principal + ") opening socket");
        }
        return this.tl.openSocket(source, new SocketCallback<Identifier>(){

            @Override
            public void receiveResult(SocketRequestHandle<Identifier> cancellable, P2PSocket<Identifier> sock) {
                try {
                    SimpleOutputBuffer sob = new SimpleOutputBuffer();
                    TableTransprotLayerImpl.this.keySerializer.serialize(principal, sob);
                    SimpleOutputBuffer sob2 = new SimpleOutputBuffer();
                    sob2.writeByte((byte)1);
                    sob2.writeInt(sob.getWritten());
                    sob2.write(sob.getBytes());
                    new BufferWriter(sob2.getByteBuffer(), sock, new Continuation<P2PSocket<Identifier>, Exception>(){

                        @Override
                        public void receiveException(Exception exception) {
                            c.receiveException(exception);
                        }

                        @Override
                        public void receiveResult(P2PSocket<Identifier> result) {
                            new BufferReader(result, new Continuation<ByteBuffer, Exception>(){

                                @Override
                                public void receiveResult(ByteBuffer result) {
                                    try {
                                        SimpleInputBuffer sib = new SimpleInputBuffer(result);
                                        byte response = sib.readByte();
                                        switch (response) {
                                            case 2: {
                                                Object value = TableTransprotLayerImpl.this.valueSerializer.deserialize(sib);
                                                if (TableTransprotLayerImpl.this.logger.level <= 400) {
                                                    TableTransprotLayerImpl.this.logger.log("requestValue(" + source + "," + principal + ") got value " + value);
                                                }
                                                TableTransprotLayerImpl.this.knownValues.put(principal, value);
                                                c.receiveResult(value);
                                                break;
                                            }
                                            case 3: {
                                                c.receiveException(new UnknownValueException(source, principal));
                                                break;
                                            }
                                            default: {
                                                c.receiveException(new IllegalStateException("Unknown response:" + response));
                                                break;
                                            }
                                        }
                                    }
                                    catch (Exception ioe) {
                                        c.receiveException(ioe);
                                    }
                                }

                                @Override
                                public void receiveException(Exception exception) {
                                    c.receiveException(exception);
                                }
                            });
                        }
                    }, false);
                }
                catch (IOException ioe) {
                    c.receiveException(ioe);
                }
            }

            @Override
            public void receiveException(SocketRequestHandle<Identifier> s, Exception ex) {
                c.receiveException(ex);
            }
        }, options);
    }

    @Override
    public SocketRequestHandle<Identifier> openSocket(Identifier i, final SocketCallback<Identifier> deliverSocketToMe, Map<String, Object> options) {
        final SocketRequestHandleImpl<Identifier> ret = new SocketRequestHandleImpl<Identifier>(i, options, this.logger);
        ret.setSubCancellable(this.tl.openSocket(i, new SocketCallback<Identifier>(){

            @Override
            public void receiveException(SocketRequestHandle<Identifier> s, Exception ex) {
                deliverSocketToMe.receiveException(ret, ex);
            }

            @Override
            public void receiveResult(SocketRequestHandle<Identifier> cancellable, P2PSocket<Identifier> sock) {
                ByteBuffer writeMe = ByteBuffer.allocate(1);
                writeMe.put((byte)0);
                writeMe.clear();
                new BufferWriter(writeMe, sock, new Continuation<P2PSocket<Identifier>, Exception>(){

                    @Override
                    public void receiveException(Exception exception) {
                        deliverSocketToMe.receiveException(ret, exception);
                    }

                    @Override
                    public void receiveResult(P2PSocket<Identifier> result) {
                        deliverSocketToMe.receiveResult(ret, result);
                    }
                }, false);
            }
        }, options));
        return ret;
    }

    @Override
    public void incomingSocket(final P2PSocket<Identifier> sock) throws IOException {
        if (this.logger.level <= 300) {
            this.logger.log("incomingSocket() from " + sock);
        }
        new BufferReader<Identifier>(sock, new Continuation<ByteBuffer, Exception>(){

            @Override
            public void receiveResult(ByteBuffer result) {
                byte type = result.get();
                if (TableTransprotLayerImpl.this.logger.level <= 300) {
                    TableTransprotLayerImpl.this.logger.log("incomingSocket() from " + sock + " " + type);
                }
                switch (type) {
                    case 0: {
                        try {
                            TableTransprotLayerImpl.this.callback.incomingSocket(sock);
                        }
                        catch (IOException ioe) {
                            TableTransprotLayerImpl.this.errorHandler.receivedException(sock.getIdentifier(), ioe);
                        }
                        return;
                    }
                    case 1: {
                        TableTransprotLayerImpl.this.handleValueRequest(sock);
                        return;
                    }
                }
                TableTransprotLayerImpl.this.errorHandler.receivedUnexpectedData(sock.getIdentifier(), new byte[]{type}, 0, sock.getOptions());
                sock.close();
            }

            @Override
            public void receiveException(Exception exception) {
                TableTransprotLayerImpl.this.errorHandler.receivedException(sock.getIdentifier(), exception);
            }
        }, 1);
    }

    public void handleValueRequest(final P2PSocket<Identifier> sock) {
        if (this.logger.level <= 400) {
            this.logger.log("handleValueRequest() from " + sock);
        }
        new BufferReader<Identifier>(sock, new Continuation<ByteBuffer, Exception>(){

            @Override
            public void receiveResult(ByteBuffer result) {
                try {
                    ByteBuffer writeMe;
                    SimpleInputBuffer sib = new SimpleInputBuffer(result);
                    Object principal = TableTransprotLayerImpl.this.keySerializer.deserialize(sib);
                    if (TableTransprotLayerImpl.this.knownValues.containsKey(principal)) {
                        SimpleOutputBuffer sob = new SimpleOutputBuffer();
                        sob.writeByte((byte)2);
                        TableTransprotLayerImpl.this.valueSerializer.serialize(TableTransprotLayerImpl.this.knownValues.get(principal), sob);
                        writeMe = sob.getByteBuffer();
                    } else {
                        writeMe = ByteBuffer.allocate(1);
                        writeMe.put((byte)3);
                        writeMe.clear();
                    }
                    new BufferWriter(writeMe, sock, null);
                }
                catch (Exception ioe) {
                    TableTransprotLayerImpl.this.errorHandler.receivedException(sock.getIdentifier(), ioe);
                    sock.close();
                }
            }

            @Override
            public void receiveException(Exception exception) {
                TableTransprotLayerImpl.this.errorHandler.receivedException(sock.getIdentifier(), exception);
            }
        });
    }

    @Override
    public boolean hasKey(Key i) {
        return this.knownValues.containsKey(i);
    }

    @Override
    public void acceptMessages(boolean b) {
        this.tl.acceptMessages(b);
    }

    @Override
    public void acceptSockets(boolean b) {
        this.tl.acceptSockets(b);
    }

    @Override
    public Identifier getLocalIdentifier() {
        return this.tl.getLocalIdentifier();
    }

    @Override
    public MessageRequestHandle<Identifier, ByteBuffer> sendMessage(Identifier i, ByteBuffer m, MessageCallback<Identifier, ByteBuffer> deliverAckToMe, Map<String, Object> options) {
        return this.tl.sendMessage(i, m, deliverAckToMe, options);
    }

    @Override
    public void setCallback(TransportLayerCallback<Identifier, ByteBuffer> callback) {
        this.callback = callback;
    }

    @Override
    public void setErrorHandler(ErrorHandler<Identifier> handler) {
        this.errorHandler = handler;
    }

    @Override
    public void destroy() {
        this.tl.destroy();
    }

    @Override
    public void messageReceived(Identifier i, ByteBuffer m, Map<String, Object> options) throws IOException {
        this.callback.messageReceived(i, m, options);
    }
}

