/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.sourceroute;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.sourceroute.SourceRoute;
import rice.environment.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Forwarder<Identifier> {
    SourceRoute sr;
    P2PSocket<Identifier> socka;
    P2PSocket<Identifier> sockb;
    Logger logger;

    public Forwarder(SourceRoute<Identifier> sr, P2PSocket<Identifier> socka, P2PSocket<Identifier> sockb, Logger logger) {
        this.sr = sr;
        this.socka = socka;
        this.sockb = sockb;
        this.logger = logger;
        new HalfPipe(socka, sockb);
        new HalfPipe(sockb, socka);
    }

    private class HalfPipe
    implements P2PSocketReceiver {
        P2PSocket from;
        P2PSocket to;
        ByteBuffer buf;
        boolean shutdownTo = false;

        public HalfPipe(P2PSocket from, P2PSocket to) {
            this.from = from;
            this.to = to;
            this.buf = ByteBuffer.allocate(1024);
            from.register(true, false, this);
        }

        public String toString() {
            return "HalfPipe " + this.from + "=>" + this.to;
        }

        public void receiveException(P2PSocket socket, Exception e) {
            if (Forwarder.this.logger.level <= 500) {
                Forwarder.this.logger.logException(this + " " + socket, e);
            }
            this.from.close();
            this.to.close();
        }

        public void receiveSelectResult(P2PSocket socket, boolean canRead, boolean canWrite) throws IOException {
            if (canRead) {
                if (socket != this.from) {
                    throw new IOException("Expected to read from " + this.from + " got " + socket);
                }
                long result = this.from.read(this.buf);
                if (result == -1L) {
                    if (Forwarder.this.logger.level <= 500) {
                        Forwarder.this.logger.log(this.from + " has shut down input, shutting down output on " + this.to);
                    }
                    this.shutdownTo = true;
                    return;
                }
                if (Forwarder.this.logger.level <= 400) {
                    Forwarder.this.logger.log("Read " + result + " bytes from " + this.from);
                }
                this.buf.flip();
                this.to.register(false, true, this);
            } else if (canWrite) {
                if (socket != this.to) {
                    throw new IOException("Expected to write to " + this.to + " got " + socket);
                }
                long result = this.to.write(this.buf);
                if (result == -1L) {
                    if (Forwarder.this.logger.level <= 500) {
                        Forwarder.this.logger.log(this.to + " has closed, closing " + this.from);
                    }
                    this.from.close();
                }
                if (Forwarder.this.logger.level <= 400) {
                    Forwarder.this.logger.log("Wrote " + result + " bytes to " + this.to);
                }
                if (this.buf.hasRemaining()) {
                    this.to.register(false, true, this);
                } else {
                    if (this.shutdownTo) {
                        this.to.shutdownOutput();
                        return;
                    }
                    this.buf.clear();
                    this.from.register(true, false, this);
                }
            } else {
                throw new IOException("Didn't select for either " + socket + "," + canRead + "," + canWrite);
            }
        }
    }
}

