/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.simpleidentity;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Map;
import org.mpisws.p2p.transport.simpleidentity.Serializer;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InetSocketAddressSerializer
implements Serializer<InetSocketAddress>,
org.mpisws.p2p.transport.util.Serializer<InetSocketAddress> {
    public static final byte IPV4 = 4;
    public static final byte IPV6 = 6;
    public static final int IPV4_BYTES = 4;
    public static final int IPV6_BYTES = 16;

    @Override
    public InetSocketAddress deserialize(InputBuffer b, InetSocketAddress i, Map<String, Object> options) throws IOException {
        return InetSocketAddressSerializer.deserializeAddress(b);
    }

    @Override
    public void serialize(InetSocketAddress i, OutputBuffer b) throws IOException {
        InetSocketAddressSerializer.serializeAddress(i, b);
    }

    public static InetSocketAddress deserializeAddress(InputBuffer b) throws IOException {
        byte[] addr;
        byte version = b.readByte();
        switch (version) {
            case 4: {
                addr = new byte[4];
                break;
            }
            case 6: {
                addr = new byte[16];
                break;
            }
            default: {
                throw new IOException("Incorrect IP version, expecting 4 or 6, got " + version);
            }
        }
        b.read(addr);
        short port = b.readShort();
        return new InetSocketAddress(InetAddress.getByAddress(addr), 0xFFFF & port);
    }

    public static void serializeAddress(InetSocketAddress i, OutputBuffer b) throws IOException {
        byte[] addr = i.getAddress().getAddress();
        switch (addr.length) {
            case 4: {
                b.writeByte((byte)4);
                break;
            }
            case 16: {
                b.writeByte((byte)6);
                break;
            }
            default: {
                throw new IOException("Incorrect number of bytes for IPaddress, expecting 4 or 16, got " + addr.length);
            }
        }
        b.write(addr, 0, addr.length);
        b.writeShort((short)i.getPort());
    }

    public int getSerializedLength(InetSocketAddress i) {
        return i.getAddress().getAddress().length + 2 + 1;
    }

    @Override
    public InetSocketAddress deserialize(InputBuffer buf) throws IOException {
        return InetSocketAddressSerializer.deserializeAddress(buf);
    }
}

